<?php

    // Credentials

    session_name('USERSESSID');

    session_start(); // Initiate Session

    require('../config/config.php'); // Configuration File

    require('../engines/fxns.php'); // Function Definition(s)
    
    require('../../vendor/autoload.php'); // Composer Package File

    require('../engines/mail-delivery-engine.php'); // Mail Delivery Fxns

    require('../engines/mail-drafts.php'); // Mail Mail Drafts

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        if (!isset($_SESSION['USER-ID'])) {

            echo json_encode(['refresh' => true]); // Encode JSON Response

            exit; // End Run

        }

        $user = $_SESSION['USER-ID'];

        $token = $_COOKIE['ACCESS-iD'] ?? null;

        setTimezone($conn, $token, $user, 'USER');

        $userData = userData($user, $conn); // Get User Data

        if (!$userData) {

            echo json_encode(['refresh' => true]); // Encode JSON Response

            exit; // End Run

        }

        $email = $userData['email'];

        $fname = $userData['firstname'];

        $name = join(' ', [$fname, $userData['lastname']]);

        $code = generateOTP($user, $conn); // Genrate OTP
        
        $delivered = false; // Mail Delivery Flag

        // Send Email

        $subject = 'Authenticate Transfer #' . mt_rand(10000000, 99999999);

        $mail = transferOTP($userData['firstname'], $code);

        $deliver = @deliverByPHPMailer($subject, $mail, makePlain($mail), $userData['email'], join(' ', [$userData['firstname'], $userData['lastname']]));

        if (!$deliver) {

            @deliverByPHPMail($userData['email'], $subject, $mail); // Fallback

        }

        // Send Email

        echo json_encode(['codeSent' => $delivered]);

    }

?>