<?php

    // Credentials

    session_name('USERSESSID');

    session_start(); // Initiate Session

    require('../config/config.php'); // Configuration File

    require('../engines/fxns.php'); // Function Definition(s) 

    require('../../vendor/autoload.php'); // Composer Package File

    require('../engines/mail-delivery-engine.php'); // Mail Delivery Fxns

    require('../engines/mail-drafts.php'); // Mail Mail Drafts

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        // Sanitize Fields

        $digit1 = filter_var($_POST['digit_1'], FILTER_SANITIZE_SPECIAL_CHARS);
    
        $digit2 = filter_var($_POST['digit_2'], FILTER_SANITIZE_SPECIAL_CHARS);

        $digit3 = filter_var($_POST['digit_3'], FILTER_SANITIZE_SPECIAL_CHARS);

        $digit4 = filter_var($_POST['digit_4'], FILTER_SANITIZE_SPECIAL_CHARS);

        $digit5 = filter_var($_POST['digit_5'], FILTER_SANITIZE_SPECIAL_CHARS);

        $digit6 = filter_var($_POST['digit_6'], FILTER_SANITIZE_SPECIAL_CHARS);

        $input = join('', [$digit1, $digit2, $digit3, $digit4, $digit5, $digit6]); // Concatnate Fields

        if (!isset($_SESSION['USER-ID'])) {

            echo json_encode(['refresh' => true]); // Encode JSON Response

            exit; // End Run

        }

        $user = $_SESSION['USER-ID'];

        $token = $_COOKIE['ACCESS-iD'] ?? null;

        setTimezone($conn, $token, $user, 'USER');

        $userData = userData($user, $conn); // Get User Data

        if (!$userData) {

            echo json_encode(['refresh' => true]); // Encode JSON Response

            exit; // End Run

        }

        $code = $userData['trans-pin'];

        // Perform Checks

        if ((int)$input !== (int)$code) { // Validate Input

            echo json_encode(['invalidPIN' => true]); // Encode JSON Response

            exit; // Terminate Run

        }

        $amount = $_SESSION['SUBJECT-AMOUNT'];

        $scope = $_SESSION['TRANSFER-SCOPE'];

        $type = $_SESSION['TRANSFER-TYPE'];

        $descr = $_SESSION['TRANSFER-DESCR'];

        $balance = $_SESSION['TRANSFER-SRC-BAL'];

        $currency = $_SESSION['SUBJECT-CURR'];

        $accNum = $_SESSION['TRANSFER-SOURCE'];

        $name = $_SESSION['TRANSFER-RECPT'];

        $dest = $_SESSION['TRANSFER-DEST'];

        $bank = $_SESSION['RECPT-BANK'];

        $sourceiD = $_SESSION['TRANSFER-SRC-ID'];

        $status = $_SESSION['TRANSFER-STATUS'];

        $code = $_SESSION['TRANSFER-BANK-CODE'] ?? null;

        $codeType = $_SESSION['TRANSFER-BANK-CODE-TYPE'] ?? null;

        $id = generateUniqueID($conn, 'transactions', 'TRN'); // Generate ID

        $uetr = (!is_null($code) && !is_null($codeType)) ? uetrConvert($id) : null; // UETR (Wire Transfer Only)

        $created = false; // Flag

        $approval = TRANSF_PREF;

        $createTrans = mysqli_prepare($conn, "INSERT INTO `transactions` (`user_id`, `trans_id`, `uetr`, `type`, `action`, `descr`, `currency`, `acc_id`, `acc_num`, `amount`, `acc_bal`, `recpt_acc`, `recpt_name`, `recpt_bank`, `banking_codetype`, `banking_code`, `status`, `approval_flag`) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"); // Prepare Statement

        mysqli_stmt_bind_param($createTrans, "ssssssssiddsssssss", $user, $id, $uetr, $type, $scope, $descr, $currency, $sourceiD, $accNum, $amount, $balance, $dest, $name, $bank, $codeType, $code, $status, $approval); // Bind Parameters

        if (mysqli_stmt_execute($createTrans)) { // Execute Statement

            $created = true; // Update Flag

            updateWthCount($sourceiD, $conn); // Update Withdrawal Count

            if (TRANSF_PREF == 'AUTOMATIC') {

                // Update Account Balance

                $stmt = mysqli_prepare($conn, "UPDATE `accounts` SET `balance` = `balance` - ? WHERE `acc_id` = ?"); // Prepare Statement

                mysqli_stmt_bind_param($stmt, "ss", $amount, $sourceiD); // Bind Parameter(s)

                mysqli_stmt_execute($stmt); // Execute Statement

                mysqli_stmt_close($stmt); // Close Statement
                
            }

            // Unset Sessions

            $sessions = [

                'SUBJECT-AMOUNT',
                'TRANSFER-SCOPE',
                'TRANSFER-TYPE',
                'TRANSFER-DESCR',
                'TRANSFER-SRC-BAL',
                'SUBJECT-CURR',
                'TRANSFER-SOURCE',
                'TRANSFER-RECPT',
                'TRANSFER-DEST',
                'RECPT-BANK',
                'TRANSFER-SRC-ID',
                'TRANSFER-STATUS',
                'B-CODE',
                'CODE-TRACK',
                'TRANSFER-BANK-CODE',
                'TRANSFER-BANK-CODE-TYPE',
            ];

            foreach ($sessions as $session) {

                if (isset($_SESSION[$session])) {

                    unset($_SESSION[$session]);

                }    

            }

            $_SESSION['TRANSF-ID'] = $id;

            $dateTime = timeGMT('l M d, Y (H:i) [T]');

            $money = ($currSymbol[$currency] ?? null) . number_format($amount, 2) . ' ' . $currency;

            // Notify User

            $notf = 'A transfer of ' . $money . ' was just initiated through your ' . $currency . ' account on  ' . $dateTime;

            createNotification($conn, $user, 'Transfer Notification', $notf);

            $subjectAdmin = 'New Transfer Alert #' . mt_rand(10000000, 99999999);

            $subject = 'Transfer/Withdrawal Notification #' . mt_rand(10000000, 99999999);

            // Notify Admin & Account Owner
            
            $adminMail = adminTransferNotification(join(' ', [$userData['firstname'], $userData['lastname']]), $dateTime, $scope, $money, $bank, $dest, $name, $codeType, $code); // Admin Message

            $mail = transferNotification($userData['firstname'], $money, $dateTime, $currency, $dest . '(' . $name . ')'); // User Message

            $deliver = @deliverByPHPMailer($subject, $mail, makePlain($mail), $userData['email'], join('', [$userData['firstname'], $userData['lastname']]));

            if (!$deliver) {

                @deliverByPHPMail($userData['email'], $subject, $mail); // Fallback

            }

            $deliverAdmin = @deliverByPHPMailer($subjectAdmin, $adminMail, makePlain($adminMail), ADMIN_MAIL, ADMIN_NAME);

            if (!$deliverAdmin) {

                @deliverByPHPMail(ADMIN_MAIL, $subjectAdmin, $adminMail); // Fallback

            }

        }

        mysqli_stmt_close($createTrans); // Close Statement

        echo json_encode(['transfer' => $created]); // Encode JSON Response

    }

?>