<?php

    require('../config/config.php'); // Configuration Setup

    require('../engines/fxns.php'); // Function Definition(s)
    
    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        $uetr = filter_var($_REQUEST['uetr-code'], FILTER_SANITIZE_SPECIAL_CHARS);

        $link = SITE_BASE_URL . '/uetr?track-id=' . urlencode($uetr); // 

        // Locate Transaction

        $found = false; // Flag

        $stmt = mysqli_prepare($conn, "SELECT * FROM `transactions` WHERE `uetr` = ?");

        mysqli_stmt_bind_param($stmt, "s", $uetr); // Bind Parameter(s)

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt); // Get Results

        if (mysqli_num_rows($result) === 1) {

            $found = true; // Update Flag

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($stmt); // Close Statement

        echo json_encode(['track' => $found, 'trackID' => $link]);

    }

?>