<?php

    // Credentials

    require('../config/config.php'); // Configuration Setup

    require('../engines/fxns.php'); // Function Definition(s)
    
    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        $id = filter_var($_REQUEST['tpy-id'], FILTER_SANITIZE_SPECIAL_CHARS);

        $status = filter_var($_REQUEST['account-status'], FILTER_SANITIZE_SPECIAL_CHARS);

        $wLimit = filter_var($_REQUEST['wth-limit'], FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION);

        $tLimit = filter_var($_REQUEST['trans-limit'], FILTER_SANITIZE_NUMBER_INT);

        $barredList = null;

        if (isset($_REQUEST['barred']) && is_array($_REQUEST['barred'])) {

            $barred = array_map('htmlspecialchars', $_REQUEST['barred']);
            
            $barredList = implode(', ', $barred); // Join Into Comma-Separated String

        }

        // Commence Data Upload

        $updated = false; // Flag

        $stmt = mysqli_prepare($conn, "UPDATE `third_party` SET `status` = ?, `wth_limit` = ?, `trans_limit` = ?, `no_access` = ? WHERE `tp_id` = ?"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "sdiss", $status, $wLimit, $tLimit, $barredList, $id); // Bind Parameter(s)

        if (mysqli_stmt_execute($stmt)) { // Execute Statement

            $updated = true; // Update Flag

        }

        mysqli_stmt_close($stmt); // Close Statement

        echo json_encode(['updated' => $updated]); // Encode JSON Response

    }

?>