<?php

    // Credentials

    require('../config/config.php'); // Configuration Setup

    require('../engines/fxns.php'); // Function Definition(s)

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        // Sanitize Field(s)

        $id = filter_var($_REQUEST['tpy-id'], FILTER_SANITIZE_SPECIAL_CHARS);

        $fname = filter_var($_REQUEST['fname'], FILTER_SANITIZE_SPECIAL_CHARS);

        $mname = !empty($_REQUEST['mname']) ? filter_var($_REQUEST['mname'], FILTER_SANITIZE_SPECIAL_CHARS) : null;

        $lname = filter_var($_REQUEST['lname'], FILTER_SANITIZE_SPECIAL_CHARS);

        $gender = filter_var($_REQUEST['gender'], FILTER_SANITIZE_SPECIAL_CHARS);

        $title = !empty($_REQUEST['title']) ? filter_var($_REQUEST['title'], FILTER_SANITIZE_SPECIAL_CHARS) : null;

        // Commence Data Update

        $updated = false; // Flag

        $stmt = mysqli_prepare($conn, "UPDATE `third_party` SET `fname` = ?, `mname` = ?, `lname` = ?, `gender` = ?, `title` = ? WHERE `tp_id` = CAST(? AS BINARY)"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "ssssss", $fname, $mname, $lname, $gender, $title, $id); // Bind Parameter(s)

        if (mysqli_stmt_execute($stmt)) { // Execute Statement

            $updated = true; // Update Flag

        }

        mysqli_stmt_execute($stmt); // Close Statement

        echo json_encode(['updated' => $updated]); // Encode JSON Response

    }

?>