<?php

    // Credentials

    require('../config/config.php'); // Configuration File

    header('Content-Type: application/json'); // Specify Communication Procotol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        $password = $_POST['v-password'];

        $specialChars = "~`!@#%^&*()_-+={}[]:;\"'|?/"; 

        $response = [
            'length' => strlen($password) >= 8,
            'upperCase' => preg_match('/[A-Z]/', $password),
            'lowerCase' => preg_match('/[a-z]/', $password),
            'number' => preg_match('/\d/', $password),
            'specialChar' => preg_match('/[' . preg_quote($specialChars, '/') . ']/', $password)
        ]; // Password Criteria

        $response['valid'] = !in_array(false, $response);

        echo json_encode($response);

        exit(); // End Run

    }

?>