<?php

    // Credentials

    session_name('USERSESSID');

    session_start(); // Initiate Sessions

    require('../config/config.php'); // Configuration File

    require('../engines/fxns.php'); // Functions File

    require('../../vendor/autoload.php'); // Composer Package File

    require('../engines/mail-delivery-engine.php'); // Mail Delivery Fxns

    require('../engines/mail-drafts.php'); // Mail Drafts

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        if (!isset($_SESSION['USER-ID'])) {

            echo json_encode(['refresh' => true]);

            exit;

        }

        $user = $_SESSION['USER-ID'];

        $userData = userData($user, $conn); // Get User Info 

        if (!$userData) {

            echo json_encode(['refresh' => true]); // Encode JSON Response

            exit;

        }

        // Check KYC

        if ($userData['kyc-status'] == 'PROCESSING') {

            echo json_encode(['kycPending' => true]);

            exit;

        }
        
        if ($userData['kyc-status'] != 'VERIFIED') {

            echo json_encode(['kycError' => true]);

            exit;

        }

        // Sanitize Fields

        $provider = filter_var($_REQUEST['provider'], FILTER_SANITIZE_SPECIAL_CHARS);

        $accID = filter_var($_REQUEST['currency'], FILTER_SANITIZE_SPECIAL_CHARS);

        $accountData = accountData($accID, $user, $conn); // Get Account Data
        
        if (!$accountData) {

            echo json_encode(['refresh' => true]);

            exit;

        }

        $currency = $accountData['currency'];

        $balance = $accountData['balance'];

        $accNum = $accountData['acc-number'];

        $cardFee = CARD_FEE;

        // Look If Card Exists

        $cardExists = false;

        $stmt = mysqli_prepare($conn, "SELECT * FROM `virtual_cards` WHERE `currency` = ? AND `user_id` = ?"); // Prepare Stament (Look for Card)

        mysqli_stmt_bind_param($stmt, "ss", $currency, $user); // Bind Parameter(s)

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt); // Get Statement Result

        if (mysqli_num_rows($result) > 0) {

            $cardExists = true;

        }

        mysqli_free_result($result); // Free Result
        
        mysqli_stmt_close($stmt); // Close Statement

        // Check Flag

        if ($cardExists) {

            echo json_encode(['cardExists' => true, 'card' => $currency]);

            exit;

        }

        if ($currency != 'USD') { // Convert USD Card Fee

            $cardFee = convertFromUSD($cardFee, $currency);

            if (!$cardFee) {

                echo json_encode(['convError' => true]);
    
                exit;
    
            }

        }

        if (CARD_PREF == 'AUTOMATIC') {

            if ($balance < $cardFee) {

                echo json_encode(['fundError' => true]);

                exit; 

            }

            $newBal = $balance - $cardFee; // Calculate New Balance

            $created = false; // Flag

            // Create Card, Update Balance & Create Transaction

            $stmt1 = mysqli_prepare($conn, "INSERT INTO `virtual_cards` (`card_id`, `user_id`, `provider`, `currency`, `card_number`, `cvv`, `expires`, `color`) VALUES (?, ?, ?, ?, ?, ?, ?, ?)"); // Prepare Statement (Create Card)

            // $stmt1 Parameter(s)

            $cardID = generateUniqueID($conn, 'virtual_cards', 'VRT'); // Generate ID

            $cardNum = generateCardNumber($provider); // Generate Card Number

            $cvv = generateCVV();

            $duration = 1095; // 3 years (in days)

            $expires = strtotime("+$duration days"); // 3 years from now

            // Create a DateTime object
            $date = new DateTime();
            $date->setTimestamp($expires);

            // Move to the last day of the month
            $date->modify('last day of this month');

            $expires = $date->format('Y-m-d');

            $color = generateRGB();

            mysqli_stmt_bind_param($stmt1, "ssssssss", $cardID, $user, $provider, $currency, $cardNum, $cvv, $expires, $color); // Bind Parameter(s)

            $stmt2 = mysqli_prepare($conn, "UPDATE `accounts` SET `balance` = ? WHERE `acc_id` = ? AND `user_id` = ?"); // Prepare Statement (For Account Balance Update)

            mysqli_stmt_bind_param($stmt2, "dss", $newBal, $accID, $user); // Bind Parameter(s)

            $stmt3 = mysqli_prepare($conn, "INSERT INTO `transactions` (`user_id`, `trans_id`, `descr`, `type`, `action`, `currency`, `acc_id`, `acc_num`, `amount`, `acc_bal`, `status`) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"); // Prepare Statement

            // $stmt3 Parameter(s)

            $transID = generateUniqueID($conn, 'transactions', 'TRN'); // Generate ID

            $transcType = 'DEBIT';

            $transcAction = 'MISCELLANOUS';

            $transcStatus = 'COMPLETED';

            $transcDescr = 'VIRTUAL CARD (' . $provider . ')';

            mysqli_stmt_bind_param($stmt3, "sssssssidds", $user, $transID, $transcDescr, $transcType, $transcAction, $currency, $accID, $accNum, $cardFee, $newBal, $transcStatus); // Bind Parameter(s)

            if (mysqli_stmt_execute($stmt1) && mysqli_stmt_execute($stmt2) && mysqli_stmt_execute($stmt3)) {

                $created = true; // Update Flag

            }

            // Close Statement

            mysqli_stmt_close($stmt1);

            mysqli_stmt_close($stmt2);

            mysqli_stmt_close($stmt3);

            echo json_encode(['cardCreated' => $created]);

        } else if (CARD_PREF == 'MANUAL') {
                
            // Set Payment Essentials

            $_SESSION['PAY'] = $provider . ' (CARD)';

            $_SESSION['PAY-AMOUNT'] = $cardFee;

            $_SESSION['PAY-DESC'] = $provider;

            $_SESSION['SUBJECT-CURR'] = $currency;

            echo json_encode(['pay' => true]);

        }
    }
 

?>