<?php

    require('../partials/header.php');

    blockThirdParty(); // Block Third Party Users

    // Fetch Cards

    $foundCard = false; // Flag

    $stmt = mysqli_prepare($conn, "SELECT * FROM `virtual_cards` WHERE `user_id` = ? "); // Prepare Statement

    mysqli_stmt_bind_param($stmt, "s", $user_id); // Bind Parameter(s)

    mysqli_stmt_execute($stmt); // Execute Statement

    $result = mysqli_stmt_get_result($stmt); // Get Statement Result

    if (mysqli_num_rows($result) > 0) { // Consider Result's Mass

        $foundCard = true; // Update Flag

        $data = mysqli_fetch_all($result, MYSQLI_ASSOC); // Get Result Data

    }

    mysqli_free_result($result); // Free Result

    mysqli_stmt_close($stmt); // Close Statement


    // Check Flag

    if ($foundCard) { ?>

        <section id="cards">

            <div class="dash_banner">

                <div class="dashBanner_header">
                    
                    <div class="dhb_Bitem">
                        
                        <h4 class="dashBanner_title">Virtual Cards</h4>

                    </div>

                    <?php
                    
                        if (is_null(MAX_CARD) || vCardCount($user_id, $conn) < MAX_CARD) { ?>

                            <div class="dhb_Bitem btn_con">

                                <button class="pg_btn variantMichb" iQ-target="#iQ_vCard">

                                    <span>Add Virtual Card</span>

                                    <div class="pgBtn_icon">

                                        <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M2 8H14" stroke="white" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path><path d="M8 14V2" stroke="white" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path></svg>

                                    </div>

                                </button>

                            </div>

                        <?php }
                    
                    ?>
                    
                </div>

                <div class="xGrid">

                    <?php

                        // Iterate Through Records  
                    
                        foreach ($data as $row):

                            $id = $row['card_id'];

                            $provider = $row['provider'];

                            $number = $row['card_number'];

                            $cvv = $row['cvv'];

                            $currency = $row['currency'];

                            $balance = $row['balance'] ?? 0;

                            $balance = number_format($balance, 2);

                            $expires = date('m/y', strtotime($row['expires']));

                            $color = $row['color'];

                            $status = $row['status'];

                            $fund = $row['fund_by'];

                            $symbol = '<span translate="no">' . $currSymbol[$currency] . '</span>';

                            $class = '';

                            if ($status != 'ACTIVE') {

                                $class = ' inaccessible';

                            }

                            if ($provider == 'AMEX') {

                                $logo = '<svg xmlns="http://www.w3.org/2000/svg" width="800px" height="800px" viewBox="0 0 24 24">
                                                        <path fill="#002663" fill-rule="evenodd" d="M4.31351102,11.9651322 L3.49408345,9.96838176 L2.67933919,11.9651322 L4.31351102,11.9651322 Z M12.1730058,14.1264026 L12.1684736,10.2036046 L10.4324776,14.1264026 L9.38130189,14.1264026 L7.64077369,10.2001299 L7.64077369,14.1264026 L5.20575645,14.1264026 L4.74573489,13.0092074 L2.25300723,13.0092074 L1.78830236,14.1264026 L0.488004966,14.1264026 L2.63190183,9.11768179 L4.41065186,9.11768179 L6.44683267,13.8599073 L6.44683267,9.11768179 L8.40082901,9.11768179 L9.96762165,12.5154962 L11.4069075,9.11768179 L13.4001832,9.11768179 L13.4001832,14.1264026 L12.1730058,14.1264026 Z M15.3055732,13.1015049 L15.3055732,12.104716 L17.9339657,12.104716 L17.9339657,11.0825466 L15.3055732,11.0825466 L15.3055732,10.171719 L18.3071194,10.171719 L19.6166324,11.6317021 L18.2491069,13.1015049 L15.3055732,13.1015049 Z M23.4171068,14.1455801 L21.8614469,14.1455801 L20.3872629,12.4870853 L18.8552174,14.1455801 L14.1129918,14.1455801 L14.1129918,9.13565077 L18.9281863,9.13565077 L20.4011617,10.7778295 L21.9239917,9.13565077 L23.488005,9.13565077 L21.1613628,11.6406155 L23.4171068,14.1455801 Z"/>
                                                      </svg>';

                            } else if ($provider == 'VISA') {

                                $logo = '<svg xmlns="http://www.w3.org/2000/svg" width="800px" height="800px" viewBox="0 0 141.732 141.732">

                                                        <g fill="#2566af">
                                                        
                                                        <path d="M62.935 89.571h-9.733l6.083-37.384h9.734zM45.014 52.187L35.735 77.9l-1.098-5.537.001.002-3.275-16.812s-.396-3.366-4.617-3.366h-15.34l-.18.633s4.691.976 10.181 4.273l8.456 32.479h10.141l15.485-37.385H45.014zM121.569 89.571h8.937l-7.792-37.385h-7.824c-3.613 0-4.493 2.786-4.493 2.786L95.881 89.571h10.146l2.029-5.553h12.373l1.14 5.553zm-10.71-13.224l5.114-13.99 2.877 13.99h-7.991zM96.642 61.177l1.389-8.028s-4.286-1.63-8.754-1.63c-4.83 0-16.3 2.111-16.3 12.376 0 9.658 13.462 9.778 13.462 14.851s-12.075 4.164-16.06.965l-1.447 8.394s4.346 2.111 10.986 2.111c6.642 0 16.662-3.439 16.662-12.799 0-9.72-13.583-10.625-13.583-14.851.001-4.227 9.48-3.684 13.645-1.389z"/>
                                                        
                                                        </g>
                                                        
                                                        <path d="M34.638 72.364l-3.275-16.812s-.396-3.366-4.617-3.366h-15.34l-.18.633s7.373 1.528 14.445 7.253c6.762 5.472 8.967 12.292 8.967 12.292z" fill="#e6a540"/>
                                                        
                                                        <path fill="none" d="M0 0h141.732v141.732H0z"/>
                                                        
                                                        </svg>';

                            } else {

                                $logo = '<svg xmlns="http://www.w3.org/2000/svg" width="800px" height="800px" viewBox="0 -54.25 482.51 482.51" id="Layer_1" data-name="Layer 1">
                                                            <g>
                                                                <path d="M220.13,421.67V396.82c0-9.53-5.8-15.74-15.32-15.74-5,0-10.35,1.66-14.08,7-2.9-4.56-7-7-13.25-7a14.07,14.07,0,0,0-12,5.8v-5h-7.87v39.76h7.87V398.89c0-7,4.14-10.35,9.94-10.35s9.11,3.73,9.11,10.35v22.78h7.87V398.89c0-7,4.14-10.35,9.94-10.35s9.11,3.73,9.11,10.35v22.78Zm129.22-39.35h-14.5v-12H327v12h-8.28v7H327V408c0,9.11,3.31,14.5,13.25,14.5A23.17,23.17,0,0,0,351,419.6l-2.49-7a13.63,13.63,0,0,1-7.46,2.07c-4.14,0-6.21-2.49-6.21-6.63V389h14.5v-6.63Zm73.72-1.24a12.39,12.39,0,0,0-10.77,5.8v-5h-7.87v39.76h7.87V399.31c0-6.63,3.31-10.77,8.7-10.77a24.24,24.24,0,0,1,5.38.83l2.49-7.46a28,28,0,0,0-5.8-.83Zm-111.41,4.14c-4.14-2.9-9.94-4.14-16.15-4.14-9.94,0-16.15,4.56-16.15,12.43,0,6.63,4.56,10.35,13.25,11.6l4.14.41c4.56.83,7.46,2.49,7.46,4.56,0,2.9-3.31,5-9.53,5a21.84,21.84,0,0,1-13.25-4.14l-4.14,6.21c5.8,4.14,12.84,5,17,5,11.6,0,17.81-5.38,17.81-12.84,0-7-5-10.35-13.67-11.6l-4.14-.41c-3.73-.41-7-1.66-7-4.14,0-2.9,3.31-5,7.87-5,5,0,9.94,2.07,12.43,3.31Zm120.11,16.57c0,12,7.87,20.71,20.71,20.71,5.8,0,9.94-1.24,14.08-4.56l-4.14-6.21a16.74,16.74,0,0,1-10.35,3.73c-7,0-12.43-5.38-12.43-13.25S445,389,452.07,389a16.74,16.74,0,0,1,10.35,3.73l4.14-6.21c-4.14-3.31-8.28-4.56-14.08-4.56-12.43-.83-20.71,7.87-20.71,19.88h0Zm-55.5-20.71c-11.6,0-19.47,8.28-19.47,20.71s8.28,20.71,20.29,20.71a25.33,25.33,0,0,0,16.15-5.38l-4.14-5.8a19.79,19.79,0,0,1-11.6,4.14c-5.38,0-11.18-3.31-12-10.35h29.41v-3.31c0-12.43-7.46-20.71-18.64-20.71h0Zm-.41,7.46c5.8,0,9.94,3.73,10.35,9.94H364.68c1.24-5.8,5-9.94,11.18-9.94ZM268.59,401.79V381.91h-7.87v5c-2.9-3.73-7-5.8-12.84-5.8-11.18,0-19.47,8.7-19.47,20.71s8.28,20.71,19.47,20.71c5.8,0,9.94-2.07,12.84-5.8v5h7.87V401.79Zm-31.89,0c0-7.46,4.56-13.25,12.43-13.25,7.46,0,12,5.8,12,13.25,0,7.87-5,13.25-12,13.25-7.87.41-12.43-5.8-12.43-13.25Zm306.08-20.71a12.39,12.39,0,0,0-10.77,5.8v-5h-7.87v39.76H532V399.31c0-6.63,3.31-10.77,8.7-10.77a24.24,24.24,0,0,1,5.38.83l2.49-7.46a28,28,0,0,0-5.8-.83Zm-30.65,20.71V381.91h-7.87v5c-2.9-3.73-7-5.8-12.84-5.8-11.18,0-19.47,8.7-19.47,20.71s8.28,20.71,19.47,20.71c5.8,0,9.94-2.07,12.84-5.8v5h7.87V401.79Zm-31.89,0c0-7.46,4.56-13.25,12.43-13.25,7.46,0,12,5.8,12,13.25,0,7.87-5,13.25-12,13.25-7.87.41-12.43-5.8-12.43-13.25Zm111.83,0V366.17h-7.87v20.71c-2.9-3.73-7-5.8-12.84-5.8-11.18,0-19.47,8.7-19.47,20.71s8.28,20.71,19.47,20.71c5.8,0,9.94-2.07,12.84-5.8v5h7.87V401.79Zm-31.89,0c0-7.46,4.56-13.25,12.43-13.25,7.46,0,12,5.8,12,13.25,0,7.87-5,13.25-12,13.25C564.73,415.46,560.17,409.25,560.17,401.79Z" transform="translate(-132.74 -48.5)" />
                                                                <g>
                                                                    <rect x="169.81" y="31.89" width="143.72" height="234.42" fill="#ff5f00" />
                                                                    <path d="M317.05,197.6A149.5,149.5,0,0,1,373.79,80.39a149.1,149.1,0,1,0,0,234.42A149.5,149.5,0,0,1,317.05,197.6Z" transform="translate(-132.74 -48.5)" fill="#eb001b" />
                                                                    <path d="M615.26,197.6a148.95,148.95,0,0,1-241,117.21,149.43,149.43,0,0,0,0-234.42,148.95,148.95,0,0,1,241,117.21Z" transform="translate(-132.74 -48.5)" fill="#f79e1b" />
                                                                </g>
                                                            </g>
                                                        </svg>';

                            }

                            $card = '<div class="vCard_box' . $class . '">

                                <div class="vCard cfront">

                                    <div class="vCard_section info">

                                        <div class="vCS_box">

                                            <div class="vCS_boxItem">

                                                <div>

                                                    <button data-id="' . $id . '" data-fund="' . $fund . '" data-info="' . $provider . ' ' . substr($number, 0, 5) . '****' . substr($number, -3) . ' ('. $currency . ')' . '" class="pg_btn" iQ-target="#iQ_vFund" style="background-color: ' . $color . '; color: white;">Fund Card</button>

                                                </div>

                                                <div class="vCS_logo">

                                                    <img src="'.  SITE_LOGO .'" alt="">

                                                </div>

                                            </div>

                                            <div class="vCS_boxItem">
                                                
                                                <div class="chip">
                                                    <div class="chip-line"></div>
                                                    <div class="chip-line"></div>
                                                    <div class="chip-line"></div>
                                                    <div class="chip-line"></div>
                                                    <div class="chip-main"></div>
                                                </div>

                                            </div>

                                        </div>

                                    </div>

                                    <div class="vCard_section details" style="background-color: ' . $color . '; color: white;">

                                        <div style="position: absolute; right: 1em; top: 7em;">

                                            <svg class="wave" viewBox="0 3.71 26.959 38.787" width="26.959" height="38.787" fill="white">
                                                <path d="M19.709 3.719c.266.043.5.187.656.406 4.125 5.207 6.594 11.781 6.594 18.938 0 7.156-2.469 13.73-6.594 18.937-.195.336-.57.531-.957.492a.9946.9946 0 0 1-.851-.66c-.129-.367-.035-.777.246-1.051 3.855-4.867 6.156-11.023 6.156-17.718 0-6.696-2.301-12.852-6.156-17.719-.262-.317-.301-.762-.102-1.121.204-.36.602-.559 1.008-.504z"></path>
                                                <path d="M13.74 7.563c.231.039.442.164.594.343 3.508 4.059 5.625 9.371 5.625 15.157 0 5.785-2.113 11.097-5.625 15.156-.363.422-1 .472-1.422.109-.422-.363-.472-1-.109-1.422 3.211-3.711 5.156-8.551 5.156-13.843 0-5.293-1.949-10.133-5.156-13.844-.27-.309-.324-.75-.141-1.114.188-.367.578-.582.985-.542h.093z"></path>
                                                <path d="M7.584 11.438c.227.031.438.144.594.312 2.953 2.863 4.781 6.875 4.781 11.313 0 4.433-1.828 8.449-4.781 11.312-.398.387-1.035.383-1.422-.016-.387-.398-.383-1.035.016-1.421 2.582-2.504 4.187-5.993 4.187-9.875 0-3.883-1.605-7.372-4.187-9.875-.321-.282-.426-.739-.266-1.133.164-.395.559-.641.984-.617h.094zM1.178 15.531c.121.02.238.063.344.125 2.633 1.414 4.437 4.215 4.437 7.407 0 3.195-1.797 5.996-4.437 7.406-.492.258-1.102.07-1.36-.422-.257-.492-.07-1.102.422-1.359 2.012-1.075 3.375-3.176 3.375-5.625 0-2.446-1.371-4.551-3.375-5.625-.441-.204-.676-.692-.551-1.165.122-.468.567-.785 1.051-.742h.094z"></path>
                                            </svg>

                                        </div>

                                        <div class="vCS_logo alpha">' . $logo . '</div>

                                        <div class="vCS_box">

                                            <div class="vCS_boxItem">

                                                <p>' . join(' ', [$userData['firstname'], $userData['lastname']]) . '</p>

                                                <p>' . trim(chunk_split($number, 4, ' ')) . '</p>
 

                                                <div class="flx_group">

                                                    <div>

                                                        <p class="info">Valid Till</p>

                                                        <p>' . $expires . '</p>

                                                    </div>

                                                </div>

                                            </div>

                                        </div>

                                    </div>

                                </div>

                                <div class="vCard cback">
                                                
                                    <div class="vCard_section info">

                                        <div class="stripe"></div>

                                    </div>

                                    <div class="vCard_section details" style="background-color: ' . $color . ';">

                                        <div class="back_con">

                                            <div class="stripe"></div>

                                            <div class="cvv_con">

                                                <span>CVV</span>

                                                <div>' . $cvv . '</div>

                                            </div>

                                            <p style="font-size: 0.6rem; position: absolute; bottom: 1em; right: 1em; padding: 1.2em;">Misuse of this card is a criminal offense. Though this card is a property of the issuer and is subject to the issuer\'s terms of service, any harm from its usage isn\'t liable to the issuer.</p>

                                        </div>

                                    </div>

                                </div>

                            </div>'; ?>

                            <div class="xGrid_box">

                                <div class="xGB_displ"><?= $card ?></div>

                                <span class="hint--bottom" aria-label="Flip"><div class="card-flipper"></div></span>

                                <div class="xGB_details">

                                    <div class="aRight">

                                        <div class="label"><?= $status ?></div>

                                    </div>

                                    <div class="aLeft">

                                        <p><?= $symbol . $balance .  ' ' .$currency ?></p>

                                    </div>

                                </div>

                            </div>

                        <?php endforeach;
                    
                    ?>

                </div>

            </div>

        </section>

    <?php } else { ?>

        <section>

            <div class="dash_banner gradient">

                <div class="dashBanner_con grid" style="align-items: center;">

                    <div class="dashCarousel">

                        <div class="dashCarousel_con" id="iQ_slider">

                            <div class="dashCarousel_item">

                                <img src="../assets/media/images/slide-item_2.webp" alt="">

                                <div class="txbox">

                                    <p class="b">Shop without restriction</p>

                                </div>

                            </div>

                            <div class="dashCarousel_item">

                                <img src="../assets/media/images/slide-item_3.webp" alt="">

                                <div class="txbox">

                                    <p class="b">Stream without interruption</p>

                                </div>

                            </div>

                            <div class="dashCarousel_item">

                                <img src="../assets/media/images/slide-item_2.webp" alt="">

                                <div class="txbox">

                                    <p class="b">TRULY GLOBAL: 1 CARD. 80 COUNTRIES. > 10000 MERCHANTS</p>

                                </div>

                            </div>
                            
                        </div>

                        <div class="carouselInd_con">

                            <div class="carouselInd"></div>

                            <div class="carouselInd"></div>

                            <div class="carouselInd"></div>

                        </div>

                        </div>

                        <div class="dashBanner_item ex opaque pdex">

                        <div class="def_txt">

                            <h1 class="def_title">Get your instant prepaid debit card</h1>

                        </div>

                        <div class="highlights">

                            <div>

                                <div class="radial_icon blue xm">

                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none"><path d="M4.05999 8.85335H6.11999V13.6533C6.11999 14.7733 6.72665 15 7.46665 14.16L12.5133 8.42668C13.1333 7.72668 12.8733 7.14668 11.9333 7.14668H9.87332V2.34668C9.87332 1.22668 9.26665 1.00001 8.52665 1.84001L3.47999 7.57335C2.86665 8.28001 3.12665 8.85335 4.05999 8.85335Z" stroke="#2467E3" stroke-width="1.2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path></svg>

                                </div>

                                <span>Faster international payments</span>

                            </div>

                            <div>

                                <div class="radial_icon blue xm">

                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none"><path d="M10.0005 18.2037C14.532 18.2037 18.2056 14.5302 18.2056 9.99859C18.2056 5.46702 14.532 1.79346 10.0005 1.79346C5.46891 1.79346 1.79535 5.46702 1.79535 9.99859C1.79535 14.5302 5.46891 18.2037 10.0005 18.2037Z" stroke="#2467E3" stroke-width="1.23077" stroke-linecap="round" stroke-linejoin="round"></path><path d="M6.71835 2.61377H7.53887C5.93887 7.40556 5.93887 12.5912 7.53887 17.383H6.71835" stroke="#2467E3" stroke-width="1.23077" stroke-linecap="round" stroke-linejoin="round"></path><path d="M12.462 2.61377C14.062 7.40556 14.062 12.5912 12.462 17.383" stroke="#2467E3" stroke-width="1.23077" stroke-linecap="round" stroke-linejoin="round"></path><path d="M2.61584 13.2805V12.46C7.40764 14.06 12.5933 14.06 17.3851 12.46V13.2805" stroke="#2467E3" stroke-width="1.23077" stroke-linecap="round" stroke-linejoin="round"></path><path d="M2.61584 7.53716C7.40764 5.93716 12.5933 5.93716 17.3851 7.53716" stroke="#2467E3" stroke-width="1.23077" stroke-linecap="round" stroke-linejoin="round"></path></svg>

                                </div>

                                <span>Globally accepted</span>

                            </div>

                            <div>

                                <div class="radial_icon blue xm">

                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none"><path d="M1.33325 1.33325H2.49326C3.21326 1.33325 3.77992 1.95325 3.71992 2.66659L3.16659 9.30658C3.07325 10.3932 3.93325 11.3266 5.02658 11.3266H12.1266C13.0866 11.3266 13.9266 10.5399 13.9999 9.58659L14.3599 4.58659C14.4399 3.47992 13.5999 2.57992 12.4866 2.57992H3.87992" stroke="#2467E3" stroke-width="1.1" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path><path d="M10.8333 14.6667C11.2936 14.6667 11.6667 14.2936 11.6667 13.8333C11.6667 13.3731 11.2936 13 10.8333 13C10.3731 13 10 13.3731 10 13.8333C10 14.2936 10.3731 14.6667 10.8333 14.6667Z" stroke="#2467E3" stroke-width="1.1" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path><path d="M5.50008 14.6667C5.96032 14.6667 6.33341 14.2936 6.33341 13.8333C6.33341 13.3731 5.96032 13 5.50008 13C5.03984 13 4.66675 13.3731 4.66675 13.8333C4.66675 14.2936 5.03984 14.6667 5.50008 14.6667Z" stroke="#2467E3" stroke-width="1.1" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path><path d="M6 5.33325H14" stroke="#2467E3" stroke-width="1.1" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path></svg>

                                </div>

                                <span>Works on all your favourite stores</span>

                            </div>

                            <div>

                                <div class="radial_icon blue xm">

                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none"><path d="M5.07739 8.35756V6.71653C5.07739 4.00064 5.89791 1.79346 10.0005 1.79346C14.103 1.79346 14.9235 4.00064 14.9235 6.71653V8.35756" stroke="#2467E3" stroke-width="1.23077" stroke-linecap="round" stroke-linejoin="round"></path><path d="M14.103 18.2036H5.89791C2.61586 18.2036 1.79535 17.3831 1.79535 14.101V12.46C1.79535 9.17793 2.61586 8.35742 5.89791 8.35742H14.103C17.3851 8.35742 18.2056 9.17793 18.2056 12.46V14.101C18.2056 17.3831 17.3851 18.2036 14.103 18.2036Z" stroke="#2467E3" stroke-width="1.23077" stroke-linecap="round" stroke-linejoin="round"></path><path d="M13.2796 13.2806H13.287" stroke="#2467E3" stroke-width="1.64103" stroke-linecap="round" stroke-linejoin="round"></path><path d="M9.99675 13.2806H10.0041" stroke="#2467E3" stroke-width="1.64103" stroke-linecap="round" stroke-linejoin="round"></path><path d="M6.71392 13.2806H6.72129" stroke="#2467E3" stroke-width="1.64103" stroke-linecap="round" stroke-linejoin="round"></path></svg>

                                </div>

                                <span>Heavily secure</span>

                            </div>

                        </div>

                        <div class="jzzvt_box prime varB variantBlue" style="width: 100%; margin: 0 auto;">

                            <a style="font-weight: 600; width: 100%; margin: 0;" class="iQ_trigger iQ_vcard"<?= (MAX_CARD != 0) ? ' iQ-target="#iQ_vCard"' : null ?>><?= (MAX_CARD != 0) ? 'Get Started' : 'Coming Soon' ?></a>

                        </div>

                    </div>

                </div>
            </div>
            
        </section>

    <?php }

?>

<!-- MODAL: Request New Card -->

<div class="popup_window n_displ" role="dialog">

    <div id="iQ_vCard" class="popup_con n_displ">

        <div class="popup_box noScrollBar float_up">

            <div class="popupBox_header variantB">

                <p>Create Virtual Card</p>

                <div class="radial_icon iQ_terminator">

                    <svg width="15" height="15" viewBox="0 0 19 19" fill="none" xmlns="http://www.w3.org/2000/svg" class="close-icon"><path d="M5.80032 5.79883L13.1229 13.1214" stroke="white" stroke-width="1.68132" stroke-linecap="round" stroke-linejoin="round"></path><path d="M5.79958 13.1214L13.1222 5.79883" stroke="white" stroke-width="1.68132" stroke-linecap="round" stroke-linejoin="round"></path></svg>

                </div>

            </div>

            <div class="modal_box">

                <img src="../assets/media/images/virtual-card.png" alt="">

                <p class="special_title">You'll be charged a one-time fee</p>

                <?php
                
                    if (CARD_PREF == 'MANUAL') {

                        echo '<p>You\'ll make an equivalent payment of <i><span translate="no">$</span>' . number_format(CARD_FEE, 2) . '<span translate="no">USD</span></i>.</p>';

                    } else {

                        echo '<p>You\'ll be charged an equivalent of <i><span translate="no">$</span>' . number_format(CARD_FEE, 2) . '<span translate="no">USD</span></i> from your account balance.</p>';

                    }
                
                ?>

                <form id="cardForm" method="post">

                    <div class="form_item db">

                        <div class="form_item">

                            <label for="provider">Provider</label>

                            <select name="provider" class="form_field">

                                <option>AMEX</option>

                                <option value="MASTERCARD">MasterCard</option>

                                <option>VISA</option>

                            </select>

                        </div>

                        <div class="form_item">

                            <label for="currency">Currency / Account</label>

                            <select name="currency" class="form_field">

                                <?php

                                    $accInfo = userAccounts($user_id, $conn);
                                
                                    foreach ($accInfo as $row): ?>

                                        <option value="<?= $row['acc_id'] ?>"><?= $row['currency'] ?></option>

                                    <?php endforeach;
                                
                                ?>

                            </select>

                        </div>

                    </div>

                    <div class="form_item checkbox">

                        <p><input type="checkbox" required>

                        I confirm to pay the one-time fee of <i><span translate="no">$</span><?= number_format(CARD_FEE, 2) ?><span translate="no">USD</span></i></p>

                    </div>

                    <div class="form_item formBtn_con">

                        <button name="request_vcard" id="getCard" class="form_btn" type="submit">Create virtual card</button>
                        
                    </div>

                </form>

            </div>

        </div>

    </div>

</div>

<!-- MODAL: Fund Card  -->

<div class="popup_window n_displ" role="dialog">

    <div id="iQ_vFund" class="popup_con n_displ">

        <div class="popup_box noScrollBar float_up">

            <div class="popupBox_header">

                <p>Fund Virtual Card</p>

                <div class="radial_icon iQ_terminator">

                    <svg width="15" height="15" viewBox="0 0 19 19" fill="none" xmlns="http://www.w3.org/2000/svg" class="close-icon"><path d="M5.80032 5.79883L13.1229 13.1214" stroke="white" stroke-width="1.68132" stroke-linecap="round" stroke-linejoin="round"></path><path d="M5.79958 13.1214L13.1222 5.79883" stroke="white" stroke-width="1.68132" stroke-linecap="round" stroke-linejoin="round"></path></svg>

                </div>

            </div>

            <div class="modal_box">

                <form id="vFundForm" method="post">

                    <div class="form_item">

                        <input type="hidden" name="card-id" id="card-id">

                        <label for="account">Card</label>

                        <input name="account" class="form_field" id="card-details" readonly>

                    </div>

                    <div class="form_item">

                        <label for="fund-amount">Amount</label>

                        <input type="number" step="0.01" name="fund-amount" class="form_field" required>

                    </div>

                    <div id="fundMeans"></div>

                </form>

            </div>

        </div>

    </div>

</div>
      
<?php

    require('../partials/footer.php');

    // Virtual Card Request Processor

    if (isset($_REQUEST['request_vcard'])) {

        // Sanitize Field

        $cardType = filter_var($_REQUEST['card_type'], FILTER_SANITIZE_SPECIAL_CHARS);

        // Check If User Has An Existing Request
        
        $queryRequests = mysqli_query($conn, "SELECT * FROM requests WHERE user_id = '$user_id' AND req_type = 'VIRTUAL CARD' AND req_status = 'PENDING'");

        if (mysqli_num_rows($queryRequests) > 0) {

            echo '<script>

                toast({
                
                    text: "You\'ve already requested for a card!",

                    type: "error",

                    duration: 7000,
                
                });
            
            </script>';

        } else {

            // Generate Request ID

            function generateReq_ID() {

                $req_ID = random_int(0, mt_getrandmax());

                return $req_ID;

            }

            $req_ID = "REQ-" . generateReq_ID();

            // Save Request

            $querySaveRequest = mysqli_query($conn, "INSERT INTO requests (user_id, req_id, req_type, req_details, req_status) VALUES('$user_id', '$req_ID', 'VIRTUAL CARD', '$cardType', 'PENDING')");

            if ($querySaveRequest) {

                echo '<script>

                    toast({
                    
                        text: "'. htmlspecialchars($cardType, ENT_QUOTES, 'UTF-8') . ' Card Requested!",

                        type: "success",

                        duration: 7000,
                    
                    });
                
                </script>';

            } else {

                echo '<script>
                
                    toast({
                    
                        text: "Error, Try Again!",

                        type: "warning",

                        duration: 7000,
                    
                    });
                
                </script>';

            }

        }

    }

?>