<?php

    require('../partials/header.php');

    blockThirdParty(); // Bar Third Party Users

    $customers = customersData($user_id, $conn); // Get Customer(s) Data

    if (!$customers) { // No Customers

        echo "<script>
        
            popup({

                header: 'Attention!',

                title: 'Create a customer',

                text: 'You can\'t create an invoice you need first create a customer.',

                type: 'warning',

            }).then(() => {

                window.location.href = 'invoices';

            });

        </script>";

    }

?>

<section id="create-invoice">

    <div class="dash_banner">

        <div class="dashBanner_header col">

            <h4 class="dashBanner_title">Create An Invoice</h4>

            <p class="text-min">Enter the following details to finish creating your invoice</p>

        </div>

        <form method="post" id="create-invoice-form" autocomplete="off">

            <div class="form_item">

                <label for="inv-recipient" class="pos-rel">Recipient

                    <div class="tooltip">

                        <div class="tooltip-content">List of all your previous customers. Don't see a customer or need to add one; create a new customer.</div>

                        <div class="tooltip-icon">

                            <svg xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 56 56"><path d="M 27.9999 51.9063 C 41.0546 51.9063 51.9063 41.0781 51.9063 28 C 51.9063 14.9453 41.0312 4.0937 27.9765 4.0937 C 14.8983 4.0937 4.0937 14.9453 4.0937 28 C 4.0937 41.0781 14.9218 51.9063 27.9999 51.9063 Z M 27.7890 19.6563 C 26.0780 19.6563 24.7421 18.2968 24.7421 16.6094 C 24.7421 14.8984 26.0780 13.5390 27.7890 13.5390 C 29.4999 13.5390 30.8358 14.8984 30.8358 16.6094 C 30.8358 18.2968 29.4999 19.6563 27.7890 19.6563 Z M 23.8749 40.8906 C 22.9374 40.8906 22.1874 40.2109 22.1874 39.25 C 22.1874 38.3359 22.9374 37.6094 23.8749 37.6094 L 26.8046 37.6094 L 26.8046 26.8516 L 24.2733 26.8516 C 23.3358 26.8516 22.5858 26.1719 22.5858 25.2109 C 22.5858 24.2968 23.3358 23.5703 24.2733 23.5703 L 28.7030 23.5703 C 29.8749 23.5703 30.5312 24.4141 30.5312 25.6797 L 30.5312 37.6094 L 33.4374 37.6094 C 34.3983 37.6094 35.1483 38.3359 35.1483 39.25 C 35.1483 40.2109 34.3983 40.8906 33.4374 40.8906 Z"/></svg>

                        </div>

                    </div>

                </label>

                <select name="inv-recipient" class="form_field searchable">

                    <option value="0">Select Recipient</option>

                    <?php

                        if ($customers) {
                    
                            foreach($customers as $customer): ?>

                                <option value="<?= $customer['customer_id'] ?>"><?= $customer['name'] . ' (' . $customer['email'] . ')' ?></option>

                            <?php endforeach;

                        }    
                    
                    ?>

                </select>

            </div>

            <div class="form_item">

                <label for="inv-title">Invoice Title</label>

                <input type="text" name="inv-title" placeholder="Enter title of invoice" class="form_field">

            </div>

            <div class="form_item db">

                <div class="form_item">

                    <label for="currency" class="pos-rel">Currency

                        <div class="tooltip">

                            <div class="tooltip-content">Your account details will be attached to the invoice.</div>

                            <div class="tooltip-icon">

                                <svg xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 56 56"><path d="M 27.9999 51.9063 C 41.0546 51.9063 51.9063 41.0781 51.9063 28 C 51.9063 14.9453 41.0312 4.0937 27.9765 4.0937 C 14.8983 4.0937 4.0937 14.9453 4.0937 28 C 4.0937 41.0781 14.9218 51.9063 27.9999 51.9063 Z M 27.7890 19.6563 C 26.0780 19.6563 24.7421 18.2968 24.7421 16.6094 C 24.7421 14.8984 26.0780 13.5390 27.7890 13.5390 C 29.4999 13.5390 30.8358 14.8984 30.8358 16.6094 C 30.8358 18.2968 29.4999 19.6563 27.7890 19.6563 Z M 23.8749 40.8906 C 22.9374 40.8906 22.1874 40.2109 22.1874 39.25 C 22.1874 38.3359 22.9374 37.6094 23.8749 37.6094 L 26.8046 37.6094 L 26.8046 26.8516 L 24.2733 26.8516 C 23.3358 26.8516 22.5858 26.1719 22.5858 25.2109 C 22.5858 24.2968 23.3358 23.5703 24.2733 23.5703 L 28.7030 23.5703 C 29.8749 23.5703 30.5312 24.4141 30.5312 25.6797 L 30.5312 37.6094 L 33.4374 37.6094 C 34.3983 37.6094 35.1483 38.3359 35.1483 39.25 C 35.1483 40.2109 34.3983 40.8906 33.4374 40.8906 Z"/></svg>

                            </div>

                        </div>

                    </label>

                    <select name="currency" class="form_field">

                        <option value="0">Select Currency</option>

                        <?php

                            // Display User Accounts
                        
                            foreach($userAccounts as $account): ?>

                                <option value="<?= $account['currency'] ?>"><?= $account['currency'] ?></option>

                            <?php endforeach;
                        
                        ?>

                    </select>

                </div>

                <div class="form_item">

                    <label for="due">Due Date</label>

                    <input type="date" name="due" class="form_field" required>

                </div>

            </div>

            <div class="seperator"></div>

            <div id="invoice-items">

                <div class="form_item inv-row">

                    <div class="form_item fi-1">

                        <label for="item-desc">Item Description</label>

                        <input type="text" name="item-desc[]" placeholder="Enter item description" class="form_field" required>

                    </div>

                    <div class="form_item fi-2">

                        <label for="item-qty">Qty</label>

                        <input type="number" name="item-qty[]" placeholder="0" class="form_field calc-field" min="1">

                    </div>

                    <div class="form_item fi-3">

                        <label for="item-price">Price</label>

                        <input type="number" name="item-price[]" placeholder="0.00" step="0.01" min="0.01" class="form_field calc-field" required>

                    </div>

                    <div class="form_item fi-4">

                        <label for="item-amt">Amount</label>

                        <input type="number" name="item-amt[]" placeholder="0.00" class="form_field" readonly>

                    </div>

                    <div class="inv-delete">

                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 shrink-0"><path fill-rule="evenodd" clip-rule="evenodd" d="M10.5555 4C10.099 4 9.70052 4.30906 9.58693 4.75114L9.29382 5.8919H14.715L14.4219 4.75114C14.3083 4.30906 13.9098 4 13.4533 4H10.5555ZM16.7799 5.8919L16.3589 4.25342C16.0182 2.92719 14.8226 2 13.4533 2H10.5555C9.18616 2 7.99062 2.92719 7.64985 4.25342L7.22886 5.8919H4C3.44772 5.8919 3 6.33961 3 6.8919C3 7.44418 3.44772 7.8919 4 7.8919H4.10069L5.31544 19.3172C5.47763 20.8427 6.76455 22 8.29863 22H15.7014C17.2354 22 18.5224 20.8427 18.6846 19.3172L19.8993 7.8919H20C20.5523 7.8919 21 7.44418 21 6.8919C21 6.33961 20.5523 5.8919 20 5.8919H16.7799ZM17.888 7.8919H6.11196L7.30423 19.1057C7.3583 19.6142 7.78727 20 8.29863 20H15.7014C16.2127 20 16.6417 19.6142 16.6958 19.1057L17.888 7.8919ZM10 10C10.5523 10 11 10.4477 11 11V16C11 16.5523 10.5523 17 10 17C9.44772 17 9 16.5523 9 16V11C9 10.4477 9.44772 10 10 10ZM14 10C14.5523 10 15 10.4477 15 11V16C15 16.5523 14.5523 17 14 17C13.4477 17 13 16.5523 13 16V11C13 10.4477 13.4477 10 14 10Z" fill="currentColor"></path></svg>

                    </div>

                </div>

            </div>

            <button type="button" id="add-invoice-item" class="plain-btn">
                
                <span>Add additional item</span>

                <div class="icon">

                    <svg width="10" height="10" viewBox="0 0 10 10" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M4.8335 1.46448V8.53555" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path><path d="M8.36903 5.00001H1.29796" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path></svg>

                </div>
        
            </button>

            <div class="seperator"></div>

            <div class="flx jEnd">

                <p>Subtotal</p>

                <p id="sub-total">0.00</p>

            </div>

            <div class="seperator"></div>

            <div class="inv-sub-row">

                <label for="discount">DISCOUNT</label>

                <div class="form_item">

                    <select name="discount-type" class="form_field calc-field">

                        <option value="FIXED">Fixed</option>

                        <option value="PERCENTAGE">Percentage</option>

                    </select>

                </div>

                <div class="form_item">

                    <input class="form_field calc-field" name="discount" type="number" min="0.01" step="0.01" placeholder="0.00">

                </div>

                <div class="form_item">

                    <input class="form_field calc-field" name="discount-calc" type="number" min="0.01" step="0.01" placeholder="0.00" readonly>

                </div>

            </div>

            <div class="inv-sub-row">

                <label for="tax">TAX</label>

                <div class="form_item">

                    <select name="tax-type" class="form_field calc-field">

                        <option value="FIXED">Fixed</option>

                        <option value="PERCENTAGE">Percentage</option>

                    </select>

                </div>

                <div class="form_item">

                    <input class="form_field calc-field" name="tax" type="number" min="0.01" step="0.01" placeholder="0.00">

                </div>

                <div class="form_item">

                    <input class="form_field" name="tax-calc" type="number" min="0.01" step="0.01" placeholder="0.00" readonly>

                </div>

            </div>

            <div class="flx jEnd" style="padding: 0 1em 1.2em;">

                <div class="iQ_checkbox" title="Tax before discount"><input type="checkbox" name="tax-first" class="calc-field"> <label for="tax-first"></label>Tax before discount (Apply Tax To Subtotal)</div>

            </div>

            <div class="flx jEnd" style="padding: 1em;">

                <label for="credit">CREDIT (Owed)</label>

                <div class="form_item">

                    <input class="form_field calc-field" name="credit" type="number" min="0.01" step="0.01" placeholder="0.00">

                </div>

            </div>

            <div class="seperator"></div>

            <div class="flx jEnd">

                <p>Total</p>

                <p id="total">0.00</p>

            </div>

            <div class="seperator"></div>

            <div class="form_item">

                <label for="descr">Additional Notes</label>

                <input name="descr" placeholder="Enter any additional information you may have" class="form_field">

            </div>

            <div class="form_item flx jEnd">

                <button type="submit" class="form_btn" name="create-new-invoice" id="create-new-invoice">Create Invoice</button>

            </div>
        
        </form>

    </div>

</section>

<?php

    require('../partials/footer.php');

?>