<?php

    require('../partials/service-header.php');

?>

<div class="viewBox max">

    <div class="vbox_item">

        <div class="flx col">

            <p class="special_title">Apply for loan.</p>

            <p style="font-size: 0.8rem;">Fill the details.</p>

        </div>    

    </div>

    <div class="vbox_item">

        <div class="form_con v2">

            <form id="loanForm" method="post">

                <div class="form_item db">

                    <div class="form_item">

                        <label for="loan-term">Term</label>

                        <select class="form_field" name="loan-term">

                            <option value="0">Select Loan Term</option>

                            <option value="90">3 Months</option>

                            <option value="180">6 Months</option>

                            <option value="270">9 Months</option>

                            <option value="365">12 Months</option>

                        </select>

                    </div>

                    <div class="form_item">

                        <label for="loan-freq">Payment Frequency</label>

                        <select class="form_field" name="loan-freq">

                            <option value="0">Select payment frequency</option>

                            <option value="MONTHLY">Monthly</option>

                            <option value="BI-WEEKLY">Bi-Weekly</option>

                        </select>

                    </div>

                </div>

                <div class="form_item db">

                    <div class="form_item">

                        <label for="loan-curr">Currency</label>

                        <select class="form_field" name="loan-curr">

                            <option value="0">Select account</option>

                            <?php
                            
                                $accounts = userAccounts($user_id, $conn); // Get User Accounts

                                foreach ($accounts as $account): ?>

                                    <option value="<?= $account['acc_id'] ?>"><?= $account['currency'] ?></option>

                                <?php endforeach;

                            ?>

                        </select>

                    </div>

                    <div class="form_item">

                        <label for="loan-amt">Amount</label>

                        <input class="form_field" type="number" step="0.01" name="loan-amt" required>

                    </div>

                </div>

                <div class="form_item">

                    <label for="user-credit">Credit Score <span class="iQ_rangeValue"></span></label>

                    <input name="user-credit" class="form_field iQ_range" type="range" min="0" max="1000" value="0"> 

                </div>

                <div class="form_item db">

                    <div class="form_item">

                        <label for="loan-purpose">Purpose / Loan type</label>

                        <select class="form_field" name="loan-purpose">

                            <option value="0">Specify Purpose</option>

                            <option value="DEBT">Debt consolidation</option>

                            <option value="UTILITY BILL">Utility bill</option>

                            <option value="CREDIT CARD">Credit card consolidation</option>

                            <option value="HOME">Home improvement</option>

                            <option value="CAR REPAIR">Car repair</option>

                            <option value="SCHOOL EXPENSES">School expenses</option>

                            <option value="VACATION">Vacation</option>

                            <option value="EMERGENCY">Emergency Expense</option>

                            <option value="MAJOR PURCHASE">Major purchase</option>

                            <option value="OTHER">Other</option>

                        </select>

                    </div>

                    <div class="form_item">

                        <label for="user-job">Income Source</label>

                        <select class="form_field" name="user-job">

                            <option value="0">Select Income Source</option>

                            <option value="FULL-TIME">Full-Time</option>

                            <option value="PART-TIME">Part-Time</option>

                            <option value="SELF-EMPLOYED">Self-Employed</option>

                            <option value="GIG WORKER">Gig Worker</option>

                            <option value="DISABILITY">Disability</option>

                            <option value="BENFITS/EI/CERB">Benefits / EI / CERB</option>

                            <option value="RETIRED">Retired</option>

                            <option value="UNEMPLOYED">Not Working</option>

                        </select>

                    </div>
                </div>

                <div class="form_item">

                    <label for="user-income">Yearly Income</label>

                    <input name="user-income" class="form_field" type="number" step="0.01" required>

                </div>

                <div class="form_item">

                    <button class="form_btn" id="findLoan">Continue &rarr;</button>

                </div>

            </form>

        </div>

    </div>

</div>

<!-- MODAL: Loan Application -->

<div class="popup_window n_displ" role="dialog">

    <div id="iQ_loanApply" class="popup_con n_displ">

        <div class="popup_box noScrollBar">

            <div class="popupBox_header">

                <p>Eligibility Status</p>

                <div class="radial_icon iQ_terminator">

                    <svg width="15" height="15" viewBox="0 0 19 19" fill="none" xmlns="http://www.w3.org/2000/svg" class="close-icon"><path d="M5.80032 5.79883L13.1229 13.1214" stroke="white" stroke-width="1.68132" stroke-linecap="round" stroke-linejoin="round"></path><path d="M5.79958 13.1214L13.1222 5.79883" stroke="white" stroke-width="1.68132" stroke-linecap="round" stroke-linejoin="round"></path></svg>

                </div>

            </div>

            <div class="modal_box">

                <div id="loanHold"></div>

            </div>

        </div>

    </div>

</div>

<?php

    require('../partials/service-footer.php');

?>