<?php

    require('../partials/header.php');

    blockThirdParty();

?>

<section id="header">

    <div class="dash_banner zNoZs">

        <div class="zNoZs_box">

            <h3>Get paid for your work professionally</h3>

            <img src="../assets/media/images/invoice.png" alt="">

        </div>

    </div>

</section>

<secion id="invoices">

    <div class="dash_banner">

        <div class="dashBanner_header space">

            <div class="dhb_Bitem">

                <div class="iQ_panelSwitch tab-switch">Invoices</div>

                <div class="iQ_panelSwitch tab-switch">Customers</div>

            </div>

            <div class="dhb_Bitem">

                <a class="plain-btn" href="create-invoice">

                    <span>Create an invoice</span>

                </a>

                <button class="btn blue" iQ-target="#new-customer">

                    <span>Add New Customer</span>

                </button>

            </div>

        </div>

        <div class="iQ_panel n_displ">

            <div class="table_con" id="table-1">

                <table>

                    <thead>

                        <tr>

                            <th class="mobile-0">Invoice Number</th>

                            <th>Customer</th>

                            <th class="mobile-0">Amount</th>

                            <th class="mobile-0">Created</th>

                            <th class="mobile-0">Due</th>

                            <th class="mobile-0">Status</th>

                            <th>Actions</th>

                        </tr>

                    </thead>

                    <tbody>

                        <?php

                            // Get User Invoices

                            $found = false; // Flag

                            $stmt = mysqli_prepare($conn, "SELECT `A`.*, `B`.`name`, B.`email` FROM `invoices` AS `A` JOIN `customers` AS `B` ON `A`.`customer_id` = `B`.`customer_id` WHERE `A`.`user_id` = ? ORDER BY `A`.`due` DESC"); // Prepare Statement

                            mysqli_stmt_bind_param($stmt, "s", $user_id); // Bind Parameter(s) 

                            mysqli_stmt_execute($stmt); // Execute Statement

                            $result = mysqli_stmt_get_result($stmt); // Get Result

                            if (mysqli_num_rows($result) > 0) { // Compare Result Mass

                                $found = true; // Update Flag

                                $data = mysqli_fetch_all($result, MYSQLI_ASSOC); // Get Result Data

                            }

                            mysqli_free_result($result); // Free Result

                            mysqli_stmt_close($stmt); // Close Statement

                            // Check Flag

                            if ($found) {

                                // Iterate Through Data 

                                foreach ($data as $row) :

                                    $num = $row['inv_num'];

                                    $id = $row['invoice_id'];

                                    $currency = $row['currency'];

                                    $symbol = $currSymbol[$currency];

                                    $created = strtotime($row['created']);

                                    $due = strtotime($row['due']);

                                    $name = $row['name'];

                                    $email = $row['email'];

                                    $amount = '<span translate="no">' . $symbol . '</span>' . number_format($row['payable_amount'], 2);

                                    $status = $row['status'];

                                    if ($status === 'PAID') {

                                        $icon = '<svg viewBox="0 0 22 22" aria-label="Verified account" role="img"><g><path d="M20.396 11c-.018-.646-.215-1.275-.57-1.816-.354-.54-.852-.972-1.438-1.246.223-.607.27-1.264.14-1.897-.131-.634-.437-1.218-.882-1.687-.47-.445-1.053-.75-1.687-.882-.633-.13-1.29-.083-1.897.14-.273-.587-.704-1.086-1.245-1.44S11.647 1.62 11 1.604c-.646.017-1.273.213-1.813.568s-.969.854-1.24 1.44c-.608-.223-1.267-.272-1.902-.14-.635.13-1.22.436-1.69.882-.445.47-.749 1.055-.878 1.688-.13.633-.08 1.29.144 1.896-.587.274-1.087.705-1.443 1.245-.356.54-.555 1.17-.574 1.817.02.647.218 1.276.574 1.817.356.54.856.972 1.443 1.245-.224.606-.274 1.263-.144 1.896.13.634.433 1.218.877 1.688.47.443 1.054.747 1.687.878.633.132 1.29.084 1.897-.136.274.586.705 1.084 1.246 1.439.54.354 1.17.551 1.816.569.647-.016 1.276-.213 1.817-.567s.972-.854 1.245-1.44c.604.239 1.266.296 1.903.164.636-.132 1.22-.447 1.68-.907.46-.46.776-1.044.908-1.681s.075-1.299-.165-1.903c.586-.274 1.084-.705 1.439-1.246.354-.54.551-1.17.569-1.816zM9.662 14.85l-3.429-3.428 1.293-1.302 2.072 2.072 4.4-4.794 1.347 1.246z" fill="currentColor"></path></g></svg>';

                                        $class = ' verified';
                                    } else if ($status === 'OVERDUE') {

                                        $icon = '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-circle-alert mr-2 h-4 w-4"><circle cx="12" cy="12" r="10"></circle><line x1="12" x2="12" y1="8" y2="12"></line><line x1="12" x2="12.01" y1="16" y2="16"></line></svg>';

                                        $class = ' error';
                                    } else {

                                        $icon = '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-timer mr-2 h-4 w-4 text-muted-foreground"><line x1="10" x2="14" y1="2" y2="2"></line><line x1="12" x2="15" y1="14" y2="11"></line><circle cx="12" cy="14" r="8"></circle></svg>';

                                        $class = ' orange';
                                    }

                                    $status = '<div class="verif v2 sm' . $class . '">

                                            <div class="icon">' . $icon . '</div>       
                                            
                                            <span>' . ucwords($status) . '</span>
                                    
                                        </div>';
                                        
                                    ?>

                                    <tr class="iQ_tRow">

                                        <td class="mobile-0"><?= $num ?></td>

                                        <td>

                                            <p><?= $name ?></p>

                                            <p class="text-min"><?= $email ?></p>

                                        </td>

                                        <td class="mobile-0"><?= $amount . '<sup class="label" translate="no">' . $currency . '</sup>' ?></td>

                                        <td class="mobile-0"><?= date('l M d, Y', $created) ?></td>

                                        <td class="mobile-0"><?= date('l M d, Y', $due) ?></td>

                                        <td class="mobile-0"><?= $status ?></td>

                                        <td>

                                            <div class="flx">

                                                <a href="<?= SITE_BASE_URL ?>/invoice?accessKey=<?= urlencode(encrypt($id)) ?>" target="_blank"><span class="badge pill">View</span></a>

                                                <div class="invoice-send">

                                                    <input type="hidden" value="<?= $id ?>">

                                                    <span class="badge pill green iQ_rqust">Mail</span>

                                                </div>

                                                <div class="invoice-delete">

                                                    <input type="hidden" value="<?= $id ?>">

                                                    <span class="badge pill red iQ_rqust">Delete</span>

                                                </div>

                                            </div>

                                        </td>

                                    </tr>

                            <?php endforeach;
                            } else {

                                emptyTable('No information to show', '<svg width="64" height="64" viewBox="0 0 64 64" fill="none" xmlns="http://www.w3.org/2000/svg"><path opacity="0.4" d="M17.9468 52.5333C20.1335 50.1867 23.4668 50.3733 25.3868 52.9333L28.0802 56.5333C30.2402 59.3867 33.7335 59.3867 35.8935 56.5333L38.5868 52.9333C40.5068 50.3733 43.8402 50.1867 46.0268 52.5333C50.7735 57.6 54.6402 55.92 54.6402 48.8267V18.7733C54.6668 8.02666 52.1602 5.33333 42.0802 5.33333H21.9202C11.8402 5.33333 9.3335 8.02666 9.3335 18.7733V48.8C9.3335 55.92 13.2268 57.5733 17.9468 52.5333Z" fill="#BFBFBF"></path><path d="M42.6668 20.6667H21.3335C20.2402 20.6667 19.3335 19.76 19.3335 18.6667C19.3335 17.5733 20.2402 16.6667 21.3335 16.6667H42.6668C43.7602 16.6667 44.6668 17.5733 44.6668 18.6667C44.6668 19.76 43.7602 20.6667 42.6668 20.6667Z" fill="#BFBFBF"></path><path d="M40 31.3333H24C22.9067 31.3333 22 30.4267 22 29.3333C22 28.24 22.9067 27.3333 24 27.3333H40C41.0933 27.3333 42 28.24 42 29.3333C42 30.4267 41.0933 31.3333 40 31.3333Z" fill="#BFBFBF"></path></svg>', 8);
                            }

                        ?>

                    </tbody>

                </table>

                <?php

                    if ($found) {

                        echo '<div class="table_nav">

                                <button class="prevPage" disabled>

                                    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M6.37999 3.95333L2.33333 8L6.37999 12.0467" stroke="#2D3443" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path><path d="M13.6667 8H2.44667" stroke="#2D3443" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path></svg>
                                    
                                    <span>Prev</span>
                            
                                </button>

                                <button class="nextPage" disabled>
                                    
                                    <span>Next</span>

                                    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M9.62 3.95334L13.6667 8.00001L9.62 12.0467" stroke="#2D3443" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path><path d="M2.33331 8H13.5533" stroke="#2D3443" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path></svg>
                            
                                </button>

                            </div>';
                    }

                ?>

            </div>

        </div>

        <div class="iQ_panel n_displ">

            <div class="table_con" id="table-2">

                <table>

                    <thead>

                        <tr>

                            <th>Customer</th>

                            <th class="mobile-0">Email</th>

                            <th class="mobile-0">Date Added</th>

                            <th>Actions</th>

                        </tr>

                    </thead>

                    <tbody>

                        <?php

                            // Get User Customers

                            $found = false; // Flag

                            $stmt = mysqli_prepare($conn, "SELECT * FROM `customers` WHERE `user_id` = ? ORDER BY `name` DESC"); // Prepare Statement

                            mysqli_stmt_bind_param($stmt, "s", $user_id); // Bind Parameter(s) 

                            mysqli_stmt_execute($stmt); // Execute Statement

                            $result = mysqli_stmt_get_result($stmt); // Get Result

                            if (mysqli_num_rows($result) > 0) { // Compare Result Mass

                                $found = true; // Update Flag

                                $data = mysqli_fetch_all($result, MYSQLI_ASSOC); // Get Result Data

                            }

                            mysqli_free_result($result); // Free Result

                            mysqli_stmt_close($stmt); // Close Statement

                            // Check flag

                            if ($found) {

                                // Iterate Through Data 

                                foreach ($data as $row) :

                                    $name = $row['name'];

                                    $email = $row['email'];

                                    $date = strtotime($row['added_on']);

                                    $id = $row['customer_id']; ?>

                                    <tr class="iQ_tRow">

                                        <td><?= $name ?></td>

                                        <td class="mobile-0"><?= $email ?></td>

                                        <td class="mobile-0"><span class="hint--bottom" aria-label="<?= date('h:i A', $date); ?>"><?= date('l M d, Y', $date) ?></td>


                                        <td>

                                            <div class="flx">

                                                <div class="customer-delete">

                                                    <input type="hidden" value="<?= $id ?>">

                                                    <span class="badge pill red iQ_rqust">Delete</span>

                                                </div>

                                            </div>

                                        </td>

                                    </tr>

                            <?php endforeach;
                            } else {

                                emptyTable('No Customers!', '<svg width="71" height="72" viewBox="0 0 71 72" fill="none" xmlns="http://www.w3.org/2000/svg"><path opacity="0.4" d="M26.625 6.41667C18.8742 6.41667 12.5729 12.7179 12.5729 20.4688C12.5729 28.0717 18.5192 34.225 26.27 34.4913C26.5067 34.4617 26.7433 34.4617 26.9208 34.4913C26.98 34.4913 27.0096 34.4913 27.0687 34.4913C27.0983 34.4913 27.0983 34.4913 27.1279 34.4913C34.7012 34.225 40.6475 28.0717 40.6771 20.4688C40.6771 12.7179 34.3758 6.41667 26.625 6.41667Z" fill="#E6E6E6"></path><path d="M41.6533 42.3604C33.3996 36.8579 19.9392 36.8579 11.6263 42.3604C7.86917 44.875 5.79834 48.2771 5.79834 51.9158C5.79834 55.5546 7.86917 58.9271 11.5967 61.4121C15.7383 64.1929 21.1817 65.5833 26.625 65.5833C32.0683 65.5833 37.5117 64.1929 41.6533 61.4121C45.3808 58.8975 47.4517 55.525 47.4517 51.8567C47.4221 48.2179 45.3808 44.8454 41.6533 42.3604Z" fill="#E6E6E6"></path><path opacity="0.4" d="M59.1371 22.2142C59.6104 27.9533 55.5279 32.9825 49.8775 33.6629C49.8479 33.6629 49.8479 33.6629 49.8183 33.6629H49.7296C49.5521 33.6629 49.3746 33.6629 49.2266 33.7221C46.3571 33.87 43.7241 32.9529 41.7421 31.2667C44.7891 28.545 46.5346 24.4625 46.1796 20.025C45.9725 17.6287 45.1442 15.4396 43.9017 13.5758C45.0258 13.0137 46.3275 12.6587 47.6587 12.5404C53.4571 12.0375 58.6342 16.3567 59.1371 22.2142Z" fill="#E6E6E6"></path><path d="M65.0538 49.5788C64.8171 52.4483 62.9829 54.9333 59.9063 56.6196C56.9479 58.2467 53.2204 59.0158 49.5225 58.9271C51.6525 57.0042 52.895 54.6079 53.1317 52.0638C53.4275 48.3954 51.6821 44.875 48.1913 42.0646C46.2092 40.4967 43.9017 39.2542 41.3871 38.3371C47.925 36.4438 56.1492 37.7158 61.2079 41.7983C63.9296 43.9875 65.32 46.7388 65.0538 49.5788Z" fill="#E6E6E6"></path></svg>');
                            }

                        ?>

                    </tbody>

                </table>

                <?php

                    if ($found) {

                        echo '<div class="table_nav">

                                <button class="prevPage" disabled>

                                    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M6.37999 3.95333L2.33333 8L6.37999 12.0467" stroke="#2D3443" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path><path d="M13.6667 8H2.44667" stroke="#2D3443" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path></svg>
                                    
                                    <span>Prev</span>
                            
                                </button>

                                <button class="nextPage" disabled>
                                    
                                    <span>Next</span>

                                    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M9.62 3.95334L13.6667 8.00001L9.62 12.0467" stroke="#2D3443" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path><path d="M2.33331 8H13.5533" stroke="#2D3443" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path></svg>
                            
                                </button>

                            </div>';
                    }

                ?>

            </div>

        </div>

    </div>

</section>

<!-- MODAL: Create Customer -->

<div class="popup_window n_displ" role="dialog">

    <div id="new-customer" class="popup_con n_displ">

        <div class="popup_box float_up">

            <div class="popupBox_header">

                <p>Create New Customer</p>

                <div class="radial_icon iQ_terminator">

                    <svg width="15" height="15" viewBox="0 0 19 19" fill="none" xmlns="http://www.w3.org/2000/svg" class="close-icon"><path d="M5.80032 5.79883L13.1229 13.1214" stroke="white" stroke-width="1.68132" stroke-linecap="round" stroke-linejoin="round"></path><path d="M5.79958 13.1214L13.1222 5.79883" stroke="white" stroke-width="1.68132" stroke-linecap="round" stroke-linejoin="round"></path></svg>

                </div>

            </div>

            <div class="modal_box">

                <form id="addCustomerForm" method="post" autocomplete="off">

                    <div class="form_item db">

                        <div class="form_item">

                            <label for="customer-name">Customer Name</label>

                            <input type="text" name="customer-name" placeholder="Enter Customer Name" class="form_field" required>

                        </div>
                        
                        <div class="form_item">

                            <label for="email">Email Address</label>

                            <input type="email" name="email" placeholder="Enter Customer Email" class="form_field" required>

                        </div>

                    </div>

                    <div class="form_item">

                        <label for="street">Street</label>

                        <input type="text" name="street" placeholder="Enter Billing Address" class="form_field" required>

                    </div>

                    <div class="form_item db">

                        <div class="form_item">

                            <label for="city">City</label>

                            <input type="text" name="city" placeholder="Enter City" class="form_field" required>

                        </div>
                        
                        <div class="form_item">

                            <label for="state">State</label>

                            <input type="text" name="state" placeholder="Enter State" class="form_field" required>

                        </div>

                    </div>

                    <div class="form_item db">

                        <div class="form_item">

                            <label for="zip-code">Zip Code</label>

                            <input type="text" name="zip-code" placeholder="Enter Zip Code" class="form_field" required>

                        </div>
                        
                        <div class="form_item">

                            <label for="country">Country</label>

                            <input type="text" name="country" placeholder="Enter Country" class="form_field" required>

                        </div>

                    </div>
                    
                    <div class="form_item">

                        <button id="addCustomer" name="addCustomer" class="form_btn" type="submit">Proceed</button>

                    </div>

                </form>

            </div>

        </div>

    </div>

</div>

<?php

    require('../partials/footer.php');

?>