<?php

    require('../partials/header.php');

    blockThirdParty(); // Deny Access (Third Party Users)

    if (!$jointAccounts) { // Deny Access (Allow only Joint Account Holder)

        // Re-direct

        echo '<script>
        
            window.location.reload();

        </script>';

        exit; // End Run

    }

?>

<section id="intro">

    <div class="dash_banner jzzvt">

        <div class="jzzvt_box txt">

            <h4>Joint Holders</h4>

            <p>Grant access & control privileges to friends & family.</p>

        </div>

        <div class="jzzvt_box prime">

            <a role="button" iQ-target="#iQ_add-joint-user">Add Joint Holder</a>

            <div class="jzzvt_icon" style="background-image: url(../assets/media/images/beneficiaries.webp)"></div>

        </div>

    </div>

</section>

<section id="joint-holders">

    <div class="dash_banner">

        <div class="dashBanner_header">

            <h4 class="dashBanner_title">Your Joint Holders</h4>

            <div class="dhb_Bitem">

                <!-- <div class="form_field pseudoField">

                    <div class="icon">

                        <svg fill="none" viewBox="0 0 20 20">
                            <path fill="currentColor" fill-rule="evenodd" d="M9.36 4.21a5.14 5.14 0 1 0 0 10.29 5.14 5.14 0 0 0 0-10.29ZM1.64 9.36a7.71 7.71 0 1 1 14 4.47l2.52 2.5a1.29 1.29 0 1 1-1.82 1.83l-2.51-2.51A7.71 7.71 0 0 1 1.65 9.36Z" clip-rule="evenodd"></path>
                        </svg>

                    </div>    

                    <input type="search">

                </div> -->

            </div>

        </div>

        <div class="table_con">

            <table>

                <thead>

                    <tr>

                        <th>Name</th>

                        <th class="mobile-0">Withdrawal Limit</th>

                        <th class="mobile-0">Withdrawals / Limit</th>

                        <th class="mobile-0">Barred Access</th>

                        <th class="mobile-0">Status</th>

                        <th>Actions</th>

                    </tr>

                </thead>

                <tbody>

                    <?php
                    
                        // Get Joint Users

                        $found = false; // Flag

                        $stmt = mysqli_prepare($conn, "SELECT * FROM `third_party` WHERE `user_id` = ? ORDER BY `id` DESC"); // Prepare Statement

                        mysqli_stmt_bind_param($stmt, "s", $user_id); // Bind Parameter(s) 

                        mysqli_stmt_execute($stmt); // Execute Statement

                        $result = mysqli_stmt_get_result($stmt); // Get Result

                        if (mysqli_num_rows($result) > 0) { // Compare Result Mass

                            $found = true; // Update Flag

                            $data = mysqli_fetch_all($result, MYSQLI_ASSOC); // Get Result Data

                        }

                        mysqli_free_result($result); // Free Result

                        mysqli_stmt_close($stmt); // Close Statement

                        // Check Flag

                        if ($found) {

                            // Iterate Through Data 

                            foreach ($data as $row) :

                                $id = $row['tp_id'];

                                $name = join(' ',  [$row['fname'], $row['lname']]);

                                $email = $row['email'];

                                $wLimit = $row['wth_limit'] ?? 0.00;

                                $wCount = number_format($row['trans_count'] ?? 0) . '/' . number_format($row['trans_limit'] ?? 0);

                                $barred = $row['no_access'] ?? 'NONE';

                                $status = $row['status'];

                            ?>
                            
                            <tr>

                                <td>

                                    <div class="flx col">
                                        <p translate="no"><?= $name ?></p>
                                        <p class="font-sm" translate="no"><?= $email ?></p>
                                    </div>
                                    
                                </td>

                                <td class="mobile-0"><?= number_format($wLimit, 2) ?></td>

                                <td class="mobile-0"><?= $wCount ?></td>

                                <td class="mobile-0"><?= $barred ?></td>

                                <td class="mobile-0"><?= $status ?></td>

                                <td>

                                    <div class="flx">

                                        <a href="joint-user-transactions?id=<?= $id ?>"><span class="badge pill green">Transactions</span></a>

                                        <div class="iQ_rqustCon">

                                            <input type="hidden" value="<?= $id ?>">

                                            <span class="badge pill iQ_rqust" iQ-target="#iQ_manage-joint-holder">Manage</span>

                                        </div>

                                        <div class="delete-joint-user">

                                            <input type="hidden" value="<?= $id ?>">

                                            <span class="badge pill red iQ_rqust">Delete</span>

                                        </div>

                                    </div>    

                                </td>

                            </tr>

                            <?php endforeach;

                        } else {

                            emptyTable('No joint users, yet!', '<svg width="71" height="72" viewBox="0 0 71 72" fill="none" xmlns="http://www.w3.org/2000/svg"><path opacity="0.4" d="M26.625 6.41667C18.8742 6.41667 12.5729 12.7179 12.5729 20.4688C12.5729 28.0717 18.5192 34.225 26.27 34.4913C26.5067 34.4617 26.7433 34.4617 26.9208 34.4913C26.98 34.4913 27.0096 34.4913 27.0687 34.4913C27.0983 34.4913 27.0983 34.4913 27.1279 34.4913C34.7012 34.225 40.6475 28.0717 40.6771 20.4688C40.6771 12.7179 34.3758 6.41667 26.625 6.41667Z" fill="#E6E6E6"></path><path d="M41.6533 42.3604C33.3996 36.8579 19.9392 36.8579 11.6263 42.3604C7.86917 44.875 5.79834 48.2771 5.79834 51.9158C5.79834 55.5546 7.86917 58.9271 11.5967 61.4121C15.7383 64.1929 21.1817 65.5833 26.625 65.5833C32.0683 65.5833 37.5117 64.1929 41.6533 61.4121C45.3808 58.8975 47.4517 55.525 47.4517 51.8567C47.4221 48.2179 45.3808 44.8454 41.6533 42.3604Z" fill="#E6E6E6"></path><path opacity="0.4" d="M59.1371 22.2142C59.6104 27.9533 55.5279 32.9825 49.8775 33.6629C49.8479 33.6629 49.8479 33.6629 49.8183 33.6629H49.7296C49.5521 33.6629 49.3746 33.6629 49.2266 33.7221C46.3571 33.87 43.7241 32.9529 41.7421 31.2667C44.7891 28.545 46.5346 24.4625 46.1796 20.025C45.9725 17.6287 45.1442 15.4396 43.9017 13.5758C45.0258 13.0137 46.3275 12.6587 47.6587 12.5404C53.4571 12.0375 58.6342 16.3567 59.1371 22.2142Z" fill="#E6E6E6"></path><path d="M65.0538 49.5788C64.8171 52.4483 62.9829 54.9333 59.9063 56.6196C56.9479 58.2467 53.2204 59.0158 49.5225 58.9271C51.6525 57.0042 52.895 54.6079 53.1317 52.0638C53.4275 48.3954 51.6821 44.875 48.1913 42.0646C46.2092 40.4967 43.9017 39.2542 41.3871 38.3371C47.925 36.4438 56.1492 37.7158 61.2079 41.7983C63.9296 43.9875 65.32 46.7388 65.0538 49.5788Z" fill="#E6E6E6"></path></svg>');

                        }

                    ?>

                </tbody>

            </table>

            <div class="table_nav">

                <button class="prevPage" disabled>

                    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M6.37999 3.95333L2.33333 8L6.37999 12.0467" stroke="#2D3443" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path><path d="M13.6667 8H2.44667" stroke="#2D3443" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path></svg>
                    
                    <span>Prev</span>
            
                </button>

                <button class="nextPage" disabled>
                    
                    <span>Next</span>

                    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M9.62 3.95334L13.6667 8.00001L9.62 12.0467" stroke="#2D3443" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path><path d="M2.33331 8H13.5533" stroke="#2D3443" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path></svg>
            
                </button>

            </div>

        </div>

    </div>

</section>

<!-- MODAL: Add Joint Holder -->

<div class="popup_window n_displ" role="dialog">

    <div id="iQ_add-joint-user" class="popup_con n_displ">

        <div class="popup_box noScrollBar float_up">

            <div class="popupBox_header">

                <p>Add Joint Holder</p>

                <div class="radial_icon iQ_terminator">

                    <svg width="15" height="15" viewBox="0 0 19 19" fill="none" xmlns="http://www.w3.org/2000/svg" class="close-icon"><path d="M5.80032 5.79883L13.1229 13.1214" stroke="white" stroke-width="1.68132" stroke-linecap="round" stroke-linejoin="round"></path><path d="M5.79958 13.1214L13.1222 5.79883" stroke="white" stroke-width="1.68132" stroke-linecap="round" stroke-linejoin="round"></path></svg>

                </div>

            </div>

            <div class="modal_box">

                <p class="text-min">Please fill in the details</p>

                <form id="jointUserForm" method="post" autocomplete="off">

                    <div class="form_item db">

                        <div class="form_item">

                            <label for="fname">Firstname</label>

                            <input type="text" name="fname" placeholder="Firstname" class="form_field" required>

                        </div>
                        
                        <div class="form_item">

                            <label for="mname">Middlename</label>

                            <input type="text" name="mname" placeholder="Middlename" class="form_field">

                        </div>

                    </div>

                    <div class="form_item db">

                        <div class="form_item">

                            <label for="lname">Lastname</label>

                            <input type="text" name="lname" placeholder="Lastname" class="form_field" required>

                        </div>

                        <div class="form_item">

                            <label for="email">Email Address</label>

                            <input type="email" name="email" placeholder="Email Address" class="form_field" required>

                        </div>

                    </div>

                    <div class="form_item radio">

                        <label for="gender">Gender</label>

                        <div class="iQ_radio" title="Male"><input type="radio" name="gender" value="Male" required> <span>Male</span></div>

                        <div class="iQ_radio" title="Female"><input type="radio" name="gender" value="Female"> <span>Female</span></div>

                        <div class="iQ_radio" title="Others"><input type="radio" name="gender" value="Others"> <span>Others</span></div>

                    </div>

                    <div class="form_item radio">

                        <label for="title">How do you prefer to addressed</label>

                        <div class="iQ_radio" title="Mr"><input type="radio" name="title" value="Mr"> <span>Mr</span></div>

                        <div class="iQ_radio" title="Mrs"><input type="radio" name="title" value="Mrs"> <span>Mrs</span></div>

                        <div class="iQ_radio" title="Ms"><input type="radio" name="title" value="Ms"> <span>Ms</span></div>

                    </div>
                    
                    <div class="form_item">

                        <button id="add-jointUser" name="add-jointUser" class="form_btn" type="submit">Proceed</button>

                        <p style="font-size: 0.6rem; margin-top: 0.5em;">Note: Third party users do not require your transaction PIN or any authentication method to complete their transactions.</p>

                    </div>

                </form>

            </div>

        </div>

    </div>

</div>

<!-- MODAL: Manage Joint Holder -->

<div class="popup_window n_displ" role="dialog">

    <div id="iQ_manage-joint-holder" class="popup_con n_displ">

        <div class="popup_box noScrollBar float_up">

            <div class="popupBox_header">

                <p>Manage Joint User</p>

                <div class="radial_icon iQ_terminator">

                    <svg width="15" height="15" viewBox="0 0 19 19" fill="none" xmlns="http://www.w3.org/2000/svg" class="close-icon"><path d="M5.80032 5.79883L13.1229 13.1214" stroke="white" stroke-width="1.68132" stroke-linecap="round" stroke-linejoin="round"></path><path d="M5.79958 13.1214L13.1222 5.79883" stroke="white" stroke-width="1.68132" stroke-linecap="round" stroke-linejoin="round"></path></svg>

                </div>

            </div>

            <div class="modal_box iQ_panels">

                <div class="flx jSpaceBtw form-tab-con">

                    <div class="iQ_panelSwitch form-tab">Personal Details</div>

                    <div class="iQ_panelSwitch form-tab">Transaction Details</div>

                </div>

                <div class="iQ_panel">

                    <form id="personal-form-holder" method="post" autocomplete="off">

                        <div class="form_item db">

                            <div class="form_item">

                                <label for="fname">Firstname</label>

                                <input type="text" name="fname" placeholder="Firstname" class="form_field" required>

                                <input type="hidden" name="tpy-id">

                            </div>
                            
                            <div class="form_item">

                                <label for="mname">Middlename</label>

                                <input type="text" name="mname" placeholder="Middlename" class="form_field">

                            </div>

                        </div>

                        <div class="form_item db">

                            <div class="form_item">

                                <label for="lname">Lastname</label>

                                <input type="text" name="lname" placeholder="Lastname" class="form_field" required>

                            </div>

                            <div class="form_item">

                                <label for="email">Email Address</label>

                                <input type="email" name="email" placeholder="Email Address" class="form_field" required readonly>

                            </div>

                        </div>

                        <div class="form_item radio">

                            <label for="gender">Gender</label>

                            <div class="iQ_radio" title="Male"><input type="radio" name="gender" value="Male" required> <span>Male</span></div>

                            <div class="iQ_radio" title="Female"><input type="radio" name="gender" value="Female"> <span>Female</span></div>

                            <div class="iQ_radio" title="Others"><input type="radio" name="gender" value="Others"> <span>Others</span></div>

                        </div>

                        <div class="form_item radio">

                            <label for="title">How do you prefer to addressed</label>

                            <div class="iQ_radio" title="Mr"><input type="radio" name="title" value="Mr"> <span>Mr</span></div>

                            <div class="iQ_radio" title="Mrs"><input type="radio" name="title" value="Mrs"> <span>Mrs</span></div>

                            <div class="iQ_radio" title="Ms"><input type="radio" name="title" value="Ms"> <span>Ms</span></div>

                        </div>
                        
                        <div class="form_item">

                            <button id="update-holder-personal" name="update-holder-personal" class="form_btn" type="submit">Update</button>

                        </div>

                    </form>

                </div>

                <div class="iQ_panel n_displ">

                    <form id="banking-form-holder" method="post" autocomplete="off">

                        <div class="form_item db">

                            <div class="form_item">

                                <label for="account-status">Account Status</label>

                                <select class="form_field" name="account-status">

                                    <option value="0">Select Account Status</option>

                                    <option value="ACTIVE">ACTIVE</option>

                                    <option value="SUSPENDED">SUSPENDED</option>

                                    <option value="INACTIVE">INACTIVE</option>

                                    <option value="TRANSFER DISABLED">TRANSFER DISABLED</option>

                                    <option value="WIRE DISABLED">WIRE DISABLED</option>

                                    <option value="LOCAL & TAG DISABLED">LOCAL & TAG DISABLED</option>

                                </select>

                                <input type="hidden" id="tpy-id" name="tpy-id">

                            </div>

                            <div class="form_item">

                                <label for="wth-limit">Withdrawal Limit</label>

                                <input type="number" name="wth-limit" min="0" step="0.01" class="form_field" required>

                            </div>

                        </div>

                        <div class="form_item db">

                            <div class="form_item">

                                <label for="trans-limit">Transaction Limit</label>

                                <input type="number" min="0" name="trans-limit" class="form_field" required>

                            </div>

                            <div class="form_item">

                                <label for="trans-count">Transaction Count</label>

                                <input type="number" min="0" id="transc-count" name="trans-count" class="form_field" readonly required>

                            </div>

                        </div>

                        <div class="form_item radio">

                            <label for="barred">Restrict Account Access</label>

                            <?php

                                foreach($userAccounts as $account):

                                    $currency = $account['currency']; ?>

                                    <div class="iQ_check" title="Restrict accesss to <?= $currency ?> account"><input type="checkbox" name="barred[]" value="<?= $currency ?>"> <span><?= $currency ?></span></div>
                                    
                                <?php endforeach;
                            
                            ?>

                        </div>

                        <div class="form_item db">

                            <div class="form_item">

                                <button id="reset-transc-count" name="reset-transc-count" class="form_btn red" type="button">Reset Count</button>

                            </div>

                            <div class="form_item">

                                <button id="update-holder-banking" name="update-holder-banking" class="form_btn" type="submit">Update</button>

                            </div>

                        </div>

                    </form>

                </div>

            </div>

        </div>

    </div>

</div>

<?php

    require('../partials/footer.php');

?>