<?php

    require('../partials/header.php');

    blockThirdParty();

?>

<?php
                    
    $foundLoan = false; // Flag

    // Fetch Loans

    $loans = mysqli_prepare($conn, "SELECT * FROM `loans` WHERE `user_id` = ?"); // Prepare Statement

    mysqli_stmt_bind_param($loans, "s", $user_id); // Bind Parameter(s)

    mysqli_stmt_execute($loans); // Execute Statement

    $result = mysqli_stmt_get_result($loans); // Get Results

    if (mysqli_num_rows($result) > 0) { // Compare Result Mass

        $foundLoan = true; // Update Flag

        $data = mysqli_fetch_all($result, MYSQLI_ASSOC); // Get Result Data

    }

    mysqli_free_result($result); // Free Result

    mysqli_stmt_close($loans); // Close Statement

    // Check Flag

    if ($foundLoan) { ?>

        <section id="intro">

            <div class="dash_banner jzzvt">

                <div class="jzzvt_box txt">

                    <h4>Loan History</h4>

                    <p>View Loans.</p>

                </div>

                <div class="jzzvt_box prime">

                    <a href="get-loan">Get a Loan</a>

                    <div class="jzzvt_icon" style="background-image: url(../assets/media/images/money-bag.png)"></div>

                </div>

            </div>

        </section>

        <section id="loan">

            <div class="dash_banner">

                <div class="dashBanner_header">

                    <h4 class="dashBanner_title">Loan History</h4>

                    <div class="dhb_Bitem"></div>

                </div>

                <div class="table_con">

                    <table>

                        <thead>

                            <tr>

                                <th>Amount</th>

                                <th class="mobile-0">Type</th>

                                <th class="mobile-0">Term</th>

                                <th class="mobile-0">Interest</th>

                                <th class="mobile-0">Due Date</th>

                                <th class="mobile-0">Status</th>

                                <th colspan="2">Actions</th>

                            </tr>

                        </thead>

                        <tbody>

                            <?php
                            
                                foreach ($data as $row):

                                    $id = $row['loan_id'];
                                    
                                    $type = $row['type'];
                                    
                                    $interest = $row['interest'] . '%';

                                    $term = $row['term'] . ' days';

                                    $due = $row['due'];

                                    $amount = number_format($row['amount'], 2);

                                    $currency = $row['currency'];

                                    $symbol = '<span translate="no">' . $currSymbol[$currency] . '</span>';

                                    $status = $row['status'];

                                    if ($status === 'PAID') {

                                        $icon = '<svg viewBox="0 0 22 22" aria-label="Verified account" role="img"><g><path d="M20.396 11c-.018-.646-.215-1.275-.57-1.816-.354-.54-.852-.972-1.438-1.246.223-.607.27-1.264.14-1.897-.131-.634-.437-1.218-.882-1.687-.47-.445-1.053-.75-1.687-.882-.633-.13-1.29-.083-1.897.14-.273-.587-.704-1.086-1.245-1.44S11.647 1.62 11 1.604c-.646.017-1.273.213-1.813.568s-.969.854-1.24 1.44c-.608-.223-1.267-.272-1.902-.14-.635.13-1.22.436-1.69.882-.445.47-.749 1.055-.878 1.688-.13.633-.08 1.29.144 1.896-.587.274-1.087.705-1.443 1.245-.356.54-.555 1.17-.574 1.817.02.647.218 1.276.574 1.817.356.54.856.972 1.443 1.245-.224.606-.274 1.263-.144 1.896.13.634.433 1.218.877 1.688.47.443 1.054.747 1.687.878.633.132 1.29.084 1.897-.136.274.586.705 1.084 1.246 1.439.54.354 1.17.551 1.816.569.647-.016 1.276-.213 1.817-.567s.972-.854 1.245-1.44c.604.239 1.266.296 1.903.164.636-.132 1.22-.447 1.68-.907.46-.46.776-1.044.908-1.681s.075-1.299-.165-1.903c.586-.274 1.084-.705 1.439-1.246.354-.54.551-1.17.569-1.816zM9.662 14.85l-3.429-3.428 1.293-1.302 2.072 2.072 4.4-4.794 1.347 1.246z" fill="currentColor"></path></g></svg>';
    
                                        $class = ' verified';
    
                                    } else if ($status === 'OVERDUE') {
    
                                        $icon = '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-circle-alert mr-2 h-4 w-4"><circle cx="12" cy="12" r="10"></circle><line x1="12" x2="12" y1="8" y2="12"></line><line x1="12" x2="12.01" y1="16" y2="16"></line></svg>';
    
                                        $class = ' error';
    
                                    } else {
    
                                        $icon = '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-timer mr-2 h-4 w-4 text-muted-foreground"><line x1="10" x2="14" y1="2" y2="2"></line><line x1="12" x2="15" y1="14" y2="11"></line><circle cx="12" cy="14" r="8"></circle></svg>';
    
                                        $class = ' orange';
    
                                    }
    
                                    $status = '<div class="verif v2 sm'. $class .'">
    
                                        <div class="icon">' . $icon . '</div>       
                                        
                                        <span>' . ucwords($status) . '</span>
                                
                                    </div>';

                                ?>    

                                    <tr class="iQ_tRow">

                                        <td><?= $symbol . $amount . '<sup class="label" translate="no">' . $currency . '</sup>' ?></td>

                                        <td class="mobile-0"><?= $type ?></td>

                                        <td class="mobile-0"><?= $term ?></td>

                                        <td class="mobile-0"><?= $interest ?></td>

                                        <td class="mobile-0"><?= date('l M d, Y', strtotime($due)) ?></td>

                                        <td class="mobile-0"><?= $status ?></td>

                                        <td>

                                            <div class="iQ_rqustCon3">

                                                <input type="hidden" value="<?= $id ?>">

                                                <span class="badge pill iQ_rqust" iQ-target="#iQ_loanDetails">Details</span>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="iQ_rqustCon4">

                                                <input type="hidden" value="<?= $id ?>">

                                                <span class="badge pill iQ_rqust" iQ-target="#iQ_loanRepay">Payments</span>

                                            </div>

                                        </td>

                                    </tr>

                                <?php endforeach;
                            
                            ?>

                        </tbody>

                    </table>

                    <div class="table_nav">

                        <button class="prevPage" disabled>

                            <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M6.37999 3.95333L2.33333 8L6.37999 12.0467" stroke="#2D3443" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path><path d="M13.6667 8H2.44667" stroke="#2D3443" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path></svg>
                            
                            <span>Prev</span>
                    
                        </button>

                        <button class="nextPage" disabled>
                            
                            <span>Next</span>

                            <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M9.62 3.95334L13.6667 8.00001L9.62 12.0467" stroke="#2D3443" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path><path d="M2.33331 8H13.5533" stroke="#2D3443" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path></svg>
                    
                        </button>

                    </div>

                </div>

            </div>

        </section>

    <?php } else { ?>

        <section>

            <div class="dash_banner gradient">

                <div class="dashBanner_con grid" style="align-items: center;">

                    <div class="dashCarousel">

                        <div class="dashCarousel_con" id="iQ_sliderc">

                            <div class="dashCarousel_item">

                                <img src="../assets/media/images/money-bag.png" alt="">

                                <div class="txbox">

                                    <p class="b">Apply for multi-currency loans</p>

                                </div>

                            </div>
                            
                        </div>

                    </div>

                    <div class="dashBanner_item ex opaque pdex">
                        
                        <div class="def_txt">

                            <h1 class="def_title">Get loans to get you one step ahead</h1>

                        </div>

                        <div class="highlights">

                            <div>

                                <div class="radial_icon blue xm">

                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none"><path d="M4.05999 8.85335H6.11999V13.6533C6.11999 14.7733 6.72665 15 7.46665 14.16L12.5133 8.42668C13.1333 7.72668 12.8733 7.14668 11.9333 7.14668H9.87332V2.34668C9.87332 1.22668 9.26665 1.00001 8.52665 1.84001L3.47999 7.57335C2.86665 8.28001 3.12665 8.85335 4.05999 8.85335Z" stroke="#2467E3" stroke-width="1.2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path></svg>

                                </div>

                                <span>Friendly Interest rates</span>

                            </div>

                            <div>

                                <div class="radial_icon blue xm">

                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none"><path d="M10.0005 18.2037C14.532 18.2037 18.2056 14.5302 18.2056 9.99859C18.2056 5.46702 14.532 1.79346 10.0005 1.79346C5.46891 1.79346 1.79535 5.46702 1.79535 9.99859C1.79535 14.5302 5.46891 18.2037 10.0005 18.2037Z" stroke="#2467E3" stroke-width="1.23077" stroke-linecap="round" stroke-linejoin="round"></path><path d="M6.71835 2.61377H7.53887C5.93887 7.40556 5.93887 12.5912 7.53887 17.383H6.71835" stroke="#2467E3" stroke-width="1.23077" stroke-linecap="round" stroke-linejoin="round"></path><path d="M12.462 2.61377C14.062 7.40556 14.062 12.5912 12.462 17.383" stroke="#2467E3" stroke-width="1.23077" stroke-linecap="round" stroke-linejoin="round"></path><path d="M2.61584 13.2805V12.46C7.40764 14.06 12.5933 14.06 17.3851 12.46V13.2805" stroke="#2467E3" stroke-width="1.23077" stroke-linecap="round" stroke-linejoin="round"></path><path d="M2.61584 7.53716C7.40764 5.93716 12.5933 5.93716 17.3851 7.53716" stroke="#2467E3" stroke-width="1.23077" stroke-linecap="round" stroke-linejoin="round"></path></svg>

                                </div>

                                <span>Multi-currency...</span>

                            </div>

                        </div>

                        <div class="jzzvt_box prime varB variantBlue" style="width: 100%; margin: 0 auto;">

                            <a style="font-weight: 600; width: 100%; margin: 0;" href="get-loan">Apply Now</a>

                        </div>

                    </div>

                </div>

            </div>

        </section>
        
    <?php }

?>

<!-- Modal: Loan Details -->

<div class="popup_window n_displ" role="dialog">

    <div id="iQ_loanDetails" class="popup_con n_displ">

        <div class="popup_box noScrollBar float_up">

            <div class="popupBox_header">

                <p>Loan Details</p>

                <div class="radial_icon iQ_terminator">

                    <svg width="15" height="15" viewBox="0 0 19 19" fill="none" xmlns="http://www.w3.org/2000/svg" class="close-icon"><path d="M5.80032 5.79883L13.1229 13.1214" stroke="white" stroke-width="1.68132" stroke-linecap="round" stroke-linejoin="round"></path><path d="M5.79958 13.1214L13.1222 5.79883" stroke="white" stroke-width="1.68132" stroke-linecap="round" stroke-linejoin="round"></path></svg>

                </div>

            </div>

            <div class="modal_box">

                <div id="loanRqst"></div>

            </div>

        </div>

    </div>

</div>

<!-- Modal: Loan Repayment -->

<div class="popup_window n_displ" role="dialog">

    <div id="iQ_loanRepay" class="popup_con n_displ">

        <div class="popup_box noScrollBar float_up">

            <div class="popupBox_header">

                <p>Repay Loan</p>

                <div class="radial_icon iQ_terminator">

                    <svg width="15" height="15" viewBox="0 0 19 19" fill="none" xmlns="http://www.w3.org/2000/svg" class="close-icon"><path d="M5.80032 5.79883L13.1229 13.1214" stroke="white" stroke-width="1.68132" stroke-linecap="round" stroke-linejoin="round"></path><path d="M5.79958 13.1214L13.1222 5.79883" stroke="white" stroke-width="1.68132" stroke-linecap="round" stroke-linejoin="round"></path></svg>

                </div>

            </div>

            <div class="modal_box">

                <div id="repayVal"></div>

            </div>

        </div>

    </div>

</div>

<?php

    require('../partials/footer.php');

?>