<?php

    // Fallback Logout Page

    session_name('USERSESSID');

session_start(); // Initiate Session(s)

    require('../controls/config/config.php'); // Configuration Setup

    require('../controls/engines/fxns.php'); // Function Definition(s)

    // Logout: Update Login Activity (Date) Based on COOKIE['ACCESS-TOKEN'] (`token`)

    if (!isset($_SESSION['CURRENT-USER']) || !isset($_SESSION['USER-TYPE'])) {

        echo '<script>

            setTimeout(() => {
            
                window.location.href = "../auth";
            
            }, 7000);

        </script>';

        exit; // End Run

    }

    $user = $_SESSION['CURRENT-USER'];

    $userType = $_SESSION['USER-TYPE'];

    $token = $_COOKIE['ACCESS-iD'] ?? null;

    setTimezone($conn, $token, $user, $userType); // Set Timezone  

    if ($userType != 'THIRD PARTY') {

        finalLog($conn, $user, $token);

    }

    $_SESSION = [];

session_destroy();

    echo '<script>

        setTimeout(() => {
        
            window.location.href = "../auth";
        
        }, 7000);

    </script>';


?>

<!DOCTYPE html>

<html>

<head>

    <meta charset="UTF-8">

    <meta http-equiv="X-UA-compatible" content="ie=edge">

    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">

    <link rel="icon" href="<?= SITE_FAVICON ?>">

    <link rel="stylesheet" type="text/css" href="../assets/stylesheets/core.css">

    <script>
        (function() {
            const page = document.documentElement; //|| document.body; // Ensure it's the right element to modify

            // Check system preference and localStorage immediately
            const systemPreferenceDark = window.matchMedia('(prefers-color-scheme: dark)').matches;

            // Apply theme if dark mode is preferred by the user or if stored in localStorage
            if (localStorage.pageClass === 'darkmode' || (systemPreferenceDark && localStorage.pageClass === undefined)) {
                page.classList.add('darkmode');
            }
        })();
    </script>

    <script type="text/javascript" src="../assets/scripts/script.js" defer></script>

    <style>

        .logout_con {

            display: flex;

            flex-direction: column;

            justify-content: center;

            align-items: center;

            gap: 1.5em;

            width: 100%;

            min-height: 100vh;

            user-select: none;

        }

        .logout_element {

            width: 2.5em;

            height: 2.5em;

            border: 3px solid var(--pg-red);

            /* border-right-color: var(--pg-txt); */

            border-radius: 100%;

            animation-name: rotate, spool;

            animation-duration: 1.2s, 2s;

            animation-timing-function: linear, ease-in-out;

            animation-iteration-count: infinite;

        }

        @keyframes spool {

            0% {

                border-right-color: transparent;

            }

            25% {

                border-left-color: transparent;

            }

            50% {

                border-top-color: transparent;

            }

            100% {

                border-bottom-color: transparent;

            }

        }

    </style>

    <title>Terminating Session</title>

</head>

<body>

    <div class="logout_con">

        <!-- <div class="logout_element"></div> -->

        <div class="propeller"></div>

        <p>Logging out...</p>

    </div>

    <!-- <script>

        let term = document.querySelector('.logout_con p');

        let vals = ["Terminating Session...", "Logging Out...", "Adios...", "Do Check In Soon..."];

        term.innerHTML = vals[Math.floor(Math.random() * vals.length)];
            
    </script> -->

    <!-- Toast -->

    <div id="toast" class="n_displ"></div>

    <script src="../assets/scripts/toast-notify.js"></script>

    <!-- Google Translate -->

    <script>window.gtranslateSettings = {"default_language":"en","native_language_names":true,"detect_browser_language":true,"wrapper_selector":".gtranslate_wrapper","flag_size":16}</script>
    <script src="https://cdn.gtranslate.net/widgets/latest/popup.js" defer></script>

</body>

</html>