<?php

    require('../partials/header.php');

    blockThirdParty(); // Block Third Party

    $extraScripts = <<<HTML

        <!-- Intl Tel Input -->

        <script src="../resources/intl-tel-input/intlTelInputWithUtils.js"></script>
    
    HTML;

?>

<section>

    <div class="dash_banner">

        <div class="dashBanner_header">

            <h4 class="dashBanner_title">Bills, Airtime & Gift Cards</h4>

        </div>

        <div class="dashBanner_con grid mobile-grid">

            <div class="dashBanner_item">

                <a iQ-target="#buyAirtime">

                    <img class="dshBi_icon" src="../assets/media/icons/airtime.svg" alt="">

                    <div class="txbox">

                        <p class="txTitle">Buy Airtime</p>

                        <p class="desc">Stay connected with your family and friends with instant top-ups</p>

                    </div>

                </a>

            </div>

            <div class="dashBanner_item">

                <a iQ-target="#buyData">

                    <img class="dshBi_icon" src="../assets/media/icons/internet.svg" alt="">

                    <div class="txbox">

                        <p class="txTitle">Buy Data</p>

                        <p class="desc">Enjoy uninterrupted internet access with easy and convenient mobile data top-ups</p>

                    </div>


                </a>

                
            </div>

            <div class="dashBanner_item blur">

                <a href="#">

                    <div class="state_device">

                        <span>Coming Soon</span>

                    </div>

                    <img class="dshBi_icon" src="../assets/media/icons/bill.svg" alt="">

                    <div class="txbox">

                        <p class="txTitle">Pay Bills</p>

                        <p class="desc">Pay for your internet, cable subscription and other utility bills all in one place</p>

                    </div>

                </a>
                
            </div>

            <div class="dashBanner_item blur">

                <a href="#">

                    <div class="state_device">

                        <span>Coming Soon</span>

                    </div>

                    <img class="dshBi_icon" src="../assets/media/icons/gift-card.svg" alt="">

                    <div class="txbox">

                        <p class="txTitle">Gift cards</p>

                        <p class="desc">Buy gift cards for yourself or your loved ones</p>

                    </div>

                </a>

            </div>

            <div class="dashBanner_item">

                <a iQ-target="#iQ-uetr">

                    <img class="dshBi_icon" src="../assets/media/icons/m-glass.png" alt="">

                    <div class="txbox">

                        <p class="txTitle">UETR</p>

                        <p class="desc">Track your local and cross-border payments.</p>

                    </div>

                </a>

            </div>

        </div>

    </div>

</section>

<section>

    <div class="dash_banner">

        <div class="dashBanner_header">

            <h4 class="dashBanner_title">Send, Fund & Receive</h4>

        </div>

        <div class="dashBanner_con wrap">

            <div class="dashBanner_item">

                <a iQ-target="#sendFunds">

                    <img class="dshBi_icon" src="../assets/media/icons/send.svg" alt="">

                    <div class="txbox">

                        <p class="txTitle">Send Money</p>

                        <p class="desc">Send money to 80+ countries instantly</p>

                    </div>

                </a>

            </div>


            <div class="dashBanner_item">

                <a iQ-target="#addFunds">

                    <img class="dshBi_icon" src="../assets/media/icons/deposit.svg" alt="">

                    <div class="txbox">

                        <p class="txTitle">Add Money</p>

                        <p class="desc">Fund your account(s) instantly</p>

                    </div>

                </a>

            </div>

            <div class="dashBanner_item">

                <a href="invoices">

                    <img class="dshBi_icon" src="../assets/media/icons/invoice.svg" alt="">

                    <div class="txbox">

                        <p class="txTitle">Invoices</p>

                        <p class="desc">Create and send multi-currency invoices to clients and employers</p>

                    </div>

                </a>
                
            </div>
            
        </div>

    </div>

</section>

<!-- Modal: Buy Airtime -->

<div class="popup_window n_displ" role="dialog">

    <div id="buyAirtime" class="popup_con n_displ">

        <div class="popup_box noScrollBar float_up">

            <div class="popupBox_header">

                <p>Purchase Airtime</p>

                <div class="radial_icon iQ_terminator">

                    <svg width="15" height="15" viewBox="0 0 19 19" fill="none" xmlns="http://www.w3.org/2000/svg" class="close-icon"><path d="M5.80032 5.79883L13.1229 13.1214" stroke="white" stroke-width="1.68132" stroke-linecap="round" stroke-linejoin="round"></path><path d="M5.79958 13.1214L13.1222 5.79883" stroke="white" stroke-width="1.68132" stroke-linecap="round" stroke-linejoin="round"></path></svg>

                </div>

            </div>

            <div class="modal_box">

                <form id="airtimeForm" method="post" autocomplete="off">

                    <div class="form_item db">

                        <div class="form_item">

                            <label for="provider">Provider</label>

                            <input class="form_field" type="text" name="provider" required>

                        </div>

                        <div class="form_item">

                            <label for="telephone">Phone</label>

                            <input class="form_field" type="tel" name="telephone" required>

                        </div>

                    </div>

                    <div class="form_item db">

                        <div class="form_item">

                            <label for="account">Account</label>

                            <select name="account" class="form_field">

                                <option value="0">Select Account</option>

                                <?php

                                    if ($userAccounts) {
                                
                                        foreach ($userAccounts as $row): ?>

                                            <option value="<?= $row['acc_id'] ?>"><?= $row['currency'] . ' (' . $currSymbol[$row['currency']] . number_format($row['balance'], 2) . ')' ?></option>

                                        <?php endforeach;

                                    }
                                
                                ?>

                            </select>

                        </div>

                        <div class="form_item">

                            <label for="amount">Amount</label>

                            <input type="number" step="0.01" name="amount" class="form_field" required>

                        </div>

                    </div>

                    <div class="form_item">

                        <button name="airtime" class="form_btn" id="airtimeBtn">Proceed</button>

                    </div>

                </form>

            </div>

        </div>

    </div>

</div>

<!-- Modal: Buy Data -->

<div class="popup_window n_displ" role="dialog">

    <div id="buyData" class="popup_con n_displ">

        <div class="popup_box noScrollBar float_up">

            <div class="popupBox_header">

                <p>Purchase Data</p>

                <div class="radial_icon iQ_terminator">

                    <svg width="15" height="15" viewBox="0 0 19 19" fill="none" xmlns="http://www.w3.org/2000/svg" class="close-icon"><path d="M5.80032 5.79883L13.1229 13.1214" stroke="white" stroke-width="1.68132" stroke-linecap="round" stroke-linejoin="round"></path><path d="M5.79958 13.1214L13.1222 5.79883" stroke="white" stroke-width="1.68132" stroke-linecap="round" stroke-linejoin="round"></path></svg>

                </div>

            </div>

            <div class="modal_box">

                <form id="dataForm" method="post" autocomplete="off">

                    <div class="form_item db">

                        <div class="form_item">

                            <label for="provider">Provider</label>

                            <input class="form_field" type="text" name="provider" required>

                        </div>

                        <div class="form_item">

                            <label for="telephone">Phone</label>

                            <input class="form_field" type="tel" name="telephone" required>

                        </div>

                    </div>

                    <div class="form_item db">

                        <div class="form_item">

                            <label for="account">Account</label>

                            <select name="account" class="form_field">

                                <option value="0">Select Account</option>

                                <?php

                                    if ($userAccounts) {
                                
                                        foreach ($userAccounts as $row): ?>

                                            <option value="<?= $row['acc_id'] ?>"><?= $row['currency'] . ' (' . $currSymbol[$row['currency']] . number_format($row['balance'], 2) . ')' ?></option>

                                        <?php endforeach;

                                    }
                                    
                                ?>

                            </select>

                        </div>

                        <div class="form_item">

                            <label for="amount">Amount</label>

                            <input type="number" step="0.01" name="amount" class="form_field" required>

                        </div>

                    </div>

                    <div class="form_item">

                        <button name="airtime" class="form_btn" id="dataBtn">Proceed</button>

                    </div>

                </form>

            </div>

        </div>

    </div>

</div>

<!-- MODAL: UETR -->

<div class="popup_window n_displ" role="dialog">

    <div id="iQ-uetr" class="popup_con n_displ">

        <div class="popup_box noScrollBar float_up">

            <div class="popupBox_header">

                <p>Track Payments</p>

                <div class="radial_icon iQ_terminator">

                    <svg width="15" height="15" viewBox="0 0 19 19" fill="none" xmlns="http://www.w3.org/2000/svg" class="close-icon"><path d="M5.80032 5.79883L13.1229 13.1214" stroke="white" stroke-width="1.68132" stroke-linecap="round" stroke-linejoin="round"></path><path d="M5.79958 13.1214L13.1222 5.79883" stroke="white" stroke-width="1.68132" stroke-linecap="round" stroke-linejoin="round"></path></svg>

                </div>

            </div>

            <div class="modal_box">

                <form id="track-uetr-form" method="post" autocomplete="off">

                    <div class="form_item">

                        <label for="provider">UETR (Unique-End-To-End-Transaction-Reference)</label>

                        <input class="form_field" type="text" name="uetr-code" required>

                    </div>

                    <div class="form_item">

                        <button name="airtime" class="form_btn" id="track-uetr">Proceed &rarr;</button>

                    </div>

                </form>

            </div>

        </div>

    </div>

</div>

<?php

    require('../partials/footer.php');

?>