<?php

    require('../partials/header.php');

    blockThirdParty();

?>

<section id="profile">

    <div class="iQ_panels">

    <div class="dash_banner v2">

        <div class="page_panelTab noScrollBar" style="flex-wrap: wrap;">

            <div class="page_panelSwitch iQ_panelSwitch active" data-tab="user">Basic information</div>

            <div class="page_panelSwitch iQ_panelSwitch" data-tab="investments">Investments</div>

            <div class="page_panelSwitch iQ_panelSwitch" data-tab="referrals">Referrals</div>

        </div>

    </div>

    <div class="iQ_panelDispl tabs">

        <div class="iQ_panel" id="user">

            <div class="dash_banner v2">

                <div class="dashBanner_box vFlx">

                    <div class="dB_boxItem vFlx user_box">

                        <div>

                            <a class="user_profile radial_link image variantBlue" iQ-target="#iQ_Avatar">

                                <?php
                                
                                    if (is_null($userData['profile-image']) || !file_exists('../' . str_replace('../', '', $userData['profile-image']))) {

                                        echo '<span translate="no">' . strtoupper(join('', [$userData['firstname'][0], $userData['lastname'][0]])) . '</span>';

                                    } else {

                                        echo '<img src="'. $siteURL . '/' . str_replace('../', '', $userData['profile-image']). '" alt>';

                                    }
                                
                                ?>

                            </a>

                        </div>

                        <div class="user_desc">

                            <h4 translate="no"><?= join(' ', [$userData['firstname'], $userData['middlename'], $userData['lastname']]) ?></h4>

                            <p translate="no"><?= $userData['email'] ?></p>

                        </div>

                    </div>

                    <div class="dB_boxItem">

                        <?php
                        
                            if ($userData['kyc-status'] === 'VERIFIED') {

                                $icon = '<svg viewBox="0 0 22 22" aria-label="Verified account" role="img"><g><path d="M20.396 11c-.018-.646-.215-1.275-.57-1.816-.354-.54-.852-.972-1.438-1.246.223-.607.27-1.264.14-1.897-.131-.634-.437-1.218-.882-1.687-.47-.445-1.053-.75-1.687-.882-.633-.13-1.29-.083-1.897.14-.273-.587-.704-1.086-1.245-1.44S11.647 1.62 11 1.604c-.646.017-1.273.213-1.813.568s-.969.854-1.24 1.44c-.608-.223-1.267-.272-1.902-.14-.635.13-1.22.436-1.69.882-.445.47-.749 1.055-.878 1.688-.13.633-.08 1.29.144 1.896-.587.274-1.087.705-1.443 1.245-.356.54-.555 1.17-.574 1.817.02.647.218 1.276.574 1.817.356.54.856.972 1.443 1.245-.224.606-.274 1.263-.144 1.896.13.634.433 1.218.877 1.688.47.443 1.054.747 1.687.878.633.132 1.29.084 1.897-.136.274.586.705 1.084 1.246 1.439.54.354 1.17.551 1.816.569.647-.016 1.276-.213 1.817-.567s.972-.854 1.245-1.44c.604.239 1.266.296 1.903.164.636-.132 1.22-.447 1.68-.907.46-.46.776-1.044.908-1.681s.075-1.299-.165-1.903c.586-.274 1.084-.705 1.439-1.246.354-.54.551-1.17.569-1.816zM9.662 14.85l-3.429-3.428 1.293-1.302 2.072 2.072 4.4-4.794 1.347 1.246z" fill="currentColor"></path></g></svg>';

                                $class = ' verified';

                                $status = $userData['kyc-status'];

                            } else if ($userData['kyc-status'] === 'REJECTED') {

                                $icon = '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-circle-alert mr-2 h-4 w-4"><circle cx="12" cy="12" r="10"></circle><line x1="12" x2="12" y1="8" y2="12"></line><line x1="12" x2="12.01" y1="16" y2="16"></line></svg>';

                                $class = ' error';

                                $status = 'INVALID';

                            } else  if ($userData['kyc-status'] === 'PROCESSING') {

                                $icon = '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-timer mr-2 h-4 w-4 text-muted-foreground"><line x1="10" x2="14" y1="2" y2="2"></line><line x1="12" x2="15" y1="14" y2="11"></line><circle cx="12" cy="14" r="8"></circle></svg>';

                                $class = null;

                                $status = $userData['kyc-status'];

                            } else {

                                $icon = '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-circle-help mr-2 h-4 w-4 text-muted-foreground"><circle cx="12" cy="12" r="10"></circle><path d="M9.09 9a3 3 0 0 1 5.83 1c0 2-3 3-3 3"></path><path d="M12 17h.01"></path></svg>';

                                $class = ' error';

                                $status = $userData['kyc-status'] ?? 'UNVERIFIED';

                            }

                            echo '<div class="verif'. $class .'">

                                <div class="icon">' . $icon . '</div>       
                                
                                <span>' . $status . '</span>
                        
                            </div>';
                        
                        ?>

                    </div>

                </div>

            </div>

            <div class="dash_banner v2">

                <div class="dashBanner_header">

                    <div class="dbHeader_item">

                        <h4 class="dashBanner_title">Personal Info</h4>

                    </div>

                </div>

                <div class="dashBanner_box">

                    <div class="dB_boxItem">

                        <div class="dB_boxHeading">First name</div>

                        <p translate="no"><?= $userData['firstname']; ?></p>

                    </div>

                    <div class="dB_boxItem">

                        <div class="dB_boxHeading">Middle name</div>

                        <p translate="no"><?= $userData['middlename'] != null ? $userData['middlename'] : '-'; ?></p>

                    </div>

                    <div class="dB_boxItem">

                        <div class="dB_boxHeading">Last name</div>

                        <p translate="no"><?= $userData['lastname']; ?></p>

                    </div>

                    <div class="dB_boxItem">

                        <div class="dB_boxHeading">Date of birth</div>

                        <p><?= ($userData['dob'] == NULL) ? '-' : date('d M, Y', strtotime($userData['dob'])); ?></p>

                    </div>

                    <div class="dB_boxItem">

                        <div class="dB_boxHeading">Email address</div>

                        <p translate="no"><?= $userData['email'] ?></p>

                    </div>

                    <div class="dB_boxItem">

                        <div class="dB_boxHeading">Phone number</div>

                        <p><?= trim(chunk_split($userData['phone'], 4, ' ')) ?></p>

                    </div>

                    <div class="dB_boxItem">

                        <div class="dB_boxHeading">Registered</div>

                        <p translate="no"><?= date('l F dS, Y', strtotime($userData['reg-date'])) ?></p>

                    </div>

                </div>

            </div>

            <div class="dash_banner v2">

                <div class="dashBanner_header">

                    <div class="dbHeader_item">

                        <h4 class="dashBanner_title"><?= SITE_NAME ?> Tag</h4>

                    </div>

                    <div class="dbHeader_item" iQ-target="#iQ_id">

                        <div class="flx" style="gap: 0.2em; padding: 0.5em; color: var(--pg-link);">

                            <div class="icon">

                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none"><path d="M8.84202 3.62602L3.36868 9.41935C3.16202 9.63935 2.96202 10.0727 2.92202 10.3727L2.67535 12.5327C2.58868 13.3127 3.14868 13.846 3.92202 13.7127L6.06868 13.346C6.36868 13.2927 6.78868 13.0727 6.99535 12.846L12.4687 7.05268C13.4154 6.05268 13.842 4.91268 12.3687 3.51935C10.902 2.13935 9.78868 2.62602 8.84202 3.62602Z" stroke="#2467E3" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.92871 4.59241C8.21538 6.43241 9.70871 7.83907 11.562 8.02574" stroke="#2467E3" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path></svg>

                            </div>

                            <span>Edit</span>

                        </div>

                    </div>

                </div>

                <div class="dashBanner_box">

                    <div class="dB_boxItem">

                        <div class="dB_boxHeading">Username</div>

                        <p translate="no"><?= ($userData['tag'] == NULL) ? '(EMPTY)' : $userData['tag']; ?></p>

                    </div>

                </div>

            </div>

        </div>

        <div class="iQ_panel n_displ" id="investments">

            <div class="dash_banner jzzvt">

                <div class="jzzvt_box txt">

                    <h4>Investments</h4>

                    <p>Review your portfolio.</p>

                </div>

                <!-- <div class="jzzvt_box prime">

                    <div class="jzzvt_icon" style="background-image: url(../assets/media/images/invest.png)"></div>

                </div> -->

            </div>

            <div class="dash_banner v2">

                <div class="dashBanner_header">

                    <div class="dbHeader_item">

                        <h4 class="dashBanner_title">Overview</h4>

                    </div>

                </div>

                <div class="dashPanel_con">

                    <div class="refElements_con">

                        <div class="ref_element min">

                            <div class="flx jSpaceBtw">

                                <p>CRYPTO</p>

                                <div class="ref_icon">

                                    <img src="../assets/media/icons/crypto.svg" alt="">

                                </div>

                            </div>

                            <div class="ref_value"><?= shortenNumber(cryptoSubs($user_id, $conn)) ?></div>

                        </div>

                        <div class="ref_element min">

                            <div class="flx jSpaceBtw">

                                <p>STOCKS</p>

                                <div class="ref_icon">

                                    <img src="../assets/media/icons/stocks.svg" alt="">

                                </div>

                            </div>

                            <div class="ref_value"><?= shortenNumber(stocksSubs($user_id, $conn)) ?></div>

                        </div>

                        <div class="ref_element min">

                            <div class="flx jSpaceBtw">

                                <p>FX</p>

                                <div class="ref_icon">

                                    <img src="../assets/media/icons/fx.svg" alt="">

                                </div>

                            </div>

                            <div class="ref_value"><?= shortenNumber(fxSubs($user_id, $conn)) ?></div>

                        </div>

                        <div class="ref_element min">

                            <div class="flx jSpaceBtw">

                                <p>COMMODITY</p>

                                <div class="ref_icon">

                                    <img src="../assets/media/icons/commodity.svg" alt="">

                                </div>

                            </div>

                            <div class="ref_value"><?= shortenNumber(commoditySubs($user_id, $conn)) ?></div>

                        </div>

                        <div class="ref_element min">

                            <div class="flx jSpaceBtw">

                                <p>REALTY</p>

                                <div class="ref_icon">

                                    <img src="../assets/media/icons/real-estate.svg" alt="">

                                </div>

                            </div>

                            <div class="ref_value"><?= shortenNumber(realtySubs($user_id, $conn)) ?></div>

                        </div>

                        <div class="ref_element min">

                            <div class="flx jSpaceBtw">

                                <p>OPTIONS</p>

                                <div class="ref_icon">

                                    <img src="../assets/media/icons/options.svg" alt="">

                                </div>

                            </div>

                            <div class="ref_value"><?= shortenNumber(optionsSubs($user_id, $conn)) ?></div>

                        </div>

                        <div class="ref_element min">

                            <div class="flx jSpaceBtw">

                                <p>BONDS</p>

                                <div class="ref_icon">

                                    <img src="../assets/media/icons/bonds.svg" alt="">

                                </div>

                            </div>

                            <div class="ref_value"><?= shortenNumber(bondsSubs($user_id, $conn)) ?></div>

                        </div>

                        <div class="ref_element min">

                            <div class="flx jSpaceBtw">

                                <p>OTHERS</p>

                                <div class="ref_icon">

                                    <img src="../assets/media/icons/others.svg" alt="">

                                </div>

                            </div>

                            <div class="ref_value"><?= shortenNumber(miscSubs($user_id, $conn)) ?></div>

                        </div>

                    </div>

                    <div class="table_con">

                        <table>

                            <thead>

                                <tr>

                                    <th>Item</th>

                                    <th>Subscribed</th>

                                    <th>Expires</th>
            
                                </tr>

                            </thead>

                            <tbody>

                                <?php
                                
                                    $subscriptions = false; // Flag

                                    $stmt = mysqli_prepare($conn, "SELECT * FROM `subscriptions` WHERE `user_id` = ? AND `status` = ? ORDER BY `starts` DESC"); // Prepare Statement

                                    $status = 'ACTIVE';

                                    mysqli_stmt_bind_param($stmt, "ss", $user_id, $status); // Bind Parameter(s)

                                    mysqli_stmt_execute($stmt); // Execute Statement

                                    $result = mysqli_stmt_get_result($stmt); // Get Statement Result

                                    if (mysqli_num_rows($result) > 0) {

                                        $subscriptions = true; // Update Flag

                                        $data = mysqli_fetch_all($result, MYSQLI_ASSOC);

                                    }

                                    mysqli_free_result($result); // Free Result

                                    mysqli_stmt_close($stmt); // Close Statement

                                    // Consider Flag

                                    if ($subscriptions) {

                                        foreach ($data as $row):

                                            $type = $row['type'];

                                            $item = $row['item'];

                                            $start = $row['starts'];

                                            $expires = $row['expires']; ?>

                                            <tr class="iQ_tRow">

                                                <td><span class="hint--bottom" aria-label="<?= $type ?>"><?= $item ?></span></td>

                                                <td><span class="hint--bottom" aria-label="<?php echo date('h:i A', strtotime($start)); ?>"><?php echo date('l M d, Y', strtotime($start)); ?></span></td>

                                                <td><span class="hint--bottom" aria-label="<?php echo date('h:i A', strtotime($expires)); ?>"><?php echo date('l M d, Y', strtotime($expires)); ?></span></td>

                                            </tr>

                                        <?php endforeach;    

                                    } else {

                                        emptyTable('No active subscription!', '<svg width="40" height="40" viewBox="0 0 40 40" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M26.984 3.33331H13.0173C6.95065 3.33331 3.33398 6.94998 3.33398 13.0166V26.9666C3.33398 33.05 6.95065 36.6666 13.0173 36.6666H26.9673C33.034 36.6666 36.6507 33.05 36.6507 26.9833V13.0166C36.6673 6.94998 33.0507 3.33331 26.984 3.33331ZM28.7673 16.6L24.9173 21.5666C24.434 22.1833 23.7507 22.5833 22.9673 22.6666C22.184 22.7666 21.4173 22.55 20.8007 22.0666L17.7507 19.6666C17.634 19.5666 17.5007 19.5666 17.434 19.5833C17.3673 19.5833 17.2507 19.6166 17.1507 19.75L13.184 24.9C12.934 25.2166 12.5673 25.3833 12.2007 25.3833C11.934 25.3833 11.6673 25.3 11.434 25.1166C10.884 24.7 10.784 23.9166 11.2007 23.3666L15.1673 18.2166C15.6507 17.6 16.334 17.2 17.1173 17.1C17.884 17 18.6673 17.2166 19.284 17.7L22.334 20.1C22.4507 20.2 22.5673 20.2 22.6507 20.1833C22.7173 20.1833 22.834 20.15 22.934 20.0166L26.784 15.05C27.2007 14.5 28.0007 14.4 28.534 14.8333C29.084 15.2833 29.184 16.0666 28.7673 16.6Z" fill="#C2C9D6"></path></svg>');

                                    }
                                
                                ?>
                                
                            </tbody>

                        </table>

                        <div class="table_nav">

                            <button class="prevPage" disabled>

                                <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M6.37999 3.95333L2.33333 8L6.37999 12.0467" stroke="#2D3443" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path><path d="M13.6667 8H2.44667" stroke="#2D3443" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path></svg>
                                
                                <span>Prev</span>
                        
                            </button>

                            <button class="nextPage" disabled>
                                
                                <span>Next</span>

                                <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M9.62 3.95334L13.6667 8.00001L9.62 12.0467" stroke="#2D3443" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path><path d="M2.33331 8H13.5533" stroke="#2D3443" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path></svg>
                        
                            </button>

                        </div>

                    </div>

                </div>

            </div>

        </div>

        <div class="iQ_panel n_displ" id="referrals">

            <div class="dash_banner jzzvt">

                <div class="jzzvt_box txt">

                    <h4>Refer a friend and earn $5</h4>

                    <p>Invite a friend and get $5 when your friend signs up.</p>

                </div>

                <div class="jzzvt_box">

                    <form method="post" id="referralForm">
                                
                        <div style="display: flex; align-items: center; flex-wrap: wrap; gap: 0.5em;">
                        
                            <input name="invitee" type="email" class="ref_field" placeholder="Enter email address" required>

                            <button type="submit" class="ref_field" id="iQ_refer">Invite</button> 
                        
                        </div>

                    </form>

                </div>

            </div>

            <div class="dash_banner v2">

                <div class="dashPanel_con">

                    <div class="refElements_con">

                        <div class="ref_element">

                            <div class="flx jSpaceBtw">

                                <p>Referrals Sent</p>

                                <div class="ref_icon">

                                    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M4.93313 4.21344L10.5931 2.32677C13.1331 1.4801 14.5131 2.86677 13.6731 5.40677L11.7865 11.0668C10.5198 14.8734 8.43979 14.8734 7.17313 11.0668L6.61312 9.38677L4.93313 8.82677C1.12646 7.5601 1.12646 5.48677 4.93313 4.21344Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path><path d="M6.74023 9.10012L9.1269 6.70679" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path></svg>

                                </div>

                            </div>

                            <div class="ref_value"><?= shortenNumber(referralsCount($user_id, $conn)) ?></div>

                        </div>

                        <div class="ref_element">

                            <div class="flx jSpaceBtw">

                                <p>Active users</p>

                                <div class="ref_icon">

                                    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M6.10671 7.24659C6.04004 7.23992 5.96004 7.23992 5.88671 7.24659C4.30004 7.19325 3.04004 5.89325 3.04004 4.29325C3.04004 2.65992 4.36004 1.33325 6.00004 1.33325C7.63337 1.33325 8.96004 2.65992 8.96004 4.29325C8.95337 5.89325 7.69337 7.19325 6.10671 7.24659Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path><path d="M10.9402 2.66675C12.2335 2.66675 13.2735 3.71341 13.2735 5.00008C13.2735 6.26008 12.2735 7.28675 11.0268 7.33341C10.9735 7.32675 10.9135 7.32675 10.8535 7.33341" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path><path d="M2.77348 9.70675C1.16014 10.7867 1.16014 12.5467 2.77348 13.6201C4.60681 14.8467 7.61348 14.8467 9.44681 13.6201C11.0601 12.5401 11.0601 10.7801 9.44681 9.70675C7.62014 8.48675 4.61348 8.48675 2.77348 9.70675Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path><path d="M12.2266 13.3333C12.7066 13.2333 13.1599 13.0399 13.5332 12.7533C14.5732 11.9733 14.5732 10.6866 13.5332 9.90659C13.1666 9.62659 12.7199 9.43992 12.2466 9.33325" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path></svg>

                                </div>

                            </div>

                            <div class="ref_value"><?= shortenNumber(activeReferrals($user_id, $conn)) ?></div>

                        </div>

                        <div class="ref_element">

                            <div class="flx jSpaceBtw">

                                <p>Total earnings</p>

                                <div class="ref_icon">

                                    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M8.43997 1.67868L8.41997 1.72534L6.48664 6.21201H4.58664C4.13331 6.21201 3.69997 6.30534 3.30664 6.47201L4.47331 3.68534L4.49997 3.61868L4.54664 3.51201C4.55997 3.47201 4.57331 3.43201 4.59331 3.39868C5.46664 1.37868 6.45331 0.918676 8.43997 1.67868Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path><path d="M12.0335 6.34538C11.7335 6.25204 11.4135 6.21204 11.0935 6.21204H6.48682L8.42015 1.72538L8.44015 1.67871C8.54015 1.71204 8.63348 1.75871 8.73348 1.79871L10.2068 2.41871C11.0268 2.75871 11.6001 3.11204 11.9468 3.53871C12.0135 3.61871 12.0668 3.69204 12.1135 3.77871C12.1735 3.87204 12.2202 3.96538 12.2468 4.06538C12.2735 4.12538 12.2935 4.18538 12.3068 4.23871C12.4868 4.79871 12.3802 5.48538 12.0335 6.34538Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path><path d="M14.348 9.46549V10.7655C14.348 10.8988 14.3413 11.0322 14.3346 11.1655C14.208 13.4922 12.908 14.6655 10.4413 14.6655H5.24131C5.08131 14.6655 4.92131 14.6522 4.76798 14.6322C2.64798 14.4922 1.51464 13.3588 1.37464 11.2388C1.35464 11.0855 1.34131 10.9255 1.34131 10.7655V9.46549C1.34131 8.12549 2.15464 6.97216 3.31464 6.47216C3.71464 6.30549 4.14131 6.21216 4.59464 6.21216H11.1013C11.428 6.21216 11.748 6.25883 12.0413 6.34549C13.368 6.75216 14.348 7.99216 14.348 9.46549Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path><path d="M4.4735 3.6853L3.30683 6.47197C2.14683 6.97197 1.3335 8.1253 1.3335 9.4653V7.51197C1.3335 5.61864 2.68016 4.03864 4.4735 3.6853Z" stroke="#2D3443" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path><path d="M14.3457 7.51185V9.46519C14.3457 7.99852 13.3724 6.75185 12.0391 6.35185C12.3857 5.48519 12.4857 4.80519 12.3191 4.23852C12.3057 4.17852 12.2857 4.11852 12.2591 4.06519C13.4991 4.70519 14.3457 6.01852 14.3457 7.51185Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path></svg>

                                </div>

                            </div>

                            <div class="ref_value"><?= '$' . number_format((activeReferrals($user_id, $conn) * 5), 2) ?></div>

                        </div>

                    </div>

                    <div class="table_con" id="table-2">

                        <table>

                            <thead>

                                <tr>

                                    <th>Fullname</th>

                                    <th>Registration Date</th>

                                    <th>Amount Earned</th>
            
                                </tr>

                            </thead>

                            <tbody>

                                <?php

                                    // Fetch Referrals

                                    $found = false; // Flag
                                
                                    $stmt = mysqli_prepare($conn, "SELECT * FROM `referrals` AS `A` JOIN `users` AS `B` ON `B`.`user_id` = `A`.`referred` WHERE `A`.`referrer` = ?"); // Prepare Statement

                                    mysqli_stmt_bind_param($stmt, "s", $user_id); // Bind Parameter(s)

                                    mysqli_stmt_execute($stmt); // Execute Statement

                                    $result = mysqli_stmt_get_result($stmt); // Get Statement Result

                                    if (mysqli_num_rows($result) > 0) { // Get Result Mass

                                        $found = true; // Update Flag

                                        $data = mysqli_fetch_all($result, MYSQLI_ASSOC);

                                    }

                                    mysqli_free_result($result); // Free Result

                                    mysqli_stmt_close($stmt); // Close Statement

                                    if ($found) {

                                        foreach ($data as $row):

                                            $name = join(' ', [$row['fname'], $row['lname']]);

                                            $email = $row['email'];

                                            $registered = $row['reg_date']; ?>

                                            <tr class="iQ_tRow">

                                                <td translate="no"><?= $name ?></td>

                                                <td><?= date('l M d, Y', strtotime($registered)) ?></td>

                                                <td><span translate="no">$</span>5.00</span></td>

                                            </tr>

                                        <?php endforeach;

                                    } else {

                                        emptyTable('You have no referral yet', '<svg width="71" height="72" viewBox="0 0 71 72" fill="none" xmlns="http://www.w3.org/2000/svg"><path opacity="0.4" d="M26.625 6.41667C18.8742 6.41667 12.5729 12.7179 12.5729 20.4688C12.5729 28.0717 18.5192 34.225 26.27 34.4913C26.5067 34.4617 26.7433 34.4617 26.9208 34.4913C26.98 34.4913 27.0096 34.4913 27.0687 34.4913C27.0983 34.4913 27.0983 34.4913 27.1279 34.4913C34.7012 34.225 40.6475 28.0717 40.6771 20.4688C40.6771 12.7179 34.3758 6.41667 26.625 6.41667Z" fill="currentColor"></path><path d="M41.6533 42.3604C33.3996 36.8579 19.9392 36.8579 11.6263 42.3604C7.86917 44.875 5.79834 48.2771 5.79834 51.9158C5.79834 55.5546 7.86917 58.9271 11.5967 61.4121C15.7383 64.1929 21.1817 65.5833 26.625 65.5833C32.0683 65.5833 37.5117 64.1929 41.6533 61.4121C45.3808 58.8975 47.4517 55.525 47.4517 51.8567C47.4221 48.2179 45.3808 44.8454 41.6533 42.3604Z" fill="currentColor"></path><path opacity="0.4" d="M59.1371 22.2142C59.6104 27.9533 55.5279 32.9825 49.8775 33.6629C49.8479 33.6629 49.8479 33.6629 49.8183 33.6629H49.7296C49.5521 33.6629 49.3746 33.6629 49.2266 33.7221C46.3571 33.87 43.7241 32.9529 41.7421 31.2667C44.7891 28.545 46.5346 24.4625 46.1796 20.025C45.9725 17.6287 45.1442 15.4396 43.9017 13.5758C45.0258 13.0137 46.3275 12.6587 47.6587 12.5404C53.4571 12.0375 58.6342 16.3567 59.1371 22.2142Z" fill="currentColor"></path><path d="M65.0538 49.5788C64.8171 52.4483 62.9829 54.9333 59.9063 56.6196C56.9479 58.2467 53.2204 59.0158 49.5225 58.9271C51.6525 57.0042 52.895 54.6079 53.1317 52.0638C53.4275 48.3954 51.6821 44.875 48.1913 42.0646C46.2092 40.4967 43.9017 39.2542 41.3871 38.3371C47.925 36.4438 56.1492 37.7158 61.2079 41.7983C63.9296 43.9875 65.32 46.7388 65.0538 49.5788Z" fill="currentColor"></path></svg>');

                                    }
                                   
                                ?>

                            </tbody>

                        </table>

                        <div class="table_nav<?= isset($found) && $found == true ? '' : ' n_displ' ?>">

                            <button class="prevPage" disabled>

                                <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M6.37999 3.95333L2.33333 8L6.37999 12.0467" stroke="#2D3443" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path><path d="M13.6667 8H2.44667" stroke="#2D3443" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path></svg>
                                
                                <span>Prev</span>
                        
                            </button>

                            <button class="nextPage" disabled>
                                
                                <span>Next</span>

                                <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M9.62 3.95334L13.6667 8.00001L9.62 12.0467" stroke="#2D3443" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path><path d="M2.33331 8H13.5533" stroke="#2D3443" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path></svg>
                        
                            </button>

                        </div>

                    </div>

                </div>

            </div>

        </div>

    </div>

    </div>

</section>

<!-- MODAL: Upload Avatar -->

<div class="popup_window n_displ" role="dialog">

    <div id="iQ_Avatar" class="popup_con n_displ">

        <div class="popup_box noScrollBar">

            <div class="popupBox_header">

                <p>Personalization</p>

                <div class="radial_icon iQ_terminator">

                    <svg width="15" height="15" viewBox="0 0 19 19" fill="none" xmlns="http://www.w3.org/2000/svg" class="close-icon"><path d="M5.80032 5.79883L13.1229 13.1214" stroke="white" stroke-width="1.68132" stroke-linecap="round" stroke-linejoin="round"></path><path d="M5.79958 13.1214L13.1222 5.79883" stroke="white" stroke-width="1.68132" stroke-linecap="round" stroke-linejoin="round"></path></svg>

                </div>

            </div>

            <div class="modal_box">

                <form method="post" id="pfpForm" enctype="multipart/form-data">

                    <div class="form_item" style="justify-content: center; user-select: none;">

                        <div id="proof-displ" class="img-displ">

                            <img src="<?= !is_null($userData['profile-image']) ? '../' . str_replace('../', '', $userData['profile-image']) : null ?>" alt="">

                        </div>

                    </div>

                    <div class="form_item">

                        <label for="avatar">Upload Photo</label>

                        <input type="hidden" name="current-avatar" value="<?= $userData['profile-image'] ?>">

                        <input name="avatar" type="file" accept="image/png, image/jpeg, image/jpg, image/webp, image/svg+xml" class="form_field" id="proof-file" required>

                        <i class="font-sm">File type: jpg, jpeg, png, webp. Max size: 350KB</i>

                    </div>

                    <div class="form_item formBtn_con">

                        <button name="update_avatar" id="setPfp" class="form_btn" type="submit">Proceed</button>
                        
                    </div>

                </form>

            </div>

        </div>

    </div>

</div>

<!-- MODAL: Edit Username -->

<div class="popup_window n_displ" role="dialog">

    <div id="iQ_id" class="popup_con n_displ">

        <div class="popup_box noScrollBar float_up">

            <div class="popupBox_header">

                <p>Edit <?= SITE_NAME ?> Tag</p>

                <div class="radial_icon iQ_terminator" style="margin-left: auto; cursor: pointer; background-color: var(--pg-invert);">

                    <svg width="15" height="15" viewBox="0 0 19 19" fill="none" xmlns="http://www.w3.org/2000/svg" class="close-icon"><path d="M5.80032 5.79883L13.1229 13.1214" stroke="white" stroke-width="1.68132" stroke-linecap="round" stroke-linejoin="round"></path><path d="M5.79958 13.1214L13.1222 5.79883" stroke="white" stroke-width="1.68132" stroke-linecap="round" stroke-linejoin="round"></path></svg>

                </div>

            </div>

            <div class="modal_box">

                <form id="edit-tag-form" method="post">

                    <div class="form_item">

                        <label for="new-tag">Enter New Username</label>

                        <input name="new-tag" placeholder="Your Unique Identifier" class="form_field" required>

                    </div>

                    <div class="form_item db">


                        <div class="form_item formBtn_con">

                            <button name="edit-tag" id="edit-tag" class="form_btn" type="submit">Done</button>

                        </div>

                    </div>

                </form>

            </div>

        </div>

    </div>

</div>
       
<?php

    require('../partials/footer.php');

?>            