<?php

require('../partials/header.php');

?>

<section id="tickets">

    <div class="dash_banner">

        <div class="dashBanner_header">

            <div class="dhb_Bitem">

                <h4 class="dashBanner_title">Support Tickets</h4>

            </div>

            <div class="dhb_Bitem btn_con">

                <button class="pg_btn variantMichb" iQ-target="#newTicket">

                    <span>Create New Ticket</span>

                    <div class="pgBtn_icon">

                        <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M2 8H14" stroke="white" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                            <path d="M8 14V2" stroke="white" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                        </svg>

                    </div>

                </button>

            </div>

        </div>

        <?php

        $tickets = false; // Flag

        // Fetch Tickets

        $stmt = mysqli_prepare($conn, "SELECT `A`.*, `B`.`created_at` AS `message_time`, `B`.`message_text` AS `last_message`, `B`.`sender` AS `party` FROM `support_tickets` AS `A` LEFT JOIN (SELECT `ticket_id`, `created_at`, `message_text`, `sender` FROM `messages` WHERE (`ticket_id`, `created_at`) IN (SELECT `ticket_id`, MAX(`created_at`) FROM `messages` GROUP BY `ticket_id`)) AS `B` ON `A`.`ticket_id` = `B`.`ticket_id` WHERE `A`.`user_id` = ? ORDER BY `B`.`created_at` DESC"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "s", $currentUser); // Bind Parameter(s)

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt); // Get Results

        if (mysqli_num_rows($result) > 0) { // Compare Result Mass

            $tickets = true; // Update Flag

            $data = mysqli_fetch_all($result, MYSQLI_ASSOC); // Get Result Data

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($stmt); // Close Statement

        // Check Flag

        if ($tickets) { ?>

            <div class="dashBanner_con grid">

                <?php

                foreach ($data as $row):

                    $id = $row['ticket_id'];

                    $title = $row['title'] ?? $id;

                    $created = date('M d, Y', strtotime($row['created_at']));

                    $msg = $row['last_message'];

                    if (strlen($msg) > 20) {

                        $msg = trim(substr($msg, 0, 20)) . '...';
                    }

                    $party = $row['party'];

                    if ($party == $currentUser) {

                        $party = 'You';
                    }

                    $time = date('M d, Y (h:i a)', strtotime($row['message_time']));

                    $status = $row['status']; 

                    $label = '<sup class="label v2">' . $status .'</sup>';
                    
                    if ($status == 'OPEN') {

                        $label = '<sup class="label v2 green">' . $status .'</sup>';

                    } else if ($status == 'CLOSED') {
                        
                        $label = '<sup class="label v2 red">' . $status .'</sup>';

                    } else if ($status == 'ON HOLD') {

                        $label = '<sup class="label v2 orange">' . $status .'</sup>';

                    } 
                    
                    $title = (strlen($title) > 25) ? substr($title, 0, 25) . '...' : $title; ?>

                    <div class="dashBanner_item min chat-record pos-rel" iQ-target="#iQ_chat">

                        <div class="ticket-data">

                            <input type="hidden" value="<?= $id ?>">

                            <button name="delete-ticket" class="pos-abs top-right">

                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 shrink-0"><path fill-rule="evenodd" clip-rule="evenodd" d="M10.5555 4C10.099 4 9.70052 4.30906 9.58693 4.75114L9.29382 5.8919H14.715L14.4219 4.75114C14.3083 4.30906 13.9098 4 13.4533 4H10.5555ZM16.7799 5.8919L16.3589 4.25342C16.0182 2.92719 14.8226 2 13.4533 2H10.5555C9.18616 2 7.99062 2.92719 7.64985 4.25342L7.22886 5.8919H4C3.44772 5.8919 3 6.33961 3 6.8919C3 7.44418 3.44772 7.8919 4 7.8919H4.10069L5.31544 19.3172C5.47763 20.8427 6.76455 22 8.29863 22H15.7014C17.2354 22 18.5224 20.8427 18.6846 19.3172L19.8993 7.8919H20C20.5523 7.8919 21 7.44418 21 6.8919C21 6.33961 20.5523 5.8919 20 5.8919H16.7799ZM17.888 7.8919H6.11196L7.30423 19.1057C7.3583 19.6142 7.78727 20 8.29863 20H15.7014C16.2127 20 16.6417 19.6142 16.6958 19.1057L17.888 7.8919ZM10 10C10.5523 10 11 10.4477 11 11V16C11 16.5523 10.5523 17 10 17C9.44772 17 9 16.5523 9 16V11C9 10.4477 9.44772 10 10 10ZM14 10C14.5523 10 15 10.4477 15 11V16C15 16.5523 14.5523 17 14 17C13.4477 17 13 16.5523 13 16V11C13 10.4477 13.4477 10 14 10Z" fill="currentColor"></path></svg>

                            </button>

                        </div>

                        <a>

                            <input type="hidden" name="chat-id" value="<?= $id ?>">

                            <div class="txbox">

                                <p class="txTitle"><?= $title ?> <?= $label ?></p>

                                <p><?= $created ?></p>

                                <!-- <p><?= $status ?></p> -->

                                <!-- <p>2 days ago</p> -->

                                <p class="desc"><?= $party . ': ' . $msg ?></p>

                                <p><?= $time ?></p>

                            </div>

                        </a>

                    </div>

                <?php endforeach;

                ?>

            </div>

        <?php } else { ?>

            <div class="unavailable flx col">

                <div class="icon">

                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="icon-lg shrink-0">
                        <path d="M13 12C13 11.4477 12.5523 11 12 11C11.4477 11 11 11.4477 11 12V16C11 16.5523 11.4477 17 12 17C12.5523 17 13 16.5523 13 16V12Z" fill="currentColor"></path>
                        <path d="M12 9.5C12.6904 9.5 13.25 8.94036 13.25 8.25C13.25 7.55964 12.6904 7 12 7C11.3096 7 10.75 7.55964 10.75 8.25C10.75 8.94036 11.3096 9.5 12 9.5Z" fill="currentColor"></path>
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M12 2C6.47715 2 2 6.47715 2 12C2 17.5228 6.47715 22 12 22C17.5228 22 22 17.5228 22 12C22 6.47715 17.5228 2 12 2ZM4 12C4 7.58172 7.58172 4 12 4C16.4183 4 20 7.58172 20 12C20 16.4183 16.4183 20 12 20C7.58172 20 4 16.4183 4 12Z" fill="currentColor"></path>
                    </svg>

                </div>

                <p>Have a question? Need to resolve an issue?.</p>

                <button class="popup-btn" iQ-target="#newTicket">Create Ticket</button>

            </div>

        <?php }

        ?>

    </div>

</section>

<!-- Popup: Create Support Ticket -->

<div class="popup_window n_displ" role="dialog">

    <div id="newTicket" class="popup_con n_displ">

        <div class="popup_box noScrollBar float_up">

            <div class="popupBox_header">

                <p>Create Ticket</p>

                <div class="radial_icon iQ_terminator">

                    <svg width="15" height="15" viewBox="0 0 19 19" fill="none" xmlns="http://www.w3.org/2000/svg" class="close-icon">
                        <path d="M5.80032 5.79883L13.1229 13.1214" stroke="var(--pg-svg)" stroke-width="1.68132" stroke-linecap="round" stroke-linejoin="round"></path>
                        <path d="M5.79958 13.1214L13.1222 5.79883" stroke="var(--pg-svg)" stroke-width="1.68132" stroke-linecap="round" stroke-linejoin="round"></path>
                    </svg>

                </div>

            </div>

            <div class="modal_box">

                <form id="ticketForm" method="post">

                    <div class="form_item">

                        <label for="title">Title</label>

                        <input name="title" type="text" class="form_field" placeholder="What's this about?">

                    </div>

                    <div class="form_item">

                        <label for="priority">Priorty</label>

                        <select name="priority" class="form_field">

                            <option>...</option>

                            <option>High</option>

                            <option>Normal</option>

                            <option>Low</option>

                        </select>

                    </div>

                    <div class="form_item">

                        <label for="msg">Message</label>

                        <textarea name="msg" class="form_field" rows="7" placeholder="..." required></textarea>

                    </div>

                    <div class="form_item">

                        <button type="submit" name="create-ticket" id="create-ticket" class="form_btn">Proceed</button>

                    </div>

                </form>

            </div>

        </div>

    </div>

</div>

<!-- Modal: Chat Messenger -->

<div class="popup_window n_displ" role="dialog">

    <div id="iQ_chat" class="popup_con n_displ">

        <div class="popup_box">

            <div class="popupBox_header">

                <p style="font-size: 1.2rem;" class="b">Chat</p>

                <div class="radial_icon iQ_terminator">

                    <svg width="15" height="15" viewBox="0 0 19 19" fill="none" xmlns="http://www.w3.org/2000/svg" class="close-icon">
                        <path d="M5.80032 5.79883L13.1229 13.1214" stroke="var(--pg-svg)" stroke-width="1.68132" stroke-linecap="round" stroke-linejoin="round"></path>
                        <path d="M5.79958 13.1214L13.1222 5.79883" stroke="var(--pg-svg)" stroke-width="1.68132" stroke-linecap="round" stroke-linejoin="round"></path>
                    </svg>

                </div>

            </div>

            <div class="modal_box" style="padding-bottom: 4em;">

                <div id="chat-window"></div>

            </div>

        </div>

    </div>

</div>

<?php

require('../partials/footer.php');

?>