<?php

    require('../partials/service-header.php');

    if (isset($_SESSION['TRANSF-ID'])) {

        echo '<script>
        
            window.location.href = "transaction-success";
        
        </script>';

        exit;

    }

    // Check User's KYC

    if ($userType === 'USER') {

        $kycState = $userData['kyc-status'] ?? 'UNVERIFIED';

        if ($kycState == 'UNVERIFIED' || $kycState == 'REJECTED') {

            echo '<script>
            
                popup({
                
                    header: "KYC Required!",

                    title: "Transfer Disabled!",

                    text: "Transfers are disabled at the moment, in order to enable transfers you\'ll have to complete the KYC verification. Would you like to proceed to KYC verification?",

                    showConfirmBtn: true,

                    type: "warning"

                }).then((confirmed) => {
                
                    if (confirmed) {

                        window.location.href = "kyc"
                    
                    } else {
                    
                        window.history.back(-1);
                        
                    }
                
                });
            
            </script>';

        } else if ($kycState == 'PROCESSING') {

            echo '<script>
            
                popup({
                
                    header: "KYC Required!",

                    title: "Transfer Disabled!",

                    text: "Transfers are disabled at the moment, as your KYC is still under verification",

                    type: "info"

                }).then(() => {
                
                    window.history.back(-1);
                        
                });
            
            </script>';

        }

    }

?>

<div class="viewBox max">

    <div class="vbox_item">

        <div class="flx col">

            <p class="special_title">Send money to <?= SITE_NAME ?> user</p>

            <p style="font-size: 0.8rem;">Enter user email or <?= SITE_NAME ?> tag.</p>

        </div>    

    </div>

    <div class="vbox_item">

        <div class="form_con">

            <form method="post" id="tagForm" autocomplete="off">
                
                <div class="form_item">

                    <label for="tag">Amount</label>

                    <input type="number" step="0.01" name="amount" class="form_field" required aria-autocomplete="none">

                </div>

                <div class="form_item">

                    <label for="tag">Enter Identifier</label>

                    <div class="form_field pseudoField">

                        <div class="icon text">@</div>

                        <input type="text" id="tag" name="tag" class="form_field" placeholder="Username, Email Address" required aria-autocomplete="none">

                    </div>

                </div>

                <div id="tagResult"></div>

                
                <div class="form_item">

                    <button type="submit" name="transfer" class="form_btn" id="tagBtn" disabled>Proceed &rarr;</button>

                </div>

            </form>

        </div>

    </div>

</div>

<?php

    require('../partials/service-footer.php');

?>