<?php

    require('../partials/service-header.php');

    // Check For ID

    if (!isset($_SESSION['TRANSF-ID'])) {

        // Redirect

        echo '<script>
        
            window.location.href = "home";
        
        </script>';

        exit;

    }

    $id = filter_var($_SESSION['TRANSF-ID'], FILTER_SANITIZE_SPECIAL_CHARS);

    // Get Transaction Details
    
    $valid = false; // Flag

    $trans = mysqli_prepare($conn, "SELECT * FROM `transactions` WHERE `trans_id` = ?"); // Prepare Statement

    mysqli_stmt_bind_param($trans, "s", $id); // Bind Parameter(s)

    mysqli_stmt_execute($trans); // Execute Statement

    $result = mysqli_stmt_get_result($trans); // Get Statement Result

    if (mysqli_num_rows($result) === 1) {

        $valid = true; // Update Flag

        while ($row = mysqli_fetch_assoc($result)) {

            $status = $row['status'];
            
            $date = date('l jS, F, Y H:i', strtotime($row['date']));

            $currency = $row['currency'];

            $symbol = $currSymbol[$currency];

            $amount = number_format($row['amount'], 2);

            $source = $row['acc_num'];

            $dest = $row['recpt_acc'];

            $recipient = $row['recpt_name'];

            $type = $row['type'];

            $scope = $row['action'];

            $bank = $row['recpt_bank'];

            $code = $row['banking_code'];

            $codeType = $row['banking_codetype'];

            $desc = $row['descr'] == null ? '-' : $row['descr'];

            $ref = $row['trans_id'];

        }

    }

    mysqli_free_result($result); // Free Result

    mysqli_stmt_close($trans);

    // Check Flag

    if (!$valid) {

        // Redirect

        echo '<script>
            
            window.location.href = "home";
        
        </script>';

        exit;

    }

    $extraScripts = <<<HTML
    
        <!-- HTML2PDF -->

        <script src="../resources/html-PDF/html2pdf.bundle.min.js"></script>
    
    HTML;
    
?>

<div class="viewBox max">

    <?php
    
       

    ?>

    <div class="vbox_item">

        <div class="flx col">

            <p class="special_title">Transaction Successful</p>

            <p style="font-size: 0.8rem;">Awaiting Verification.</p>

            <div class="flx">

                <button type="button" id="iQ_print" class="popup-btn">Print</button>

                <button type="button" id="iQ_pdf" class="popup-btn">PDF</button>

            </div>

        </div>    

    </div>

    <?php
    
        if ($valid) { ?>

            <div class="vbox_item">

                <div id="page">

                    <div class="receipt">

                        <div class="receipt_header">

                            <div class="logo">

                                <img src="<?= SITE_LOGO ?>" alt="<?= SITE_NAME ?>">

                            </div>

                            <p class="title">Transaction Summary</p>

                            <p class="title">Status: <?= $status ?></p>

                        </div>

                        <div class="receipt_main">

                            <div class="receipt_box">

                                <div class="receipt_item">

                                    <p class="title">Date/Time</p>

                                    <p class="desc"><?= $date ?></p>

                                </div>

                                <div class="receipt_item">

                                    <p class="title">Scope / Type</p>

                                    <p class="desc"><?= $scope . ' (' . $type . ')' ?></p>

                                </div>

                            </div>

                            <div class="receipt_box">

                                <div class="receipt_item">

                                    <p class="title">Sender</p>

                                    <p class="desc"><?= join(' ', [$userData['firstname'], $userData['middlename'], $userData['lastname']]) ?></p>

                                </div>

                                <div class="receipt_item">

                                    <p class="title">Description</p>

                                    <p class="desc"><?= $desc ?></p>

                                </div>

                            </div>

                            <div class="receipt_box">

                                <div class="receipt_item">

                                    <p class="title">Sender Account</p>

                                    <p class="desc"><?= $source ?></p>

                                </div>

                                <div class="receipt_item">

                                    <p class="title">Destination</p>

                                    <p class="desc"><?= $dest ?></p>

                                </div>

                            </div>

                            <?php

                                if ($scope == 'CROSS-BORDER TRANSFER') { ?>

                                <div class="receipt_box">

                                    <div class="receipt_item">

                                        <p class="title">Code Type</p>

                                        <p class="desc"><?= $codeType ?></p>

                                    </div>

                                    <div class="receipt_item">

                                        <p class="title">Code</p>

                                        <p class="desc"><?= $code ?></p>

                                    </div>

                                </div>


                                <?php

                                } 
                                
                            ?>

                            <div class="receipt_box">

                                <div class="receipt_item">

                                    <p class="title">Amount</p>

                                    <p class="desc"><?= $symbol . $amount . $currency ?></p>

                                </div>

                                <div class="receipt_item">

                                    <p class="title">Recipient</p>

                                    <p class="desc"><?= $recipient ?></p>

                                </div>

                            </div>

                            <div class="receipt_box">

                                <div class="receipt_item">

                                    <p class="title">Recipient Bank</p>

                                    <p class="desc"><?= $bank ?></p>

                                </div>

                                <div class="receipt_item">

                                    <p class="title">Reference Code</p>

                                    <p class="desc" variant="special"><?= $ref ?></p>

                                </div>

                            </div>

                        </div>

                        <div class="receipt_footer">

                            <?php
                            
                                if ($scope == 'CROSS-BORDER TRANSFER') {

                                    echo '<p style="margin-bottom: 1em;">Cross-border transfers may take up 5-8 business days.</p>';

                                }
                            
                            ?>

                            <p>Did you know that you can manage your payments online? Make an extra payment, pay off your loan, or change your due date right from your account. Simply log in to your account or contact us for additional support.</p>

                        </div>

                    </div>

                </div>    

            </div>

       <?php }

    ?>

    <div class="vbox_item">

        <div class="flx">

            <a href="home">Go to Dashboard</a>

        </div>

    </div>

</div>

<!-- Transfer Popup -->

<?php

    require('../partials/service-footer.php');

?>