<?php

    require('../partials/service-header.php');

    if (isset($_SESSION['TRANSF-ID'])) {

        echo '<script>
        
            window.location.href = "transaction-success";
        
        </script>';

        exit;

    }

    // Check User's KYC

    if ($userType === 'USER') {

        $kycState = $userData['kyc-status'] ?? 'UNVERIFIED';

        if ($kycState == 'UNVERIFIED' || $kycState == 'REJECTED') {

            echo '<script>
            
                popup({
                
                    header: "KYC Required!",

                    title: "Transfer Disabled!",

                    text: "Transfers are disabled at the moment, in order to enable transfers you\'ll have to complete the KYC verification. Would you like to proceed to KYC verification?",

                    showConfirmBtn: true,

                    type: "warning"

                }).then((confirmed) => {
                
                    if (confirmed) {

                        window.location.href = "kyc"
                    
                    } else {
                    
                        window.history.back(-1);
                        
                    }
                
                });
            
            </script>';

        } else if ($kycState == 'PROCESSING') {

            echo '<script>
            
                popup({
                
                    header: "KYC Required!",

                    title: "Transfer Disabled!",

                    text: "Transfers are disabled at the moment, as your KYC is still under verification",

                    type: "info"

                }).then(() => {
                
                    window.history.back(-1);
                        
                });
            
            </script>';

        }

    }

    $beneficiary = false; // Beneficiary Flag

    if (isset($_REQUEST['beneficiary'])) {

        $id = filter_var($_REQUEST['beneficiary'], FILTER_SANITIZE_SPECIAL_CHARS);

        // Search For Beneficiary

        $saved = mysqli_prepare($conn, "SELECT * FROM `beneficiaries` WHERE `user_id` = ? AND `id` = ?"); // Prepare Statement

        mysqli_stmt_bind_param($saved, "ss", $user_id, $id); // Bind Statement Parameter(s)

        mysqli_stmt_execute($saved); // Execute Statement

        $result = mysqli_stmt_get_result($saved); // Get Statement Result

        if (mysqli_num_rows($result) === 1) {
            
            $beneficiary = true; // Update Beneficiary Flag

            while ($row = mysqli_fetch_assoc($result)) {

                $name = $row['name'];

                $account = $row['account'];

                $currency = $row['currency'];

                $bank = $row['bank'];

            }

        }

        mysqli_free_result($result);

        mysqli_stmt_close($saved);

    }

    $userAccounts = userAccounts($user_id, $conn); // Get User Accounts

    if ($userType === 'THIRD PARTY') { // Fetch Third Party Data

        $thirdParty = thirdPartyData($currentUser, $conn); // Get Third Party Data

        if (!$thirdParty) { // Invalid Third Party

            // Log Out

            $_SESSION = [];

            session_destroy(); // Terminate Session(s)

            echo '<script>
            
                window.location.href = "../auth/";
            
            </script>';

            exit; // End Run

        }

        $barred = $thirdParty['no-access']; // Get Barred Accounts

        if (!is_null($barred)) {

            $barredList = array_map('trim', explode(',', $barred)); // Convert to an array

            $userAccounts = array_filter($userAccounts, fn($a) => !in_array($a['currency'], $barredList)); // Update User Accounts

            $userAccounts = array_values($userAccounts); // Reset To Zero-based Indexing

        }

    }
    
?>

<div class="viewBox max">

    <div class="vbox_item">

        <div class="flx col">

            <p class="special_title">Local transfer</p>

            <p style="font-size: 0.8rem;">Fill in valid details for transfer.</p>

        </div>    

    </div>

    <div class="vbox_item">

        <div class="form_con">

            <form method="post" id="transferForm" autocomplete="off">

                <div class="form_item">

                    <label for="name">Recipient's Name</label>
                    
                    <input type="text" name="name" class="form_field" placeholder="Account Holder" value="<?= isset($name) ? $name : '' ?>" required autofocus>

                </div>

                <div class="form_item db">

                    <div class="form_item">

                        <label for="account">Recipient's Account</label>

                        <input type="number" name="account" class="form_field" placeholder="Account Number" value="<?= isset($account) ? $account : '' ?>" required>

                    </div>

                    <div class="form_item">

                        <label for="bank">Recipient's Bank</label>

                        <input type="text" name="bank" class="form_field" placeholder="Bank" value="<?= isset($bank) ?$bank : '' ?>" required>

                    </div>

                </div>

                <div class="form_item db">

                    <div class="form_item">

                        <label for="source">Source Account</label>

                        <select name="source" class="form_field" required>

                            <option value="0">Select Account</option>

                            <?php

                                if ($userAccounts) {

                                    // Iterate Through Accounts

                                    foreach ($userAccounts as $row) { ?>

                                        <option data-acc="<?= $row['acc_num'] ?>" data-symbol="<?= $currSymbol[$row['currency']] ?>" data-currency="<?= $row['currency'] ?>" value="<?= $row['acc_id'] ?>"<?= isset($currency) && ($currency == $row['currency']) ? ' selected' : '' ?>><?= $row['currency'] . ' ' . substr($row['acc_num'], 0, 2) . '*** ' . $currSymbol[$row['currency']] . number_format($row['balance'], 2) ?></option>

                                    <?php }

                                }

                            ?>

                        </select>

                    </div>

                    <div class="form_item">

                        <label for="amount">Amount</label>

                        <input type="number" step="0.01" name="amount" class="form_field" placeholder="Amount" required>

                    </div>

                </div>

                <div class="form_item">

                    <label for="desc">Description</label>

                    <input type="text" name="desc" class="form_field" placeholder="Description">

                </div>

                <div class="form_item">

                    <button type="submit" name="transfer" class="form_btn">Proceed &rarr;</button>

                </div>

            </form>

        </div>

    </div>

</div>

<!-- Transfer Popup -->

<div class="popup_window n_displ" role="dialog">

    <div id="confirmTransf" class="popup_con n_displ">

        <div class="popup_box noScrollBar">

            <div class="popupBox_header">

                <p>Confirm Transaction</p>

                <div class="radial_icon iQ_terminator">

                    <svg width="15" height="15" viewBox="0 0 19 19" fill="none" xmlns="http://www.w3.org/2000/svg" class="close-icon"><path d="M5.80032 5.79883L13.1229 13.1214" stroke="white" stroke-width="1.68132" stroke-linecap="round" stroke-linejoin="round"></path><path d="M5.79958 13.1214L13.1222 5.79883" stroke="white" stroke-width="1.68132" stroke-linecap="round" stroke-linejoin="round"></path></svg>

                </div>

            </div>

            <div class="modal_box">

                <div id="transfHold"></div>

                <div>

                    <?php

                        if ($userType != 'THIRD PARTY' && !$beneficiary) { ?>

                            <div class="form_item checkbox">

                                <input type="checkbox" id="saveBeneficiary"> <span>Save as beneficiary</span>

                            </div>

                        <?php }    

                    ?>

                    <div class="form_item">

                        <button class="form_btn" id="validateTransf">Proceed &rarr;</button>

                    </div>

                </div>

            </div>

        </div>

    </div>

</div>

<?php

    require('../partials/service-footer.php');

?>