<?php

    session_name('USERSESSID');

    session_start();

    require('controls/config/config.php');

    if (isset($_REQUEST['code'])) {

        $errorCode = (int)$_REQUEST['code'];
    
    } else {

        $errorCode = isset($_SESSION['HTTP-ERROR']) ? $_SESSION['HTTP-ERROR'] : 404;

    }
        
    unset($_SESSION['HTTP-ERROR']);

    $errorTitle = [

        400 => 'Bad Request',
        401 => 'Unauthorized',
        403 => 'Forbidden',
        404 => 'Not Found',
        500 => 'Internal Server Error',
        502 => 'Bad Gateway',
        503 => 'Service Unavailable',
        504 => 'Gateway Timeout',

    ];

    $errorMsg = [

        400 => 'The server could not understand the request due to invalid syntax.',
        401 => 'The client must authenticate itself to get the requested response.',
        403 => 'The client does not have access rights to the content.',
        404 => 'The server can not find the requested resource.',
        500 => 'The server has encountered a situation it doesn’t know how to handle.',
        502 => 'The server, while acting as a gateway or proxy, received an invalid response from the upstream server.',
        503 => 'The server is not ready to handle the request.',
        504 => 'The server, while acting as a gateway or proxy, did not receive a timely response from the upstream server.',

    ];

?>

<!DOCTYPE html>

<html lang="en" dir="ltr">

<head>

    <meta charset="UTF-8">

    <meta http-equiv="X-UA-compatible" content="ie=edge">

    <link rel="icon" href="<?= $siteIcon ?>">

    <meta name="viewport" content="width=device-width, initial-scale=1.0, max-scale=1.0, user-scalable=no">

    <link rel="stylesheet" type="text/css" href="assets/stylesheets/core.css">

    <script>
        (function() {
            const page = document.documentElement; //|| document.body; // Ensure it's the right element to modify

            // Check system preference and localStorage immediately
            const systemPreferenceDark = window.matchMedia('(prefers-color-scheme: dark)').matches;

            // Apply theme if dark mode is preferred by the user or if stored in localStorage
            if (localStorage.pageClass === 'darkmode' || (systemPreferenceDark && localStorage.pageClass === undefined)) {
                page.classList.add('darkmode');
            }
        })();
    </script>

    <style>

        /* Page: Error */

        .error_con {

            min-height: 100vh;

            display: flex;

            flex-wrap: wrap;

            justify-content: center;

            min-width: 100vw;

            padding: 2em;

            overflow: hidden;

        }

        .error_box {

            text-align: center;

            display: flex;

            flex-direction: column;

            justify-content: center;

            align-items: center;

            min-width: 50%;


        }

        .error_box > * {

            margin: 0.5em;

        }

        .error_box h1 {

            font-size: 5rem;

            background: linear-gradient(158deg, rgb(248, 69, 0) 0%, rgb(67, 78, 220) 90%) text;

            -webkit-text-fill-color: transparent;

        }

        .error_box p {

            font-family: var(--monoFont);

            max-width: 30em;

            line-height: 1.8;

        }

        .error_box button {

            flex: 0 1 auto;

            width: 12.5em;

        }

    </style>

    <script type="text/javascript" src="assets/scripts/script.js" defer></script>

    <title>Error | <?= SITE_TITLE ?></title>

</head>

<body>

    <div class="error_con">

        <div class="error_box">

            <h1><?= htmlspecialchars($errorCode); ?></h1>

            <h3><?= htmlspecialchars($errorTitle[$errorCode]); ?></h3>

            <p><?= htmlspecialchars($errorMsg[$errorCode]); ?></p>

            <div class="form_item db">

            <div class="form_item">

                <a onclick="return(history.back(-1))" class="pg_btn variantPlain">Go Back</a>

                <a href="<?= SITE_BASE_URL ?>" class="pg_btn variantPlain">Go Home</a>

            </div>

        </div>

    </div>

    <!-- Google Translate -->
        
    <script>window.gtranslateSettings = {"default_language":"en","native_language_names":true,"detect_browser_language":true,"wrapper_selector":".gtranslate_wrapper","flag_size":16}</script>
    <script src="https://cdn.gtranslate.net/widgets/latest/popup.js" defer></script>

</body>

</html>