<?php

    require('partials/landing-header.php');

    $extraScripts = <<<HTML
    
        <script>

            // Home Page Typing Effect

            document.addEventListener("DOMContentLoaded", () => {

                let canvas = document.querySelector('#genesis-title');
                // let locale = 'The Global'; // Location Flag

                // let localeData = document.querySelector('#locale');
                // if (localeData) {
                //     locale = '<i>' + localeData.value + '\'s</i>'; // Update Location Flag
                // }

                // Content to type out
                let content = [
                    'Relvolutionized <br> Banking', 
                    'Banking Made Simple, Fast & Secure.',
                    'Fully Licensed<br> Banking.',
                    'Seamless <br> Integrated Banking Solutions.',
                    'Robust Global <br> Bank Accounts',
                    'Secure.<br> Banking Solutions.'
                ];

                let isWriting = false; // Flag to track if writing is in progress
                let typingDelay = 100; // Delay between each character while typing
                let refreshDelay = 30000; // 30 seconds before refreshing content (after typing is done)
                let scrollTriggerDelay = 3500; // 3.5 seconds before starting typing animation after scrolling into view
                let scrollTimeout; // Timeout ID for debouncing scroll events

                // Ensure the canvas exists
                if (canvas) {
                    let currentText = ''; // Store the current text with tags inserted
                    let lastText = ''; // To keep track of the last displayed content

                    // Function to handle pre-rendering HTML tags
                    function insertHtmlTags(text) {
                        let tempDiv = document.createElement('div');
                        tempDiv.innerHTML = text;
                        return tempDiv;
                    }

                    // Function to type out non-HTML characters
                    function typeNonHtmlText(text, targetElement) {
                        let i = 0; // Initialize counter for typing effect
                        let currentText = ''; // Store the current text without HTML tags

                        // Function to type out the content one character at a time
                        function write() {
                            if (i < text.length) {
                                let char = text.charAt(i);

                                // If the character is not an HTML tag, add it to currentText
                                if (char === '<') {
                                    // Skip over HTML tags entirely; they're already rendered
                                    let tag = '';
                                    while (i < text.length && text.charAt(i) !== '>') {
                                        tag += text.charAt(i);
                                        i++;
                                    }
                                    tag += '>';
                                    currentText += tag; // Add the tag to currentText
                                    targetElement.innerHTML = currentText; // Update the innerHTML
                                } else {
                                    currentText += char; // Add normal text
                                    targetElement.innerHTML = currentText; // Update the innerHTML
                                }

                                i++; // Increment the counter
                                setTimeout(write, typingDelay); // Call write() recursively every 100ms to simulate typing
                            } else {
                                // Typing completed, reset the flag and set the interval for refreshing
                                isWriting = false;
                                setTimeout(() => {
                                    refreshContent(targetElement);
                                }, refreshDelay); // Wait for 30 seconds before refreshing content
                            }
                        }

                        write(); // Start typing the non-HTML text
                    }

                    // Function to refresh the content after typing completes
                    function refreshContent(targetElement) {
                        // Pick a new random piece of text from the content array that isn't the last text
                        let newText;
                        do {
                            newText = content[Math.floor(Math.random() * content.length)];
                        } while (newText === lastText); // Ensure no repetition

                        lastText = newText; // Update the last displayed content
                        targetElement.innerHTML = ''; // Clear the element before new content starts
                        // Restart the process of rendering HTML and typing
                        startTypingAnimation(targetElement, newText);
                    }

                    // Function to start the typing animation
                    function startTypingAnimation(targetElement, text) {
                        if (isWriting) {
                            // If writing is already in progress, skip the new animation
                            return;
                        }
                        isWriting = true; // Mark as writing

                        const htmlContent = insertHtmlTags(text);
                        targetElement.innerHTML = ''; // Clear the existing content
                        targetElement.appendChild(htmlContent); // Insert HTML tags first

                        // Start typing non-HTML text
                        typeNonHtmlText(text, targetElement);
                    }

                    // Function to trigger typing animation when scrolling has stopped
                    function handleScrollStop() {
                        // Clear previous timeout to debounce scroll events
                        clearTimeout(scrollTimeout);

                        // Set a new timeout that will trigger when scroll stops
                        scrollTimeout = setTimeout(() => {
                            // Check if the element is in view after scrolling stops
                            if (canvas && !isWriting) {
                                const boundingRect = canvas.getBoundingClientRect();
                                const isInView = boundingRect.top >= 0 && boundingRect.bottom <= window.innerHeight;

                                if (isInView) {
                                    // Wait 3.5 seconds before starting the typing animation after the element enters view
                                    setTimeout(() => {
                                        // Only start the typing animation if it's not still writing
                                        if (!isWriting) {
                                            startTypingAnimation(canvas, content[Math.floor(Math.random() * content.length)]);
                                        }
                                    }, scrollTriggerDelay);
                                }
                            }
                        }, 100); // Wait 100ms after scroll stops before checking visibility
                    }

                    // Listen for the scroll event and debounce it
                    window.addEventListener('scroll', handleScrollStop);

                    // Initial check to start typing if the element is already in view
                    handleScrollStop();
                }
                
            });

        </script>

    HTML;

?>

<main>

    <!-- Hero Section -->
    <section class="hero-gradient text-white" id="top">

        <div class="pt-4">

            <!-- TradingView Widget BEGIN -->
            <div class="tradingview-widget-container">
            <div class="tradingview-widget-container__widget"></div>
            <!-- <div class="tradingview-widget-copyright"><a href="https://www.tradingview.com/" rel="noopener nofollow" target="_blank"><span class="blue-text">Ticker tape by TradingView</span></a></div> -->
            <script type="text/javascript" src="https://s3.tradingview.com/external-embedding/embed-widget-ticker-tape.js" async>
            {
            "symbols": [
                {
                "proName": "CMCMARKETS:USDEUR",
                "title": "USD/EUR"
                },
                {
                "proName": "CMCMARKETS:USDEUR",
                "title": "USD/GBP"
                },
                {
                "proName": "OANDA:USDCHF",
                "title": "USD/CHF"
                },
                {
                "proName": "CMCMARKETS:USDJPY",
                "title": "USD/JPY"
                },
                {
                "proName": "CMCMARKETS:USDCAD",
                "title": "USD/CAD"
                },
                {
                "proName": "FX_IDC:USDCNY",
                "title": "USD/CNY"
                },
                {
                "proName": "CMCMARKETS:EURUSD",
                "title": "EUR/USD"
                },
                {
                "proName": "CMCMARKETS:EURGBP",
                "title": "EUR/GBP"
                },
                {
                "proName": "OANDA:EURCHF",
                "title": "EUR/CHF"
                },
                {
                "proName": "CMCMARKETS:EURJPY",
                "title": "EUR/JPY"
                },
                {
                "proName": "CMCMARKETS:EURCAD",
                "title": "EUR/CAD"
                },
                {
                "proName": "FX_IDC:EURCNY",
                "title": "EUR/CNY"
                },
                {
                "proName": "CMCMARKETS:GBPUSD",
                "title": "GBP/USD"
                },
                {
                "proName": "CMCMARKETS:GBPEUR",
                "title": "GBP/EUR"
                },
                {
                "proName": "CMCMARKETS:GBPCHF",
                "title": "GBP/CHF"
                },
                {
                "proName": "CMCMARKETS:GBPJPY",
                "title": "GBP/JPY"
                },
                {
                "proName": "CMCMARKETS:GBPCAD",
                "title": "GBP/CAD"
                },
                {
                "proName": "FX_IDC:GBPCNY",
                "title": "GBP/CNY"
                },
                {
                "proName": "CMCMARKETS:CHFUSD",
                "title": "CHF/USD"
                },
                {
                "proName": "CMCMARKETS:CHFEUR",
                "title": "CHF/EUR"
                },
                {
                "proName": "CMCMARKETS:CHFGBP",
                "title": "CHF/GBP"
                },
                {
                "proName": "CMCMARKETS:CHFJPY",
                "title": "CHF/JPY"
                },
                {
                "proName": "CMCMARKETS:CHFCAD",
                "title": "CHF/CAD"
                },
                {
                "proName": "FX_IDC:CHFCNY",
                "title": "CHF/CNY"
                },
                {
                "proName": "FX_IDC:JPYUSD",
                "title": "JPY/USD"
                },
                {
                "proName": "SAXO:JPYEUR",
                "title": "JPY/EUR"
                },
                {
                "proName": "FX_IDC:JPYGBP",
                "title": "JPY/GBP"
                },
                {
                "proName": "FX_IDC:JPYCHF",
                "title": "JPY/CHF"
                },
                {
                "proName": "FX_IDC:JPYCAD",
                "title": "JPY/CAD"
                },
                {
                "proName": "FX_IDC:JPYCNY",
                "title": "JPY/CNY"
                },
                {
                "proName": "CMCMARKETS:CADUSD",
                "title": "CAD/USD"
                },
                {
                "proName": "CMCMARKETS:CADEUR",
                "title": "CAD/EUR"
                },
                {
                "proName": "CMCMARKETS:CADGBP",
                "title": "CAD/GBP"
                },
                {
                "proName": "CMCMARKETS:CADCHF",
                "title": "CAD/CHF"
                },
                {
                "proName": "CMCMARKETS:CADJPY",
                "title": "CAD/JPY"
                },
                {
                "proName": "FX_IDC:CADCNY",
                "title": "CAD/CNY"
                },
                {
                "proName": "FX_IDC:CNYUSD",
                "title": "CNY/USD"
                },
                {
                "proName": "FX_IDC:CNYEUR",
                "title": "CNY/EUR"
                },
                {
                "proName": "FX_IDC:CNYGBP",
                "title": "CNY/GBP"
                },
                {
                "proName": "FX_IDC:CNYCHF",
                "title": "CNY/CHF"
                },
                {
                "proName": "FX_IDC:CNYJPY",
                "title": "CNY/JPY"
                },
                {
                "proName": "FX_IDC:CNYCAD",
                "title": "CNY/CAD"
                }
            ],
            "colorTheme": "dark",
            "locale": "en",
            "largeChartUrl": "",
            "isTransparent": false,
            "showSymbolLogo": true,
            "displayMode": "regular"
            }
            </script>
            </div>
            <!-- TradingView Widget END -->

        </div>

        <div class="container mx-auto px-4 pt-12 py-20 md:py-32">
            <div class="flex flex-col md:flex-row items-center">
                <div class="md:w-1/2 mb-10 md:mb-0">
                    <h1 class="text-blue-650 text-4xl md:text-5xl lg:text-6xl font-bold mb-4" id="genesis-title">Banking Made Simple,
                        Fast
                        & Secure</h1>
                    <p class="text-md md:text-xl mb-8 text-gray-400"><span translate="no"><?= SITE_NAME ?></span> gives you complete control over your
                        finances with our cutting-edge digital banking platform.</p>
                    <div class="flex flex-col sm:flex-row space-y-4 sm:space-y-0 sm:space-x-4">
                        <a href="auth/register"
                            class="bg-blue-800 text-white hover:bg-blue-900 px-6 py-3 rounded-lg font-semibold text-lg transition">
                            Open an Account</a>
                        <a href="auth/login"
                            class="border-2 border-indigo-400 text-indigo-400 hover:bg-white hover:text-blue-600 px-6 py-3 rounded-lg font-semibold text-lg transition">Log
                            In</a>
                    </div>
                </div>
                <div class="md:w-1/2 flex justify-center">
                    <div class="relative w-full max-w-lg">
                        <div class="relative">
                            <img src="https://images.unsplash.com/photo-1554224155-6726b3ff858f?auto=format&fit=crop&w=1000&q=80"
                                alt="Banking App" class="rounded-xl shadow-2xl border-4 border-blue-900">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- <section>

        <div class="hero-gradient">

           

        </div>

    </section> -->

    <!-- Trust Indicators -->
    <div class="hero-gradient py-8">
        <div class="container mx-auto px-4">
            <div class="text-blue-650 flex flex-wrap justify-center items-center gap-8 md:gap-16">
                <div class="text-center">
                    <div class="text-3xl font-bold" data-counter="5M+">5M+</div>
                    <div class="text-gray-400">Customers</div>
                </div>
                <div class="text-center">
                    <div class="text-3xl font-bold" data-counter="80+">80+</div>
                    <div class="text-gray-400">Currencies</div>
                </div>
                <div class="text-center">
                    <div class="text-3xl font-bold" data-counter="24/7">24/7</div>
                    <div class="text-gray-400">Support</div>
                </div>
                <div class="text-center">
                    <div class="text-3xl font-bold" data-counter="256M+">256M+</div>
                    <div class="text-gray-400">Transactions</div>
                </div>
            </div>
        </div>
    </div>

    <!-- features Section -->
    <section class="py-16 hero-gradient">
        <div class="container  mx-auto px-4" id="features">
            <h2 class="text-3xl md:text-4xl font-bold text-center mb-4">Why Choose <span translate="no"><?= SITE_NAME ?></span>?</h2>
            <p class="text-xl text-gray-400 text-center max-w-2xl mx-auto mb-12">Experience banking that works for you
                with these powerful features</p>

            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                <!-- Feature 1 -->
                <div class="feature-card p-8 rounded-xl shadow-md border border-gray-700 transition duration-300">
                    <div class="w-14 h-14 bg-blue-900 rounded-lg flex items-center justify-center mb-6">
                        <i class="fas fa-bolt text-blue-400 text-2xl"></i>
                    </div>
                    <h3 class="text-xl font-bold mb-3">Instant Transfers</h3>
                    <p class="text-gray-400">Send and receive money instantly to anyone, anywhere with just a few taps.
                    </p>
                </div>

                <!-- Feature 2 -->
                <div class="feature-card p-8 rounded-xl shadow-md border border-gray-700 transition duration-300">
                    <div class="w-14 h-14 bg-blue-900 rounded-lg flex items-center justify-center mb-6">
                        <i class="fas fa-dollar text-blue-400 text-2xl"></i>
                    </div>
                    <h3 class="text-xl font-bold mb-3">Secured Multi-currency Accounts</h3>
                    <p class="text-gray-400">Your money is protected with vault-level security and 256-bit encryption.
                    </p>
                </div>

                <!-- Feature 3 -->
                <div class="feature-card p-8 rounded-xl shadow-md border border-gray-700 transition duration-300">
                    <div class="w-14 h-14 bg-blue-900 rounded-lg flex items-center justify-center mb-6">
                        <i class="fa fa-users text-blue-400 text-2xl" aria-hidden="true"></i>
                    </div>
                    <h3 class="text-xl font-bold mb-3">Joint Users</h3>
                    <p class="text-gray-400">Easily manage shared accounts with family or partners while enjoying secure
                        savings and high interest.</p>
                </div>

                <!-- Feature 4 -->
                <div class="feature-card p-8 rounded-xl shadow-md border border-gray-700 transition duration-300">
                    <div class="w-14 h-14 bg-blue-900 rounded-lg flex items-center justify-center mb-6">
                        <i class="fas fa-university text-blue-400 text-2xl"></i>
                    </div>
                    <h3 class="text-xl font-bold mb-3">Loan / Investment </h3>
                    <p class="text-gray-400">Access flexible loans and smart investment options to grow your wealth with
                        ease.
                    </p>
                </div>

                <!-- Feature 5 -->
                <div class="feature-card p-8 rounded-xl shadow-md border border-gray-700 transition duration-300">
                    <div class="w-14 h-14 bg-blue-900 rounded-lg flex items-center justify-center mb-6">
                        <i class="fa fa-microchip text-blue-400 text-2xl"></i>
                    </div>
                    <h3 class="text-xl font-bold mb-3">UETR Tracker</h3>
                    <p class="text-gray-400">Track your transfer instantly for all your international
                        transfer in real time.</p>
                </div>

                <!-- Feature 6 -->
                <div class="feature-card p-8 rounded-xl shadow-md border border-gray-700 transition duration-300">
                    <div class="w-14 h-14 bg-blue-900 rounded-lg flex items-center justify-center mb-6">
                        <i class="fas fa-headset text-blue-400 text-2xl"></i>
                    </div>
                    <h3 class="text-xl font-bold mb-3">24/7 Support</h3>
                    <p class="text-gray-400">Our customer service team is always available to help with any questions.
                    </p>
                </div>
            </div>
        </div>
    </section>

    <!-- testimonials -->
    <section class="socialproof py-16 hero-gradient" id="socialproof">
        <div class="container mx-auto px-4">
            <h2 class="text-3xl md:text-4xl font-bold text-center mb-4">Trusted by Millions</h2>
            <p class="text-xl text-gray-400 text-center max-w-2xl mx-auto mb-12">Don't just take our word for it. Here's
                what our customers say.</p>

            <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
                <!-- Testimonial 1 -->
                <div class="feature-card p-8 rounded-xl shadow-sm border border-gray-700">
                    <div class="flex items-center mb-4">
                        <div class="text-yellow-400 mr-2">
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                        </div>
                    </div>
                    <p class="text-gray-400 mb-6">"Switching to <span translate="no"><?= SITE_NAME ?></span> was the best financial decision I've made.
                        The app is so intuitive and the customer service is exceptional."</p>
                    <div class="flex items-center">
                        <div class="w-12 h-12 rounded-full bg-gray-700 mr-4 overflow-hidden">
                            <img src="https://randomuser.me/api/portraits/women/43.jpg" alt="Sarah J."
                                class="w-full h-full object-cover">
                        </div>
                        <div>
                            <h4 class="font-bold">Sarah J.</h4>
                            <p class="text-gray-500 text-sm">Small Business Owner</p>
                        </div>
                    </div>
                </div>

                <!-- Testimonial 2 -->
                <div class="feature-card p-8 rounded-xl shadow-sm border border-gray-700">
                    <div class="flex items-center mb-4">
                        <div class="text-yellow-400 mr-2">
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                        </div>
                    </div>
                    <p class="text-gray-400 mb-6">"The instant transfers have saved me so much time. I can pay my
                        employees and vendors with just a few clicks. Game changer!"</p>
                    <div class="flex items-center">
                        <div class="w-12 h-12 rounded-full bg-gray-700 mr-4 overflow-hidden">
                            <img src="https://randomuser.me/api/portraits/men/32.jpg" alt="Michael T."
                                class="w-full h-full object-cover">
                        </div>
                        <div>
                            <h4 class="font-bold">Michael T.</h4>
                            <p class="text-gray-500 text-sm">Restaurant Owner</p>
                        </div>
                    </div>
                </div>

                <!-- Testimonial 3 -->
                <div class="feature-card p-8 rounded-xl shadow-sm border border-gray-700">
                    <div class="flex items-center mb-4">
                        <div class="text-yellow-400 mr-2">
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star-half-alt"></i>
                        </div>
                    </div>
                    <p class="text-gray-400 mb-6">"As someone who travels frequently, having a reliable banking app is
                        crucial. <span translate="no"><?= SITE_NAME ?></span> works flawlessly no matter where I am."</p>
                    <div class="flex items-center">
                        <div class="w-12 h-12 rounded-full bg-gray-700 mr-4 overflow-hidden">
                            <img src="https://randomuser.me/api/portraits/women/65.jpg" alt="Jessica L."
                                class="w-full h-full object-cover">
                        </div>
                        <div>
                            <h4 class="font-bold">Jessica L.</h4>
                            <p class="text-gray-500 text-sm">Digital Nomad</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>


    <section class="py-16 text-white">
        <div class="container mx-auto px-4">
            <div class="max-w-4xl mx-auto bg-blue-800 rounded-xl p-8 md:p-12 shadow-lg">
                <div class="flex flex-col md:flex-row items-center">
                    <div class="md:w-1/2 mb-8 md:mb-0 md:pr-8">
                        <h2 class="text-3xl md:text-4xl font-bold mb-4">Ready to Get Started?</h2>
                        <p class="text-blue-200 mb-6">Join thousands of happy customers who have simplified their
                            banking with <span translate="no"><?= SITE_NAME ?></span>.</p>
                        <ul class="space-y-3">
                            <li class="flex items-center">
                                <i class="fas fa-check-circle text-green-400 mr-2"></i>
                                <span>No monthly fees</span>
                            </li>
                            <li class="flex items-center">
                                <i class="fas fa-check-circle text-green-400 mr-2"></i>
                                <span>FDIC insured up to $250,000</span>
                            </li>
                            <li class="flex items-center">
                                <i class="fas fa-check-circle text-green-400 mr-2"></i>
                                <span>Open an account in minutes</span>
                            </li>
                        </ul>
                    </div>
                    <div class="md:w-1/2 w-full">
                        <form class="bg-gray-800 rounded-lg p-6 shadow-md">
                            <h3 class="text-xl font-bold text-gray-600 mb-4">Create Your Account</h3>
                            <!-- <div class="mb-4">
                                <input type="text" placeholder="Full Name"
                                    class="w-full px-4 py-2 border border-gray-600 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 bg-gray-800 text-white">
                            </div>
                            <div class="mb-4">
                                <input type="email" placeholder="Email Address"
                                    class="w-full px-4 py-2 border border-gray-600 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 bg-gray-800 text-white">
                            </div>
                            <div class="mb-6">
                                <input type="tel" placeholder="Phone Number"
                                    class="w-full px-4 py-2 border border-gray-600 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 bg-gray-800 text-white">
                            </div> -->
                            <a href="auth/register"
                                class="block text-center w-full bg-blue-600 hover:bg-blue-700 text-white py-3 rounded-lg font-semibold transition">Get
                                Started</a>
                            <p class="text-xs text-gray-400 mt-3">By clicking "Get Started", you agree to our Terms of
                                Service and Privacy Policy.</p>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Supporting Content -->
    <section class=" py-16 bg-black-900">
        <div class="container mx-auto px-4">
            <div class="flex flex-col md:flex-row items-center">
                <div class="md:w-1/2 mb-10 md:mb-0 md:pr-10">
                    <h2 class="text-3xl md:text-4xl font-bold mb-6">Banking That Grows With You</h2>
                    <p class="text-gray-400 mb-6">At <span translate="no"><?= SITE_NAME ?></span>, we understand that your financial needs evolve over
                        time. That's why we've designed a flexible banking platform that adapts to your changing
                        circumstances.</p>
                    <p class="text-gray-400 mb-8">Whether you're just starting out, growing your business, or planning
                        for retirement, we have the tools and services to support your financial journey every step of
                        the way.</p>
                    
                    <div class="flex space-x-1">
                        <span>Learn More</span>
                        <button class="flex items-center text-blue-400 font-medium">
                            <i class="fas fa-arrow-right ml-2"></i>
                        </button>
                    </div>
                </div>
                <div class="md:w-1/2">
                    <div class="bg-gray-800 rounded-xl p-6">
                        <img src="https://images.unsplash.com/photo-1551288049-bebda4e38f71?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=1000&q=80"
                            alt="Financial Growth" class="rounded-lg shadow-md w-full">
                    </div>
                </div>
            </div>
        </div>
    </section>

</main>

<?php

    require('partials/landing-footer.php');

?>