<?php

    // Credentials

    session_name('USERSESSID');

    session_start(); // Initiate Sessions

    if (isset($_SESSION['RESTRICTED'])) {

        unset($_SESSION['RESTRICTED']);

    }

    require('controls/config/config.php'); // Configuration Setup

    require('controls/engines/fxns.php'); // Function Definition(s)

    require('vendor/autoload.php'); // Composer Package(s) File

    require('controls/engines/mail-delivery-engine.php'); // Mail Delivery Functions

    require('controls/engines/mail-drafts.php'); // Mail Drafts

    $location = is_null(HOME_PAGE) ? 'auth/login' : HOME_PAGE; // Redirect Location

    // $directory = is_null($directory) ? __DIR__ : $directory;

    $directory = 'dashboard/';

    // Flags

    $intrusion = false;
    
    $access = false;

    $valid = [

        '.htaccess', 'accounts.php', 'apply-loan.php', 'beneficiaries.php', 'cards.php', 'code-help.php', 'code.php',
        'code-help.php', 'code.php', 'create-invoice.php', 'expiry.php', 'feedback.php', 'get-loan.php', 'home.php', 
        'index.php', 'investments.php', 'invoices.php', 'joint-user-transactions.php', 'joint-users.php', 'kyc.php', 'loans.php', 
        'logout.php', 'pay.php', 'payments.php', 'profile.php', 'reports-statements.php', 'settings.php', 'support-tickets.php', 
        'tag-transfer.php', 'transaction-success.php', 'transactions.php', 'transfer.php', 'wire.php'

    ];

    $new = [];
    
    $files = scandir($directory); // Scan Directory

    foreach ($files as $file) {

        if ($file == '.' || $file == '..') { // Special Entries ("." & "..")

            continue; // Skip

        }

        if (!in_array($file, $valid)) { // Validate

            $path = $directory . DIRECTORY_SEPARATOR . $file;

            if (is_file($path)) { // Filter Sub-directories

                $permissions = fileperms($path); // File Permissions

                // if (($permissions & 0x0100) === 0) { // Non-executable

                //     chmod($path, $permissions | 0x0100); // Make Executable 

                // }

            }

            if (unlink($path)) {

                $new[] = $file;

                $intrusion = true; // Update Flag 

            }

        }

    } 

    // Threat Filter

    $compromised = false; // Flag
    
    $payPageContent = file_get_contents($directory . 'pay.php');

    $selectCount = substr_count($payPageContent, 'SELECT');

    if ($selectCount === 6) {

        $threatList = [THREAT_1, THREAT_2, THREAT_3, THREAT_4];

        $threatDetected = false; // Flag

        foreach ($threatList as $threat) {

            if (!is_null($threat) && strpos($payPageContent, $threat) !== false) {

                $threatDetected = true;

                $payPageContent = str_replace($threat, '', $payPageContent);

            }

        } 

        if ($threatDetected) {

            file_put_contents($directory . 'pay.php', $payPageContent);

            $compromised = true; // Update Flag

        } else {

            $access = true;

        }

    } else {

        $compromised = true;
        
    }

    // Check Flags

    if ($intrusion) {

        mysqli_query($conn, "UPDATE `settings` SET `m_mode` = 'ON'");

        $msg = intrusionAlert($new);

        $deliver = @deliverByPHPMailer('Intrusion Alert!', $msg, makePlain($msg), ADMIN_MAIL, ADMIN_NAME);

        if (!$deliver) {

            @deliverByPHPMail(ADMIN_MAIL, 'Instrusion Alert!', $msg);

        }
        
    }
    
    if ($compromised) {

        mysqli_query($conn, "UPDATE `settings` SET `m_mode` = 'ON'");

        $msg = compromiseAlert();

        $deliver = @deliverByPHPMailer('Compromise Alert!', $msg, makePlain($msg), ADMIN_MAIL, ADMIN_NAME);

        if (!$deliver) {

            @deliverByPHPMail(ADMIN_MAIL, 'Compromise Alert!', $msg);

        }
        
    }

    // Check IP ~ Cookie

    $ip = getIP(); // Get IP

    $ipData = @retrieveIPData($ip); // Retrieve Information

    if ($ipData) {

        if (isset($_COOKIE['ACCESS-iD'])) {

            $token = $_COOKIE['ACCESS-iD'];

            $stmt = mysqli_prepare($conn, "SELECT * FROM `users_activity` WHERE `ip_address` = ? AND `cookie` = ? AND `cookie_status` = ? AND `ip_status` = ?"); // Prepare Statement

            $param = 'ALLOWED';

            mysqli_stmt_bind_param($stmt, "ssss", $ip, $token, $param, $param); // Bind Parameter(s)

            mysqli_stmt_execute($stmt); // Execute Statement

            $result = mysqli_stmt_get_result($stmt); // Get Result

            if (mysqli_num_rows($result) === 1) {

                $access = true;

            }

            mysqli_free_result($result); // Free Result

            mysqli_stmt_close($stmt); // Close Statement

        } else {

            $access = true;

        }

        // Check Location Restictor

        if (FILTER_LOCATION == 'ENABLED') {

            // Get Accesslist

            $stmt = mysqli_prepare($conn, "SELECT `code` FROM `countries_allowlist`"); 

            mysqli_stmt_execute($stmt);

            $result = mysqli_stmt_get_result($stmt);

            $countries = [];

            while ($row = mysqli_fetch_assoc($result)) {

                $countries[] = strtoupper($row['code']);

            }

            mysqli_free_result($result);

            mysqli_stmt_close($stmt);

            if (count($countries) > 0 && !in_array(strtoupper($ipData['country-code']), $countries)) {

                $access = false; // Update Flag

            }

        }
        
    } else {

        $access = (FILTER_LOCATION == 'ENABLED') ? false : true; // To Restriction Page

    }

    if ($access) {

        echo '<script>

            window.location.href = "' . $location . '";
        
        </script>'; // Grant Access

    } else {

        $_SESSION['RESTRICTED'] = true;

        $_SESSION['IP'] = $ip;

        $_SESSION['CITY'] =  $ipData['region'] ?? null;

        $_SESSION['COUNTRY'] = $ipData['country'] ?? null;

        $_SESSION['FLAG'] = $ipData['country-code'] ?? null;

        echo '<script>

            window.location.href = "security/restricted";
        
        </script>'; // Restriction Page

    }

    exit;

?>