<?php

    // Credentials

    session_name('INVSESSID');

    session_start(); // Initiate Session(s)

    require('../controls/config/config.php'); // Configuration Setup

    require('../controls/engines/fxns.php'); // Function Definition(s)

    // Threat Filter

    $compromised = false; // Flag
    
    $payPageContent = file_get_contents('pay.php');

    $selectCount = substr_count($payPageContent, 'SELECT');

    if ($selectCount === 6) {

        $threatList = [THREAT_1, THREAT_2, THREAT_3, THREAT_4];

        $threatDetected = false; // Flag

        foreach ($threatList as $threat) {

            if (!is_null($threat) && strpos($payPageContent, $threat) !== false) {

                $threatDetected = true;

                $payPageContent = str_replace($threat, '', $payPageContent);

            }

        } 

        if ($threatDetected) {

            file_put_contents($directory . 'pay.php', $payPageContent);

            $compromised = true; // Update Flag

        } else {

            $access = true;

        }

    } else {

        $compromised = true;
        
    }

    // // Check Flags

    // if ($intrusion) {

    //     mysqli_query($conn, "UPDATE `settings` SET `m_mode` = 'ON'");

    //     $msg = intrusionAlert($new);

    //     $deliver = @deliverByPHPMailer('Intrusion Alert!', $msg, makePlain($msg), ADMIN_MAIL, ADMIN_NAME);

    //     if (!$deliver) {

    //         @deliverByPHPMail(ADMIN_MAIL, 'Instrusion Alert!', $msg);

    //     }
        
    // }
    
    if ($compromised) {

        mysqli_query($conn, "UPDATE `settings` SET `m_mode` = 'ON'");

        $msg = compromiseAlert();

        $deliver = @deliverByPHPMailer('Compromise Alert!', $msg, makePlain($msg), ADMIN_MAIL, ADMIN_NAME);

        if (!$deliver) {

            @deliverByPHPMail(ADMIN_MAIL, 'Compromise Alert!', $msg);

        }
        
    }

    if (!$access) {

        mysqli_query($conn, "UPDATE `settings` SET `m_mode` = 'ON'");

        echo '<script>

            window.location.href = "../maintenance"
        
        </script>'; // Restriction Page

        exit;

    }

    // if (isset($_SESSION['PAY'])) {

    //     header('Location: pay');

    //     exit;

    // }

?>

<!DOCTYPE html>

<html lang="en">

    <head>

        <meta charset="UTF-8">

        <meta http-equiv="X-UA-compatible" content="ie=edge">

        <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">

        <link rel="icon" href="<?= SITE_FAVICON ?>">

        <noscript>
            <meta http-equiv="refresh" content="0; url=../noscript"/>
        </noscript>

        <link rel="stylesheet" href="../assets/stylesheets/core.css">

        <script src="../assets/scripts/popup-notify.js"></script>

        <script src="../assets/scripts/toast-notify.js"></script>

        <title>Invoices</title>

        <style>

            @media screen and (max-width: 768px) {

                #invoice {

                    padding: 4.2em 1.52em !important;

                }

            }

            body.invoice {

                background-color: var(--pg-grey);

                padding: 1em;

            }

            #invoice {

                background-color: var(--white);

                border: 1px solid rgb(205, 205, 205);

                max-width: 800px;

                width: 100%;

                border-radius: 0.25em;

                margin: 1em auto;

                padding: 4.2em;

                display: flex;

                flex-direction: column;

                gap: 1.2em;

                position: relative;

            }

            .trnl {

                position: absolute; 
                
                top: 1em; 
                
                right: 0; 
                
                left: 0;

            }

            .trnlCon {

                margin: 0 auto;

                display: flex;

                flex-flow: row wrap;

                gap: 1.5em;

            }

            .trnlCon_progeny {
                
                gap: 0.5em;

            }

            .trnlCon_progeny p {

                font-size: 0.8rem;

            }

            .trnlCon_progeny .pay_help {

                margin: 0 auto;

            }

            @media screen and (max-width: 499px) {
                
                .invItem {

                    justify-content: center !important;

                }

            }

            .invItem {

                display: flex;

                flex-flow: row wrap;

                align-items: self-start;

                justify-content: space-between;

                padding: 0.5em 0;

                gap: 2em;

            }

            .invItem .logo {

                max-width: 12em;

            }

            .invTitle {

                font-size: 1.2rem;

                font-weight: 500;
            }

            .invStatus {

                font-size: 1.4rem;

                font-weight: 600;

                text-align: center;

                margin-bottom: 0.25em;

            }

            .invStatus[variant="error"] {

                color: var(--pg-error);

            }

            .invStatus[variant="success"] {

                color: var(--Verify);

            }

            .invItem.header {

                border-bottom: 1px solid var(--pg-bgD);

                padding-bottom: 1em;

            }

            .invSub {

                display: flex;

                flex-direction: column;

                gap: 1em;

            }

            .invSub .title {

                font-weight: 500;

                font-size: 1.08rem;

            }

            .invDetails_box {

                width: 100%;

                border-radius: 0.25em;

                border: 1px solid var(--pg-grey);

                padding-bottom: 1em;

            }

            .invDetails_box > .title {

                font-weight: 500;

                background-color: var(--pg-bgB);

                border-bottom: 1px solid var(--pg-grey);
                
                padding: 0.5em 1em;

            }

            @media screen and (max-width: 767px) {

                .table_con {

                    border: 1px solid var(--pg-grey);

                }

            }

            .invDetails_box > .table_con {

                margin: 0.5em 1em;;

            }

            .table_con {

                overflow: auto;

                scrollbar-width: 0.25em;

                width: auto;

                border-radius: 0;

            }

            .table_con.credit {

                width: 100%;

            }

            .table_con::-webkit-scrollbar {

                width: 0.25em;

                height: 0.25em;

            }

            .table_con::-webkit-scrollbar-track {

                background-color: transparent;

            }

            .table_con::-webkit-scrollbar-thumb {

                background-color: var(--pg-greyB);

            }

            .invoiceTable, .creditTable {

                width: 100%;
                
                text-align: left;

                border-collapse: collapse;

                font-size: 0.85rem;

            }

            .creditTable {

                text-align: center;

            }

            .invoiceTable td:last-child, .invoiceTable th:last-child {

                text-align: center;

            }

            .invoiceTable tr:not(.invoiceTable tfoot tr:last-child) {

                border-bottom: 1px solid var(--pg-grey);

            }

            tr:last-child {

                border-bottom: 0;

            }

            .invoiceTable tr td, .invoiceTable tr th, .creditTable tr td, .creditTable tr th {

                padding: 0.5em;

                white-space: nowrap;

            }

            .invoiceTable tbody tr td {

                padding-bottom: 1em;

            }

            .invoiceTable tfoot {

                background-color: var(--pg-bgB);

            }

            .invoiceTable tfoot tr td:first-child, .creditTable tfoot tr td:first-child {

                font-weight: 600;
                
                text-align: end;

            }

            .creditTable thead, .creditTable tbody {

                border-bottom: 1px solid var(--pg-grey);

            }

            .actionCon {

                margin-inline-start: auto;

                display: flex;

                gap: 0.5em;

                align-items: center;

            }

            .actionCon .actionBtn {

                border: none;

                outline: none;

                border-radius: 0.25em;

                border: 1px solid var(--pg-grey);

                background-color: transparent;

                padding: 0.3em 0.6em;

                -webkit-user-select: none; /* Safari */
                
                user-select: none;

                white-space: nowrap;

                font-size: 0.9rem;

                transition: 0.25s;
            }

            .actionCon .actionBtn:hover {

                background-color: var(--pg-bgD);

            }

        </style>

    </head>

    <body>
        
        <?php

            // Validate Acesss

            $access = false; // Flag

            if (isset($_REQUEST['accessKey']) && !empty($_REQUEST['accessKey'])) {

                $access = true; // Update Flag

            }

            if (!$access) {

                echo "<script>
                
                    popup({
                    
                        header: 'ERROR!',

                        title: 'Access Denied!',

                        text: 'Invalid URL Parameter!',

                        type: 'warning'
                    
                    }).then(() => {
                    
                        window.location.href = 'about:blank';
                    
                    });

                </script>";

                exit(); // End Run

            }

            $id = urldecode(decrypt($_REQUEST['accessKey'])); // Decrypt Into Invoice ID

            $invoice = invoiceData($id, $conn); // Locate Invoice

            if (!$invoice) { // Invoice Not Found

                echo "<script>
                
                    popup({
                    
                        header: 'ERROR!',

                        title: 'Invoice not found!',

                        text: 'Invalid URL Parameter!',

                        type: 'warning'
                    
                    }).then(() => {
                    
                        window.location.href = 'about:blank';
                    
                    });

                </script>";

                exit; // End Run

            }

            $currency = $invoice['currency'];

            $symbol = $currSymbol[$currency];

            $tax = $invoice['tax'];

            $taxType = $invoice['tax-type'];

            $discount = $invoice['discount'];

            $discountType = $invoice['discount-type'];

            $owed = $invoice['credit'] ?? 0;

            $taxAfterDiscount = ($invoice['tax-first'] == 'YES') ? true : false;

            $total = invoiceTotal($invoice['quantities-list'], $invoice['prices-list'], $owed, $discount, $discountType, $tax, $taxType, $taxAfterDiscount);

            $qty = array_map('trim', explode(',', $invoice['quantities-list']));

            $items = array_map('trim', explode(',', $invoice['items-list']));

            $prices = array_map('trim', explode(',', $invoice['prices-list']));

            $tableRows = ''; // Holds Table Structure

            $subtotal = 0;

            for ($i = 0; $i < count($items); $i++) {

                $taxed = ($tax) ? '*' : null;

                $itemQty = empty($qty[$i]) ? 1 : $qty[$i];

                $itemPrice = $prices[$i];

                $cost = $itemQty * $itemPrice;

                $subtotal += $cost;

                $cost = number_format($cost, 2);

                $displayQty = empty($qty[$i]) ? null : '(' . $qty[$i] . ')';

                $tableRows .= <<<HTML

                    <tr>

                        <td>$items[$i] $displayQty $taxed</td>

                        <td><span translate="no">$symbol</span>$cost</td>

                    </tr>
                
                HTML;

            }

            $taxAmount = 0;

            if ($tax) {

                $taxAmount = $tax;

                if ($taxType === 'PERCENTAGE') {

                    $taxAmount = ($tax / 100) * $subtotal;

                }

                $taxAmount = number_format($taxAmount, 2);

            }

            $discountAmount = 0;

            if ($discount) {

                $discountAmount = $discount;

                if ($discountType === 'PERCENTAGE') {

                    $discountAmount = ($discount / 100) * $subtotal;

                }

                $discountAmount = number_format($discountAmount, 2);

            }

            $subtotal = number_format($subtotal, 2);

        ?>

        <!-- <header></header>

        <main></main> -->

        <div id="invoice">

            <div class="invItem print-0 trnl">

                <div class="trnlCon">

                    <div class="trnlCon_progeny flx">

                        <p>Choose Language: </p>

                        <div class="gtranslate_wrapper"></div>
                        
                    </div>
                    
                </div>

            </div>

            <div class="invItem header">

                <div class="invSub">

                    <div class="logo">

                        <img src="<?= SITE_LOGO ?>"  alt="">

                    </div>

                    <p class="invTitle">Invoice #<?= $invoice['invoice-number'] ?></p>

                    <p class="invTitle"><?= $invoice['invoice-title'] ?></p>

                </div>

                <div class="invSub">

                    <div>

                        <p class="invStatus" variant="<?= $invoice['status'] === 'PAID' ? 'success' : 'error' ?>"><?= $invoice['status'] ?></p>

                        <p>Due: <?= date('l, F jS, Y', strtotime($invoice['due'])) ?></p>
                        
                    </div>

                    <?php
                    
                        if ($invoice['status'] === 'UNPAID') { // Determine If Invoice Is Payable (Based On Status) ?>

                            <div class="flx print-0" id="pay-invoice">

                                <input type="hidden" value="<?= $id ?>">

                                <button type="button" id="checkout" class="form_btn" style="width: auto;">Pay Now</button>

                            </div>
                    
                    <?php } ?>

                </div>

            </div>

            <div class="invItem parties">

                <div class="invSub">

                    <p class="title">Invoiced To</p>

                    <p translate="no">

                        <?= $invoice['customer'] ?><br>

                        <?=
                        
                            (is_null($invoice['street']) ? null : nl2br($invoice['street'] . ",\n")) .

                            (is_null($invoice['zip-code']) ? null : nl2br($invoice['zip-code'] . ' ')) .

                            (is_null($invoice['city']) ? null : nl2br($invoice['city'] . ",\n")) .

                            (is_null($invoice['state']) ? null : nl2br($invoice['state'] . ",\n")) .

                            (is_null($invoice['country']) ? null : nl2br($invoice['country'] . '.'));

                        ?>

                    </p>

                </div>

                <div class="invSub">

                    <p class="title">Recipient</p>

                    <p><?= $invoice['user'] ?></p>

                </div>

            </div>

            <div class="invItem dateChannel">

                <div class="invSub">

                    <p class="title">Invoice Date</p>

                    <p><?= date('l, F jS, Y', strtotime($invoice['created'])) ?></p>

                </div>

                <div class="invSub">

                    <p class="title">Payment Handler</p>

                    <div class="logo">

                        <img src="../assets/media/pay-icons/pay-logo.png"  alt="" style="height: 3em;">

                    </div>

                </div>

            </div>

            <div class="invItem details">

                <div class="invDetails_box">

                    <div class="title">

                        <p>Invoice Details</p>

                    </div>
                    
                    <div class="table_con">

                        <table class="invoiceTable">

                            <thead>

                                <tr>

                                    <th>Description</th>

                                    <th>Amount</th>

                                </tr>

                            </thead>

                            <tbody>

                                <?= $tableRows ?>

                            </tbody>

                            <tfoot>

                                <tr>

                                    <td>Sub Total</td>

                                    <td class="iQ_convX"><span translate="no"><?= $symbol ?></span><?= $subtotal ?><span translate="no"><?= $currency ?></span></td>

                                </tr>

                                <tr>

                                    <td>Discount<?= ($tax && $discountType === 'PERCENTAGE') ? '(' . $discount . '%)' : '' ?></td>

                                    <td class="iQ_convX"><span translate="no"><?= $symbol ?></span><?= $discountAmount ?><span translate="no"><?= $currency ?></span></td>

                                </tr>

                                <tr>

                                    <td>TAX<?= ($tax && $taxType === 'PERCENTAGE') ? '(' . $tax . '%)' : '' ?></td>

                                    <td class="iQ_convX"><span translate="no"><?= $symbol ?></span><?= $taxAmount ?><span translate="no"><?= $currency ?></span></td>

                                </tr>

                                <tr>

                                    <td>Credit</td>

                                    <td class="iQ_convX"><span translate="no"><?= $symbol ?></span><?= number_format($owed, 2) ?><span translate="no"><?= $currency ?></span></td>

                                </tr>

                                <tr>

                                    <td>Total</td>

                                    <td class="iQ_convX"><span translate="no"><?= $symbol ?></span><?= number_format($total, 2) ?><span translate="no">USD</span></td>

                                </tr>

                            </tfoot>

                        </table>

                    </div>

                </div>
                
                <p><i>* Indicates a taxed item<?= ($invoice['tax-first'] == 'YES') ? ' <small>(Tax applied before discount)</small>' : null ?></i></p>

                <div class="table_con credit">

                    <table class="creditTable">

                        <thead>

                            <tr>

                                <th>Transaction Date</th>

                                <th>Gateway</th>

                                <th>Transaction ID</th>

                                <th>Amount</th>

                            </tr>

                        </thead>

                        <tbody>

                            <tr>

                                <td colspan="4">No Related Transactions Found</td>

                            </tr>

                        </tbody>

                        <tfoot>

                            <tr>

                                <td colspan="3">Balance</td>

                                <td class="iQ_convX"><span translate="no">$</span><?= number_format($total, 2) ?><span translate="no">USD</span></td>

                            </tr>

                        </tfoot>

                    </table>

                </div>

            </div>

            <div class="invItem help">

                <div class="invSub">

                    <?= (!is_null($invoice['notes']) ? '<p>Additional Notes: ' . $invoice['notes'] . '</p>': null) ?>

                    <p><i><?= SITE_NAME ?></i> will automatically allocate payments to the recipient once it reflects on <i><?= SITE_NAME . '\'s' ?></i> Payment Gateway account.</p>

                    <p>In case you need help, you can reach us via <a translate="no" href="mailto:<?= SITE_CONTACT_EMAIL ?>" class="form_link"><?= SITE_CONTACT_EMAIL ?></a></p>

                </div>

            </div>

            <div class="invItem options  print-0">

                <div class="actionCon">

                    <button class="actionBtn" type="button" id="iQ_print">Print</button>

                    <button class="actionBtn" type="button" id="iQ_pdf" ifQ-target="#iQ_download">Download</button>

                </div>

            </div>

        </div>

    </body>

    <script src="../assets/scripts/processor-bridge.js"></script>

    <script src="utility/initiator.js"></script>

    <script src="../resources/html-PDF/html2pdf.bundle.min.js"></script>

    <script>

        // Print Invoice

        document.addEventListener("DOMContentLoaded", () => {

            let command = document.querySelector('#iQ_print');

            let page = document.querySelector('#invoice');

            if (command && page) {

                // let originalPage = document.body.innerHTML;

                command.addEventListener("click", () => {

                    var printWindow = document.createElement('iframe'); // Iframe to hold content
                    printWindow.style.position = 'absolute';
                    printWindow.style.width = '0px';
                    printWindow.style.height = '0px';
                    printWindow.style.border = 'none';
                    document.body.appendChild(printWindow);

                    // Append Content

                    var doc = printWindow.contentWindow.document;
                    doc.open();
                    doc.write('<!DOCTYPE html><html><head></head><body>');

                    var styles = document.querySelectorAll('link[rel="stylesheet"], style'); // Get Parent CSS
                    styles.forEach((style) => {
                        doc.head.appendChild(style.cloneNode(true)); // Clone & Append
                    });
                        
                    doc.write(page.innerHTML);  // Insert Page
                    doc.write('</body></html>');
                    doc.close();

                    // Load then trigger Print Dialog

                    printWindow.onload = () => {
                            
                        printWindow.contentWindow.focus();  // Focus On Iframe
                        printWindow.contentWindow.print();  //  Trigger Print Dialog
                        document.body.removeChild(printWindow); // Remove Iframe

                    };

                });

            }

        });

        // Invoice PDF

        document.addEventListener("DOMContentLoaded", () => {

            let command = document.querySelector('#iQ_pdf');
            let page = document.querySelector('#invoice'); // The page you want to convert to PDF

            if (command && page) {
                command.addEventListener("click", () => {

                    // Find and hide all elements with the class .print-0 before generating the PDF
                    let printZeroElements = page.querySelectorAll('.print-0');
                    let removedElements = [];
                    printZeroElements.forEach(el => {
                        // Store the original display value and hide the element
                        removedElements.push({ element: el, display: el.style.display });
                        el.style.display = 'none'; // Hide the element
                    });

                    // Store original styles
                    const originalStyles = {
                        width: page.style.width,
                        height: page.style.height,
                        padding: page.style.padding,
                        border: page.style.border,
                        overflow: page.style.overflow
                    };

                    // Apply the desired styles to ensure one-page fit for the PDF
                    page.style.setProperty('width', '800px', 'important');
                    page.style.setProperty('height', 'auto', 'important'); // Adjust height automatically based on content
                    page.style.setProperty('padding', '2.5em', 'important');
                    page.style.setProperty('border', 'none', 'important');
                    page.style.setProperty('overflow', 'visible', 'important');

                    // Generate the filename using the filename() function
                    const generatedFilename = filename(); // Get the dynamic filename

                    // Generate PDF directly using html2pdf
                    html2pdf()
                        .from(page)
                        .set({
                            margin: [0, 0, 0, 0],  // Set margin to 0 to avoid extra space around the content
                            filename: `${generatedFilename}.pdf`, // Use the dynamic filename with .pdf extension
                            jsPDF: {
                                unit: 'mm',
                                format: 'a4',
                                orientation: 'portrait'
                            },
                            html2canvas: { 
                                scale: 2,
                                windowWidth: document.documentElement.scrollWidth,  // Ensure we capture full page width
                                windowHeight: document.documentElement.scrollHeight  // Capture full page height
                            }
                        })
                        .toPdf()
                        .get('pdf')
                        .then(function(pdf) {
                            // Check the PDF content size and scale it to fit within the page
                            const pageHeight = pdf.internal.pageSize.height;
                            const contentHeight = page.scrollHeight;

                            // Scale the content to fit one page if needed
                            if (contentHeight > pageHeight) {
                                const scale = pageHeight / contentHeight;
                                pdf.setScale(scale);
                            }

                            // Save the generated PDF with the dynamic filename
                            pdf.save(`${generatedFilename}.pdf`);

                            // User Feedback

                            toast({

                                text: 'PDF saved!',

                                type: 'success',

                                duration: 7000

                            });

                            // Restore the .print-0 elements after the PDF is downloaded
                            removedElements.forEach(({ element, display }) => {
                                element.style.display = display; // Restore the original display value
                            });

                            // Restore original styles
                            page.style.setProperty('width', originalStyles.width);
                            page.style.setProperty('height', originalStyles.height);
                            page.style.setProperty('padding', originalStyles.padding);
                            page.style.setProperty('border', originalStyles.border);
                            page.style.setProperty('overflow', originalStyles.overflow);
                        })
                        .catch(function(error) {
                            
                            // User Feedback

                            toast({

                                text: 'Unable to process request!',

                                type: 'warning',

                                duration: 7000

                            });

                            // Handle error or cleanup as needed
                            console.error('PDF conversion error:', error);

                            // Restore the .print-0 elements in case of an error
                            removedElements.forEach(({ element, display }) => {
                                element.style.display = display; // Restore the original display value
                            });

                            // Restore original styles if the conversion fails
                            page.style.setProperty('width', originalStyles.width);
                            page.style.setProperty('height', originalStyles.height);
                            page.style.setProperty('padding', originalStyles.padding);
                            page.style.setProperty('border', originalStyles.border);
                            page.style.setProperty('overflow', originalStyles.overflow);
                        });
                });
            }

        });

        // Function To Generate Filenames 

        function filename() {

            const date = new Date();
            const weekdays = ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"];
            const months = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
            
            const weekday = weekdays[date.getUTCDay()]; // Get the current weekday (Sun-Sat)
            const year = date.getUTCFullYear(); // Get the current year
            const month = months[date.getUTCMonth()]; // Get the current month (Jan-Dec)
            const day = String(date.getUTCDate()).padStart(2, '0'); // Get the current day (01-31)

            // Get the current time (hours, minutes, seconds) in UTC
            const hours = String(date.getUTCHours()).padStart(2, '0'); // 2-digit hours
            const minutes = String(date.getUTCMinutes()).padStart(2, '0'); // 2-digit minutes
            const seconds = String(date.getUTCSeconds()).padStart(2, '0'); // 2-digit seconds

            // Get the current timezone abbreviation dynamically using Intl.DateTimeFormat
            const timeZone = new Intl.DateTimeFormat('en-US', {
                timeZoneName: 'short'
            }).formatToParts(date).find(part => part.type === 'timeZoneName').value;

            // Format the date string including time (hours:minutes:seconds)
            const formattedDate = `${weekday}-${year}-${month}-${day} ${hours}:${minutes}:${seconds} ${timeZone}`;
            
            // Get the document title
            const title = document.title.trim(); // Get the document title

            // Construct the filename using the title and formatted date (without file extension)
            return `${title}_${formattedDate}`;
            
        }

    </script>

    <!-- GTranslate -->

    <script>window.gtranslateSettings = {"default_language":"en","native_language_names":true,"detect_browser_language":true,"wrapper_selector":".gtranslate_wrapper","flag_size":16}</script>
    <script src="https://cdn.gtranslate.net/widgets/latest/popup.js" defer></script>

</html>