<?php

    // Credentials

    session_name('INVSESSID');

    session_start(); // Initialize Session

    require('../controls/config/config.php'); // Configuration File

    require('../controls/engines/fxns.php'); // User Defined Functions 

    $target = filename();

    if (isset($_SESSION['PAY'])) {

        // Payment Session Timeout

        if (!isset($_SESSION['PAYMENT-EXPIRES'])) {

            $_SESSION['PAYMENT-EXPIRES'] = time() + (30 * 60);  // Intialize Countdown (30 minutes)

        }

        // Recall Sessions

        $commodity = $_SESSION['PAY'];

        $amount = $_SESSION['PAY-AMOUNT'];

        // Search For Bank 

        $localBank = false; // Bank Flag

        require('../controls/engines/ip-fxns.php'); // Import IP Functions

        $userIP = getUserIP(); // Get IP Address

        $userInfo = getUserInfo($userIP); // Get User Information Via IP Address

        $locale = $userInfo['countryCode'] ?? 'N/A'; // Get Country Code

        if ($locale) {

            // Search For An Available Bank

            $getLocalBank = mysqli_prepare($conn, "SELECT * FROM `pay_resources` WHERE `type` = ? AND `country_code` = ?");

            $type = 'BANK';

            mysqli_stmt_bind_param($getLocalBank, "ss", $type, $locale);

            mysqli_stmt_execute($getLocalBank);

            $resultsLocalBank = mysqli_stmt_get_result($getLocalBank);

            if (mysqli_num_rows($resultsLocalBank) > 0) {

                $localBank = true;

            }

            mysqli_free_result($resultsLocalBank);

            mysqli_stmt_close($getLocalBank);

        }
        
    } else {

        // Redirect (ERROR 401)

        echo'<script>
        
            window.location.href = "../error?code=401";

        </script>';

        exit(); // End Run

    }


?>

<!DOCTYPE html>

<html lang="en">

<head>

    <meta charset="UTF-8">

    <meta http-equiv="X-UA-compatible" content="ie=edge">

    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">

    <link rel="icon" href="<?= SITE_FAVICON ?>">

    <link rel="stylesheet" type="text/css" href="../assets/stylesheets/core.css">

    <script>
        (function () {
            const page = document.documentElement; //|| document.body; // Ensure it's the right element to modify

            // Check system preference and localStorage immediately
            const systemPreferenceDark = window.matchMedia('(prefers-color-scheme: dark)').matches;

            // Apply theme if dark mode is preferred by the user or if stored in localStorage
            if (localStorage.pageClass === 'darkmode' || (systemPreferenceDark && localStorage.pageClass === undefined)) {
                page.classList.add('darkmode');
            }
        })();
    </script>

    <script type="text/javascript" src="../assets/scripts/script.js" defer></script>

    <title>
        <?= pageTitles($target) ?> | <?= SITE_TITLE ?>
    </title>

</head>

<body>

    <?php
    
        require('../partials/preloader.php'); // Preloader
    
    ?>

    <header id="dashHeader">

        <div class="dash_hbanner <?= (($target == '') || ($target == 'home')) ? '' : 'jaQ'; ?>">

            <div class="logo <?= (($target == '') || ($target == 'home')) ? '' : 'jaQ'; ?>">

                <a href="../home">

                    <img class="light" src="<?= SITE_LOGO ?>" alt="">

                    <img class="dark" src="<?= SITE_LOGO_DARK ?>" alt="">

                </a>

            </div>

            <div class="salutation <?= (($target == '') || ($target == 'home')) ? '' : 'jaQ'; ?>">

                <?= headerMsg($target, null) ?>

            </div>

            <div style="margin: 0 auto;">

                <div class="gtranslate_wrapper"></div>

            </div>

        </div>

    </header>

    <main>

        <section>

            <div class="pay_con">

                <div class="pay_box">

                    <div class="payBox_con">

                        <div class="payBox_header">

                            <div class="pBH_item">

                                <div class="logo">

                                    <img class="light" src="<?= SITE_LOGO ?>" alt="">

                                    <img class="dark" src="<?= SITE_LOGO_DARK ?>" alt="">

                                </div>

                            </div>

                            <div class="pBH_item">

                                <p class="price iQ_conv">
                                    <?= ($_SESSION['SUBJECT-CURR']) ? $currSymbol[$_SESSION['SUBJECT-CURR']] : '$' ?>
                                    <?= number_format($amount, 2); ?>
                                </p>

                                <p class="font-sm">
                                    <?= $commodity; ?>
                                </p>

                            </div>

                        </div>

                        <div class="payBox_main">

                            <!-- Pre-processor -->

                            <div id="payProcessor" class="n_displ">

                                <div class="form_con">

                                    <p>We're confirming your payment. This could take about 4mins.<br> Please do not refresh
                                        this page!</p>

                                    <div class="flx" style="margin: 2em 0;">

                                        <div class="loading_spinner">

                                            <svg viewBox="25 25 50 50">
                                                <circle r="20" cy="50" cx="50"></circle>
                                            </svg>

                                        </div>

                                    </div>

                                    <div class="statusBox">

                                        <div>

                                            <span>Payment made</span>

                                            <p class="tick"></p>

                                        </div>

                                        <div>

                                            <span>Payment Confirmed</span>

                                            <div class="spinner sm"></div>

                                        </div>

                                    </div>

                                </div>

                            </div>

                            <!-- Crypto -->

                            <div class="iQ_panel n_displ">

                                <?php
                                
                                    // Fetch Crypto Resources

                                    $resources = false; // Flag

                                    $stmt = mysqli_prepare($conn, "SELECT DISTINCT `resource_name` FROM `pay_resources` ORDER BY `preference` DESC"); // Prepare Statement (For Resource Names)

                                    mysqli_stmt_execute($stmt); // Execute Statement

                                    $result = mysqli_stmt_get_result($stmt); // Get Result

                                    if (mysqli_num_rows($result) > 0) {

                                        $resources = true; // Update Flag

                                        $names = []; // Hold All Resource Names

                                        while ($row = mysqli_fetch_assoc($result)) {

                                            $names[] = $row['resource_name']; 
                                        }

                                    }

                                    mysqli_free_result($result); // Free Result

                                    mysqli_stmt_close($stmt);

                                    $crypto = false; // Flag

                                    $data = []; // Store Crypto Data

                                    if ($resources) {

                                        for ($i = 0; $i < count($names); $i++) { // Iterate Through Resource Name(s)

                                            $resource = $names[$i];

                                            $stmt = mysqli_prepare($conn, "SELECT * FROM `pay_resources` WHERE `resource_name` = ? AND `type` = ? ORDER BY RAND() LIMIT 1"); // Prepare Statement (Radomize Through Crypto Resources)

                                            // Parameter(s)

                                            $type = 'CRYPTO';

                                            mysqli_stmt_bind_param($stmt, "ss", $resource, $type); // Bind Parameter(s)

                                            mysqli_stmt_execute($stmt); // Execute Statement

                                            $result = mysqli_stmt_get_result($stmt); // Get Statement Result

                                            if (mysqli_num_rows($result) > 0) {

                                                $crypto = true; // Update Flag

                                                $data[] = mysqli_fetch_assoc($result); // Store Result Data


                                            }

                                            mysqli_free_result($result); // Free Result

                                            mysqli_stmt_close($stmt); // Close Statement

                                        }

                                    }

                                    // Check Flag

                                    if ($crypto) { ?>

                                        <div class="form_con">

                                            <p class="font-sm">Select an asset and proceed to your crypto wallet to complete this transfer</p>

                                            <a href="<?= $cryptoVendor; ?>" class="form_link crypto" target="_blank">Buy Crypto</a>

                                            <form id="invoice-via-crypto" class="payForm" method="post">

                                                <?php
                                                
                                                    // Iterate Through Crypto Resources

                                                    foreach ($data as $row):

                                                        $id = $row['id'];

                                                        $token = $row['resource_name'];

                                                        $symbol = $row['resource_symbol'];

                                                        $network = $row['network_type'];

                                                        $address = $row['resource_attr'];

                                                        $codeQR = $row['resource_qrcode']; ?>

                                                        <div class="form_item data-con">

                                                            <label for="channel">
                                                                <?= $token ?>
                                                            </label>

                                                            <input type="hidden" class="data-asset" value="<?= $token . ' (' . $symbol . ')' ?>">

                                                            <span class="equivAmt"><?= convPayAmt($token, $symbol, $_SESSION['PAY-AMOUNT'], $_SESSION['SUBJECT-CURR']) ?></span>

                                                            <?php 
                                                                
                                                                if ($network != null) {

                                                                    echo '<span class="ntwrk_info">Network Type: ' . $network . '</span>';

                                                                } 
                                                            
                                                            ?>

                                                            <div class="form_item v3">

                                                                <input type="radio" name="channel" value="<?= $id ?>">

                                                                <div class="form_field pseudo payField">

                                                                    <div class="icon">

                                                                        <img class="data-icon" src="../resources/crypto-icons/<?= strtolower($symbol) ?>.png" alt="">

                                                                    </div>

                                                                    <input type="text" class="data-addr copyField" value="<?= $address ?>" readonly>

                                                                    <input type="hidden" class="data-qr" value="<?= ($codeQR != null) ? SITE_BASE_URL . '/' . str_replace('../', '', $codeQR) : '' ?>">

                                                                    <div iQ-target="#iQ_asset" class="data-sender icon">

                                                                        <svg class="qr" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                                                                            <path fill-rule="evenodd" clip-rule="evenodd" d="M9 3H3V9H5V5H9V3ZM3 21V15H5V19H9V21H3ZM15 3V5H19V9H21V3H15ZM19 15H21V21H15V19H19V15ZM7 7H11V11H7V7ZM7 13H11V17H7V13ZM17 7H13V11H17V7ZM13 13H17V17H13V13Z" fill="currentColor"></path>
                                                                        </svg>

                                                                    </div>

                                                                    <div>

                                                                        <div class="address_copy copier" title="Copy Address">

                                                                            <div class="icon">

                                                                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none">
                                                                                    <path d="M10 8V7C10 6.05719 10 5.58579 10.2929 5.29289C10.5858 5 11.0572 5 12 5H17C17.9428 5 18.4142 5 18.7071 5.29289C19 5.58579 19 6.05719 19 7V12C19 12.9428 19 13.4142 18.7071 13.7071C18.4142 14 17.9428 14 17 14H16M7 19H12C12.9428 19 13.4142 19 13.7071 18.7071C14 18.4142 14 17.9428 14 17V12C14 11.0572 14 10.5858 13.7071 10.2929C13.4142 10 12.9428 10 12 10H7C6.05719 10 5.58579 10 5.29289 10.2929C5 10.5858 5 11.0572 5 12V17C5 17.9428 5 18.4142 5.29289 18.7071C5.58579 19 6.05719 19 7 19Z" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" />
                                                                                </svg>

                                                                            </div>

                                                                            <span>Copy</span>

                                                                        </div>

                                                                    </div>

                                                                </div>

                                                            </div>

                                                        </div>    

                                                    <?php endforeach;
                                                
                                                ?>

                                                <div class="form_item">

                                                    <button type="submit" id="payCrypto" class="form_btn">I have made the transfer</button>

                                                </div>

                                            </form>

                                        </div>

                                    <?php } else {

                                        echo '<div class="form_con">

                                            <div class="error_mode">
                                        
                                                <p class="title">Oops!</p>

                                                <img src="../assets/images/icons/no-access.webp" alt="" class="error_img">

                                                <p>Crypto payments are currently unavailable at the moment. Please try another payment method.</p>

                                                <div>OR</div>

                                                <button>Contact Support</button>

                                            </div>    
                                        
                                        </div>';

                                    }
                                
                                ?>

                            </div>

                            <!-- Miscellanous -->

                            <div class="iQ_panel n_displ">

                                <div class="payBox_con">

                                    <?php
                                    
                                        // Fetch Miscellanous Payment Methods

                                        $channelsA = false;

                                        $channelsB = false;

                                        if ($resources) {

                                            $dataA = []; // For Channel A Resource(s)

                                            $dataB = []; // For Channel B Resource(s)

                                            for ($i = 0; $i < count($names); $i++) { // Iterate Through Resource Name(s)

                                                $resource = $names[$i];
    
                                                $stmt = mysqli_prepare($conn, "SELECT * FROM `pay_resources` WHERE `resource_name` = ? AND (`type` = ? OR `type` = ? OR `type` = ? OR `type` = ?) ORDER BY RAND() LIMIT 1"); // Prepare Statement (Radomize Through Payment Resources)
    
                                                // Parameter(s)
    
                                                $type1 = 'APPLE PAY';

                                                $type2 = 'PAYPAL';

                                                $type3 = 'GOOGLE PAY';

                                                $type4 = 'WECHAT PAY';
    
                                                mysqli_stmt_bind_param($stmt, "sssss", $resource, $type1, $type2, $type3, $type4); // Bind Parameter(s)
    
                                                mysqli_stmt_execute($stmt); // Execute Statement
    
                                                $result = mysqli_stmt_get_result($stmt); // Get Statement Result
    
                                                if (mysqli_num_rows($result) > 0) {
    
                                                    $channelsA = true; // Update Flag
    
                                                    $dataA[] = mysqli_fetch_assoc($result); // Store Result Data
    
                                                }
    
                                                mysqli_free_result($result); // Free Result
    
                                                mysqli_stmt_close($stmt); // Close Statement

                                                $stmtB = mysqli_prepare($conn, "SELECT * FROM `pay_resources` WHERE `resource_name` = ? AND (`type` = ? OR `type` = ? OR `type` = ? OR `type` = ? OR `type` = ?) ORDER BY RAND() LIMIT 1"); // Prepare Statement (Radomize Through Payment Resources)
    
                                                // Parameter(s)
    
                                                $type1B = 'VENMO';

                                                $type2B = 'ZELLE';

                                                $type3B = 'CASHAPP';

                                                $type4B = 'REVOLUT';

                                                $type5B = 'ALI PAY';
    
                                                mysqli_stmt_bind_param($stmtB, "ssssss", $resource, $type1B, $type2B, $type3B, $type4B, $type5B); // Bind Parameter(s)
    
                                                mysqli_stmt_execute($stmtB); // Execute Statement
    
                                                $resultB = mysqli_stmt_get_result($stmtB); // Get Statement Result
    
                                                if (mysqli_num_rows($resultB) > 0) {
    
                                                    $channelsB = true; // Update Flag
    
                                                    $dataB[] = mysqli_fetch_assoc($resultB); // Store Result Data
    
                                                }
    
                                                mysqli_free_result($resultB); // Free Result
    
                                                mysqli_stmt_close($stmtB); // Close Statement
    
                                            }

                                        }

                                        if ($channelsA || $channelsB) { ?>

                                            <div class="form_con">

                                                <p class="font-sm">Select preferred payment method</p>

                                                <form method="post" id="invoice-via-misc" class="payForm">

                                                    <?php

                                                        if ($channelsA) { ?>

                                                            <div class="optBtn_box">

                                                                <div class="form_item db" style="gap: 1.5em">

                                                                    <?php

                                                                        $props = [
                                                                            
                                                                            'APPLE PAY' => ['class' => ' light apple', 'image' => '../assets/media/pay-icons/applepay.svg'],

                                                                            'GOOGLE PAY' => ['class' => null, 'image' => '../assets/media/pay-icons/googlepay.svg'],

                                                                            'PAYPAL' => ['class' => ' paypal', 'image' => '../assets/media/pay-icons/paypal.svg'],

                                                                            'WECHAT PAY' => ['class' => null, 'image' => '../assets/media/pay-icons/wechatpay.svg']
                                                                            
                                                                        ];

                                                                        foreach ($dataA as $row):

                                                                            $id = $row['id'];

                                                                            $type = $row['type'];

                                                                            $address = $row['resource_attr'];

                                                                            $codeQR = $row['resource_qrcode'] != null ? SITE_BASE_URL . '/' . str_replace('../', '', $row['resource_qrcode']) : null;

                                                                            $logo = $props[$type]['image'];
                                                                            
                                                                            $class = $props[$type]['class']; ?>

                                                                            <div iQ-target="#iQ_asset" class="deliver-data opt_btn<?= $class ?>">

                                                                                <input type="radio" name="method" class="data-type" data-id="<?= $type ?>" value="<?= $id ?>">

                                                                                <input type="hidden" class="attr-data" value="<?= $address ?>">

                                                                                <input type="hidden" class="qr-data" value="<?= $codeQR ?>">

                                                                                <img src="<?= $logo ?>" alt="">

                                                                            </div>

                                                                        <?php endforeach;
                                                                    
                                                                    ?>    

                                                                </div>  
                                                                
                                                            </div>    

                                                        <?php }
                                                    
                                                        if ($channelsA && $channelsB) {

                                                            echo '<div style="padding: 1em 0;"><span class="exx">OR</span></div>';

                                                        }

                                                        if ($channelsB) {

                                                            $props = [

                                                                'ALI PAY' => ['icon' => '../assets/media/pay-icons/alipay.png'],
                                                                            
                                                                'CASHAPP' => ['icon' => '../assets/media/pay-icons/cashapp.svg'],

                                                                'REVOLUT' => ['icon' => '../assets/media/pay-icons/revolut.png'],

                                                                'VENMO' => ['icon' => '../assets/media/pay-icons/venmo.svg'],

                                                                'ZELLE' => ['icon' => '../assets/media/pay-icons/zelle.png']
                                                                
                                                            ];

                                                            foreach ($dataB as $row):

                                                                $id = $row['id'];

                                                                $type = $row['type'];

                                                                $address = $row['resource_attr'];

                                                                $codeQR = $row['resource_qrcode'] != null ? SITE_BASE_URL . '/' . str_replace('../', '', $row['resource_qrcode']) : null;

                                                                $icon = $props[$type]['icon'];  ?>

                                                                    <div class="form_item<?= $codeQR ? ' data-con' : null ?>">

                                                                        <label for="method"><?= ucfirst(strtolower($type)) ?></label>

                                                                        <div class="form_item v3">

                                                                            <input type="radio" name="method" value="<?= $id ?>">

                                                                            <div class="form_field pseudo payField">

                                                                                <div class="icon">

                                                                                    <img class="data-icon" src="<?= $icon ?>" alt="">

                                                                                </div>

                                                                                <input type="text" class="copyField<?= $codeQR ? ' data-addr' : null ?>" value="<?= $address ?>" readonly>

                                                                                <?php
                                                                                
                                                                                    if ($codeQR) { ?>

                                                                                        <input type="hidden" class="data-asset" value="<?= $type ?>">

                                                                                        <input type="hidden" class="data-qr" value="<?= $codeQR ?>">

                                                                                        <div iQ-target="#iQ_asset" class="data-sender icon">

                                                                                            <svg class="qr" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                                                                                                <path fill-rule="evenodd" clip-rule="evenodd" d="M9 3H3V9H5V5H9V3ZM3 21V15H5V19H9V21H3ZM15 3V5H19V9H21V3H15ZM19 15H21V21H15V19H19V15ZM7 7H11V11H7V7ZM7 13H11V17H7V13ZM17 7H13V11H17V7ZM13 13H17V17H13V13Z" fill="currentColor"></path>
                                                                                            </svg>

                                                                                        </div>

                                                                                    <?php }
                                                                                
                                                                                ?>

                                                                                <div>

                                                                                    <div class="address_copy copier" title="Copy Address">

                                                                                        <div class="icon">

                                                                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none">
                                                                                                <path d="M10 8V7C10 6.05719 10 5.58579 10.2929 5.29289C10.5858 5 11.0572 5 12 5H17C17.9428 5 18.4142 5 18.7071 5.29289C19 5.58579 19 6.05719 19 7V12C19 12.9428 19 13.4142 18.7071 13.7071C18.4142 14 17.9428 14 17 14H16M7 19H12C12.9428 19 13.4142 19 13.7071 18.7071C14 18.4142 14 17.9428 14 17V12C14 11.0572 14 10.5858 13.7071 10.2929C13.4142 10 12.9428 10 12 10H7C6.05719 10 5.58579 10 5.29289 10.2929C5 10.5858 5 11.0572 5 12V17C5 17.9428 5 18.4142 5.29289 18.7071C5.58579 19 6.05719 19 7 19Z" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" />
                                                                                            </svg>

                                                                                        </div>

                                                                                        <span>Copy</span>

                                                                                    </div>

                                                                                </div>

                                                                            </div>

                                                                        </div>

                                                                    </div>

                                                            <?php endforeach;

                                                        }
                                                    
                                                    ?>

                                                    <div class="form_item">

                                                        <button class="form_btn" id="payMisc">I have made the transfer</button>

                                                    </div>

                                                </form>
                                                
                                            </div>

                                        <?php } else {

                                            echo '<div class="form_con">

                                                <div class="error_mode">
                                            
                                                    <p class="title">Oops!</p>

                                                    <img src="../assets/images/icons/no-access.webp" alt="" class="error_img">

                                                    <p>Payments are currently unavailable at the moment. Please try another payment method.</p>

                                                    <div>OR</div>

                                                    <button>Contact Support</button>

                                                </div>    
                                            
                                            </div>';

                                        }
                                    
                                    ?>

                                </div>

                            </div>

                            <!-- Bank -->

                            <div class="iQ_panel n_displ">

                                <div class="payBox_con">

                                    <p style="font-size: 0.8rem;">Proceed to your bank app to complete this transfer</p>

                                    <div class="payAcc_details">

                                        <?php

                                            if ($localBank) {

                                                // Randomize Local Bank

                                                $queryLocalBanks = mysqli_query($conn, "SELECT * FROM `pay_resources` WHERE `type` = 'BANK' AND `country_code` = '$locale' ORDER BY RAND() LIMIT 1");

                                                if (mysqli_num_rows($queryLocalBanks) > 0) {

                                                    while ($bankDetails = mysqli_fetch_assoc($queryLocalBanks)) {

                                                        $bankID = $bankDetails['id'];

                                                        $bankName = $bankDetails['bank_name'];

                                                        $accName = $bankDetails['resource_name'];

                                                        $accNum = $bankDetails['resource_attr'];

                                                        $sort = $bankDetails['sorting'];

                                                        $iban = $bankDetails['iban'];

                                                        $swift = $bankDetails['swift'];

                                                        $routing = $bankDetails['routing'];

                                                        echo '<div class="accDetail_item">

                                                        <div>

                                                            <p class="title">Amount</p>

                                                            <p class="desc">$' . number_format($_SESSION["PAY-AMOUNT"], 2) . '</p>

                                                        </div>

                                                    </div>
                                                    
                                                    <div class="accDetail_item">

                                                        <div>

                                                            <p class="title">Account Number</p>

                                                            <p class="desc"><input class= "copyField integrate" value="' . $accNum . '"></p>

                                                        </div>

                                                        <a class="address_copy copier">

                                                            <div class="icon">

                                                                <svg xmlns="http://www.w3.org/2000/svg" width="800px" height="800px" viewBox="0 0 24 24" fill="none"><path d="M10 8V7C10 6.05719 10 5.58579 10.2929 5.29289C10.5858 5 11.0572 5 12 5H17C17.9428 5 18.4142 5 18.7071 5.29289C19 5.58579 19 6.05719 19 7V12C19 12.9428 19 13.4142 18.7071 13.7071C18.4142 14 17.9428 14 17 14H16M7 19H12C12.9428 19 13.4142 19 13.7071 18.7071C14 18.4142 14 17.9428 14 17V12C14 11.0572 14 10.5858 13.7071 10.2929C13.4142 10 12.9428 10 12 10H7C6.05719 10 5.58579 10 5.29289 10.2929C5 10.5858 5 11.0572 5 12V17C5 17.9428 5 18.4142 5.29289 18.7071C5.58579 19 6.05719 19 7 19Z" stroke="#464455" stroke-linecap="round" stroke-linejoin="round"/></svg>

                                                            </div>

                                                            <span>Copy</span>

                                                        </a>

                                                    </div>
                                                    
                                                    <div class="accDetail_item">

                                                        <div>

                                                            <p class="title">Bank Name</p>

                                                            <p class="desc" translate="no">' . $bankName . '</p>

                                                        </div>
                                                        
                                                    </div>
                                                    
                                                    <div class="accDetail_item">

                                                        <div>

                                                            <p class="title">Beneficiary</p>

                                                            <p class="desc" translate="no">' . $accName . '</p>

                                                        </div>
                                                        
                                                    </div>';

                                                        if ($iban !== null) {

                                                            echo '<div class="accDetail_item">

                                                            <div>

                                                                <p class="title">IBAN</p>

                                                                <p class="desc" translate="no">' . $iban . '</p>

                                                            </div>
                                                            
                                                        </div>';
                                                        }

                                                        if ($sort !== null) {

                                                            echo '<div class="accDetail_item">

                                                            <div>

                                                                <p class="title">Sorting Code</p>

                                                                <p class="desc" translate="no">' . $sort . '</p>

                                                            </div>
                                                            
                                                        </div>';
                                                        }

                                                        if ($swift !== null) {

                                                            echo '<div class="accDetail_item">

                                                            <div>

                                                                <p class="title">Swift Code</p>

                                                                <p class="desc" translate="no">' . $swift . '</p>

                                                            </div>
                                                            
                                                        </div>';
                                                        }

                                                        if ($routing !== null) {

                                                            echo '<div class="accDetail_item">

                                                            <div>

                                                                <p class="title">Routing Code</p>

                                                                <p class="desc" translate="no">' . $routing . '</p>

                                                            </div>
                                                            
                                                        </div>';
                                                        }

                                                        echo '<form method="post" id="invoice-via-bank">

                                                        <input name="bank_id" type="hidden" value="' . $bankID . '">

                                                        <div class="form_item">

                                                            <button class="form_btn" id="payBank">I have made this bank transfer</button>

                                                        </div>

                                                    </form>';
                                                    }
                                                } else {

                                                    echo '<p>Unavailable At the moment!</p>';

                                                    $localBank = false;
                                                }
                                            } else {

                                                echo '<p>Unavailable At the moment!</p>';

                                                $localBank = false;
                                            }

                                            ?>

                                    </div>



                                </div>

                            </div>

                            <!-- Card -->

                            <div class="iQ_panel n_displ">

                                <div class="form_con">

                                    <p style="font-size: 0.8rem;">Enter your card details to pay</p>

                                    <form id="viaCard" method="post">

                                        <div class="form_item">

                                            <label for="">Card Number</label>

                                            <div class="form_field pseudo pseudoField">

                                                <div class="icon no_fill">

                                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 25 25" fill="none">
                                                        <path d="M4.5 10.5H20.5M4.5 9.5H20.5M4.5 11.5H20.5M7 15.5H14M5.5 18.5H19.5C20.0523 18.5 20.5 18.0523 20.5 17.5V7.5C20.5 6.94772 20.0523 6.5 19.5 6.5H5.5C4.94772 6.5 4.5 6.94772 4.5 7.5V17.5C4.5 18.0523 4.94772 18.5 5.5 18.5Z" stroke="currentColor" stroke-width="1.2"/>
                                                    </svg>

                                                </div>

                                                <input placeholder="0000 0000 0000 0000" id="cardNum">

                                                <div class="icon">

                                                    <svg aria-hidden="true"
                                                        class="SVGInline-svg SVGInline--cleaned-svg SVG-svg Icon-svg Icon--lock-svg Icon-color-svg Icon-color--gray500-svg"
                                                        height="12" width="12" viewBox="0 0 16 16"
                                                        xmlns="http://www.w3.org/2000/svg">
                                                        <path
                                                            d="M3 7V5a5 5 0 1 1 10 0v2h.5a1 1 0 0 1 1 1v6a2 2 0 0 1-2 2h-9a2 2 0 0 1-2-2V8a1 1 0 0 1 1-1zm5 2.5a1 1 0 0 0-1 1v2a1 1 0 0 0 2 0v-2a1 1 0 0 0-1-1zM11 7V5a3 3 0 1 0-6 0v2z"
                                                            fill-rule="evenodd" fill="currentColor"></path>
                                                    </svg>

                                                </div>

                                            </div>

                                        </div>

                                        <div class="form_item db">

                                            <div class="form_item">

                                                <label for="">Valid Till</label>

                                                <div class="form_field pseudo pseudoField">

                                                    <div class="icon no_fill">

                                                        <svg xmlns="http://www.w3.org/2000/svg" width="800px" height="800px"
                                                            viewBox="0 0 25 25" fill="none">
                                                            <path
                                                                d="M4.5 10.5H20.5M4.5 9.5H20.5M4.5 11.5H20.5M7 15.5H14M5.5 18.5H19.5C20.0523 18.5 20.5 18.0523 20.5 17.5V7.5C20.5 6.94772 20.0523 6.5 19.5 6.5H5.5C4.94772 6.5 4.5 6.94772 4.5 7.5V17.5C4.5 18.0523 4.94772 18.5 5.5 18.5Z"
                                                                stroke="currentColor" stroke-width="1.2" />
                                                        </svg>

                                                    </div>

                                                    <input type="text" placeholder="MM/YY" maxlength="5" id="cardExpires">

                                                </div>

                                            </div>

                                            <div class="form_item">

                                                <label for="">CVV</label>

                                                <div class="form_field pseudo pseudoField">

                                                    <div class="icon no_fill">

                                                        <svg xmlns="http://www.w3.org/2000/svg" width="800px" height="800px"
                                                            viewBox="0 0 25 25" fill="none">
                                                            <path
                                                                d="M4.5 10.5H20.5M4.5 9.5H20.5M4.5 11.5H20.5M7 15.5H14M5.5 18.5H19.5C20.0523 18.5 20.5 18.0523 20.5 17.5V7.5C20.5 6.94772 20.0523 6.5 19.5 6.5H5.5C4.94772 6.5 4.5 6.94772 4.5 7.5V17.5C4.5 18.0523 4.94772 18.5 5.5 18.5Z"
                                                                stroke="currentColor" stroke-width="1.2" />
                                                        </svg>

                                                    </div>

                                                    <input placeholder="123" id="cardCode" maxlength="4">

                                                </div>

                                            </div>



                                        </div>

                                        <div class="form_item checkbox_con">

                                            <input type="checkbox"> <span>Remember this card next time</span>

                                        </div>

                                        <div class="form_item">

                                            <button class="form_btn" id="useCard">Pay <span class="iQ_conv">
                                                    <?= '$' . number_format($amount, 2); ?>
                                                </span></button>

                                        </div>

                                    </form>

                                </div>

                            </div>

                            <div class="flx"
                                style="font-size: 0.8rem; text-transform: uppercase; gap: 1em; padding-top: 2em;">

                                <span>Powered By</span>

                                <div class="logo pay">

                                    <img class="light" src="../assets/media/pay-icons/pay-logo.png" alt="Payment Gateway LLC">

                                    <img class="dark" src="../assets/media/pay-icons/pay-logo-dark.png" alt="Payment Gateway LLC">

                                </div>

                            </div>

                        </div>

                    </div>

                </div>

                <!-- Options Panel -->

                <div class="pay_box pay_options">

                    <div class="payBox_con">

                        <p class="title">Payment Options</p>

                        <div class="payOptions_con">

                            <div class="pay_option iQ_panelSwitch">

                                <div class="icon"></div>

                                <span>Crypto <sup class="label">New</sup></span>

                                <!-- <a href="<?= CRYPTO_VENDOR; ?>" class="form_link" target="_blank" style="display: block; padding: 0 0.5em; margin-inline-start: auto; width: fit-content; font-size: 0.6rem; align-self: baseline;">Buy Crypto</a> -->

                            </div>

                            <div class="pay_option iQ_panelSwitch">

                                <div class="icon"></div>

                                <span>Others <sup class="label" style="font-size: 0.6rem;">New</sup><sup
                                        class="label image"><img src="../assets/media/pay-icons/wechatpay.svg"
                                            alt></sup></span>

                            </div>

                            <div class="pay_option iQ_panelSwitch<?= $localBank === false ? ' inaccessible' : '' ?>">

                                <div class="icon"></div>

                                <span>Bank <sup class="label lime">Transfers</sup>
                                    <?= $localBank === false ? '<sup class="label red">Unavailable</sup>' : '' ?>
                                </span>

                            </div>

                            <div class="pay_option iQ_panelSwitch">

                                <div class="icon"></div>

                                <span>Card</span>

                            </div>

                        </div>

                        <div class="flx" style="justify-content: space-between; margin: 1.3em 0 0">

                            <p class="exp-time label v2 red" style="width: fit-content; text-align: end; margin: 0;">Expires In: <span translate="no"></span></p>

                            <p style="text-align: end;"><i class="text-min">Crypto Rates provided by <a target="_blank" href="https://coinconvert.net/"><u>coinconvert</u></a></i></p>    

                        </div>

                    </div>

                </div>

            </div>

        </section>

        <!-- Upload Proof Popup -->

        <div id="payProof" class="popup_window n_displ" role="dialog">

            <div id="iQ_proof" class="popup_con n_displ">

                <div class="popup_box noScrollBar float_up">

                    <div style="position: sticky; top: 0; background-color: inherit; display: flex; align-items: center;">

                        <p>Upload Proof of Payment</p>

                        <div class="radial_icon iQ_terminator"
                            style="margin-left: auto; cursor: pointer; background-color: var(--pg-invert);">

                            <svg width="15" height="15" viewBox="0 0 19 19" fill="none" xmlns="http://www.w3.org/2000/svg"
                                class="close-icon">
                                <path d="M5.80032 5.79883L13.1229 13.1214" stroke="white" stroke-width="1.68132"
                                    stroke-linecap="round" stroke-linejoin="round"></path>
                                <path d="M5.79958 13.1214L13.1222 5.79883" stroke="white" stroke-width="1.68132"
                                    stroke-linecap="round" stroke-linejoin="round"></path>
                            </svg>

                        </div>

                    </div>

                    <div class="modal_box">

                        <form id="inv-PayProof" method="post" enctype="multipart/form-data">

                            <div class="form_item" style="justify-content: center; user-select: none;">

                                <div id="proof-displ"></div>

                            </div>

                            <div class="form_item">

                                <label for="">Transaction ID</label>

                                <input class="form_field" type="text" placeholder="(Optional)" name="proof-id">

                            </div>

                            <div class="form_item">

                                <label for="proof">Upload Payment Proof</label>

                                <input name="proof" type="file" accept="image/png, image/jpeg, image/jpg, image/webp, image/svg+xml, application/pdf" class="form_field" id="proof-file">

                            </div>

                            <div class="form_item formBtn_con">

                                <button class="form_btn" id="uploadProof" type="submit">Proceed</button>

                            </div>

                        </form>

                    </div>

                </div>

            </div>

        </div>

        <!-- Asset Details Popup -->

        <div class="popup_window n_displ" role="dialog">

            <div id="iQ_asset" class="popup_con n_displ">

                <div class="popup_box noScrollBar float_up">

                    <div style="position: sticky; top: 0; background-color: inherit; display: flex; align-items: center;">

                        <p><span class="asset-data-receiver"></span> Details</p>

                        <div class="radial_icon iQ_terminator"
                            style="margin-left: auto; cursor: pointer; background-color: var(--pg-invert);">

                            <svg width="15" height="15" viewBox="0 0 19 19" fill="none" xmlns="http://www.w3.org/2000/svg"
                                class="close-icon">
                                <path d="M5.80032 5.79883L13.1229 13.1214" stroke="white" stroke-width="1.68132"
                                    stroke-linecap="round" stroke-linejoin="round"></path>
                                <path d="M5.79958 13.1214L13.1222 5.79883" stroke="white" stroke-width="1.68132"
                                    stroke-linecap="round" stroke-linejoin="round"></path>
                            </svg>

                        </div>

                    </div>

                    <div class="modal_box">

                        <p style="color: var(--pg-greyB); font-size: 0.9rem;">Scan QR Code / Copy Address</p>

                        <div>

                            <div class="form_item" style="justify-content: center; user-select: none;">

                                <div id="qr-displ">

                                    <img src="" alt="">

                                </div>

                            </div>

                            <div class="form_item">

                                <label for=""><span class="asset-data-receiver"></span> Address</label>

                                <div class="form_field pseudo payField">

                                    <div class="icon no_fill">

                                        <img id="data-icon-receiver" src="" alt="">

                                    </div>

                                    <input class="form_field copyField" type="text" id="data-addr-receiver" readonly>

                                    <div>

                                        <a class="address_copy copier">

                                            <div class="icon">

                                                <svg xmlns="http://www.w3.org/2000/svg" width="800px" height="800px"
                                                    viewBox="0 0 24 24" fill="none">
                                                    <path
                                                        d="M10 8V7C10 6.05719 10 5.58579 10.2929 5.29289C10.5858 5 11.0572 5 12 5H17C17.9428 5 18.4142 5 18.7071 5.29289C19 5.58579 19 6.05719 19 7V12C19 12.9428 19 13.4142 18.7071 13.7071C18.4142 14 17.9428 14 17 14H16M7 19H12C12.9428 19 13.4142 19 13.7071 18.7071C14 18.4142 14 17.9428 14 17V12C14 11.0572 14 10.5858 13.7071 10.2929C13.4142 10 12.9428 10 12 10H7C6.05719 10 5.58579 10 5.29289 10.2929C5 10.5858 5 11.0572 5 12V17C5 17.9428 5 18.4142 5.29289 18.7071C5.58579 19 6.05719 19 7 19Z"
                                                        stroke="#464455" stroke-linecap="round" stroke-linejoin="round">
                                                    </path>
                                                </svg>

                                            </div>

                                            <span>Copy</span>

                                        </a>

                                    </div>

                                </div>



                            </div>

                        </div>

                    </div>

                </div>

            </div>

        </div>

        <?php

            if (PAY_POPUP == 'ON') { ?>

                <!-- MODAL: Tip -->

                <div id="iQ_payTip" class="popup_window n_displ">

                    <div class="popup_con n_displ">

                        <div class="popup_box noScrollBar">

                            <div class="popupBox_header v2">

                                <p style="font-size: 1.2rem;" class="b">SECURITY TIP</p>

                            </div>

                            <div class="modal_box notify">

                                <div class="msgHold">

                                    <div class="icon" style="color: red;">

                                        <svg viewBox="0 0 13 13" aria-hidden="true">
                                            <path fill="currentColor"
                                                d="M6.5.5c-3.3 0-6 2.7-6 6s2.7 6 6 6 6-2.7 6-6-2.7-6-6-6m0 1c2.757 0 5 2.243 5 5s-2.243 5-5 5-5-2.243-5-5 2.243-5 5-5">
                                            </path>
                                            <path fill="currentColor"
                                                d="M7.75 3.8501c0 .2-.05.35-.2.5-.15.15-.3.2-.5.2s-.35-.05-.5-.2c-.15-.15-.2-.3-.2-.5s.05-.35.2-.5c.15-.15.3-.2.5-.2s.35.05.5.2c.1.15.2.3.2.5M7 7.5001h.45c-.4 1.45-.9 1.85-1.55 1.85-.25 0-.5-.05-.6-.15-.1-.1-.2-.3-.2-.5 0-.15.05-.35.15-.7l.55-1.5c.05-.1.05-.2-.3-.25v-.1c.35-.05.3 0 .25 0-.15 0-.35.2-.55.35h-.45c.4-.6.9-1.05 1.6-1.05.25 0 .45.05.55.2.1.15.2.3.2.5 0 .15-.05.4-.2.75l-.5 1.4c-.05.2-.1.3-.1.35 0 .05 0 .05.05.05s.05.05.1.05c.1 0 .15-.05.3-.2.15-.15.2-.25.25-1.05">
                                            </path>
                                        </svg>

                                    </div>

                                    <div class="txtBox">

                                        <div class="title">Verify wallet addresses</div>

                                        <div class="form_field pseudo flx"
                                            style="padding: 0.7em; justify-content: flex-start; gap: 0; margin: 0.5em 0;"
                                            translate="no">

                                            <div style="padding: 0.1em 0; background-color: #ffff008c;">1A1</div>
                                            zP1eP5QGefi2DMPTfTL5SLmv7Div <div
                                                style="padding: 0.1em 0; background-color: #ffff008c;">fNa</div>

                                        </div>

                                        <p>Always check the first three and last three characters of the wallet address.</p>

                                    </div>

                                </div>

                                <div class="flx" style="justify-content: flex-start;">

                                    <a class="form_btn v2 iQ_terminator"
                                        style="margin-inline-start: auto; margin-inline-end: 0; background-color: var(--RadBlack); padding: 0.7em;">Close</a>

                                </div>

                            </div>

                        </div>

                    </div>

                </div>

            <?php }    

            require('../partials/support-popup.php'); // Support Popup

        ?>

    </main>    

    <!-- Toast -->

    <script src="../assets/scripts/toast-notify.js"></script>

    <!-- Payment Session Monitor -->
    <script src="utility/monitors/pay-session-monitor.js"></script>
    <!-- PDFJS -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdf.js/2.10.377/pdf.min.js"></script>
    <!-- Processor Bridge -->
    <script src="../assets/scripts/processor-bridge.js"></script>
    <script src="utility/initiator.js"></script>
    <!-- GTranslate -->
    <script>window.gtranslateSettings = {"default_language":"en","native_language_names":true,"detect_browser_language":true,"wrapper_selector":".gtranslate_wrapper","flag_size":16}</script>
    <script src="https://cdn.gtranslate.net/widgets/latest/popup.js" defer></script>

</body>

</html>