<?php

    // Credentials

    session_name('INVSESSID');

    session_start(); // Initiate Sessions

    require('../../../controls/config/config.php'); // Configuration File

    require('../../../controls/engines/fxns.php'); // Functions File

    require('../../../vendor/autoload.php'); // Composer Package(s) File 

    require('../../../controls/engines/mail-delivery-engine.php'); // Mail Fxns

    require('../../../controls/engines/mail-drafts.php'); // Mail Drafts

    header('Content-Type: application/json'); // Communication Protocol

    // Payment Proof Form Processor

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        $user_id = $_SESSION['USER-ID'];

        if (isset($_FILES['proof']) && $_FILES['proof']['error'] === 0) {

            $proof = $_FILES['proof']; // Uploaded File

            // Directory To Store File

            $directory = '../../../vault/proof-payments/';

            $uploadProof = fileUpload($proof, $directory, 'payment-', null, true, false, true); // Upload File

            if ($uploadProof['status']) {

                $proof = $uploadProof['vault']; 

            } else {

                if ($uploadProof['error'] == 'Extension Error') {

                    echo json_encode(['extensionError' => true]);

                } else if ($uploadProof['error'] == 'MIME Error') {

                    echo json_encode(['mimeError' => true]);

                } else {

                    echo json_encode(['uploadError' => true]);

                }
                
                exit();

            }

            // Recall Sessions

            $payItem = $_SESSION['PAY'];

            $amount = $_SESSION['PAY-AMOUNT'];

            $itemDesc = $_SESSION['PAY-DESC'] ?? null;

            // $equiv = $_SESSION['SUBJECT-AMOUNT'];

            $currency = $_SESSION['SUBJECT-CURR'];
            
            $equiv = null;

            if ($currency != 'USD') { // Convert To USD

                $equiv = convertToUSD($amount, $currency);

            } 

            $payAsset = null;

            $assetEquiv = isset($_SESSION['ASSET-EQUIV']) ? $_SESSION['ASSET-EQUIV'] : null;

            if (!is_null($assetEquiv)) {

                $assetEquiv = round((float) $assetEquiv, 8);

            }

            // Fetch Resource Data

            $resourceId = $_SESSION['RESOURCE-ID'];

            $resourceData = mysqli_prepare($conn, "SELECT * FROM `pay_resources` WHERE `id` = ?");

            mysqli_stmt_bind_param($resourceData, "s", $resourceId);

            mysqli_stmt_execute($resourceData);

            $rDataResults = mysqli_stmt_get_result($resourceData);

            if (mysqli_num_rows($rDataResults) === 1) {

                while ($getResourceData = mysqli_fetch_assoc($rDataResults)) {

                    $resourceVendor = $getResourceData['vendor_name'];

                    $resourceAttr = $getResourceData['resource_attr'];

                    if ($resourceAttr === null) {

                        $resourceAttr = $getResourceData['resource_qrcode'];

                    }

                    $resourceType = $getResourceData['type'];

                    if ($resourceType === 'BANK') {

                        $payChannel = 'BANK TRANSFER';

                        $resourceVendor = $getResourceData['bank_name'];

                    } else if ($resourceType === 'CRYPTO') {

                        $payChannel = 'CRYPTO';

                        $payAsset = $getResourceData['resource_symbol'];

                        if ($getResourceData['network_type'] != null) {

                            $payAsset = $payAsset . '[' . $getResourceData['network_type'] . ']';

                        }

                    } else {

                        $payChannel = $resourceType;

                    }

                }

            }

            // Free Result & Close Statement

            mysqli_free_result($rDataResults);

            mysqli_stmt_close($resourceData);

            // $datetime = timeGMT(); // Get Current Datetime

            $type = 'INVOICE';

            $datetime = timeGMT('l, M d Y, (H:i) [T]');

            // Intiate Data Drop

            $drop = false; // Data Drop Flag

            $invoiceID = null;

            $invID = generateUniqueID($conn, 'invoice_payments', 'INV-PAY-'); // Generate ID

            $customer = $_SESSION['CUSTOMER'];

            // Record Payment

            $recordPayment = mysqli_prepare($conn, "INSERT INTO `invoice_payments` (`invpay_id`, `user_id`, `customer_id`, `amount`, `currency`, `invoice_id`, `pay_channel`, `pay_asset`, `identifier`, `vendor`, `channel_attr`, `pay_proof`) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"); // Prepare Statement

            mysqli_stmt_bind_param($recordPayment, 'sssdssssssss', $invID, $user_id, $customer, $amount, $currency, $itemDesc, $payChannel, $payAsset, $resourceId, $resourceVendor, $resourceAttr, $proof); // Bind Parameter(s)

            if (mysqli_stmt_execute($recordPayment)) {

                $drop = true;

                $invoiceID =  SITE_BASE_URL . '/invoice/?accessKey=' . urlencode(encrypt($itemDesc));

                mysqli_query($conn, "UPDATE `invoices` SET `status` = 'PAID' WHERE `invoice_id` = '$itemDesc'"); // Update Invoice Status

            }

            // Close Statement

            mysqli_stmt_close($recordPayment);

            // Check Flag

            if ($drop) {

                $customerName = 'a customer';

                $userData = userData($user_id, $conn); // Get User Data

                $customerData = customerData($customer, $conn); // Get Customer Data

                // Handle Notification(s) & Mail

                if ($customerData) {

                    // Initiator Mail

                    $subject = 'Payment Confirmation #' . mt_rand(10000000, 99999999);

                    $mail = $mail = payGateway($datetime, $type, $payItem, 'PROCESSING (Awaiting Verification)', $currSymbol[$currency] . number_format($amount, 2) . $currency, $invID);

                    $deliver = @deliverByPHPMailer($subject, $mail, makePlain($mail), $customerData['email'], $customerData['name']);

                    if (!$deliver) {

                        @deliverByPHPMail($customerData['email'], $subject, $mail); // Fallback

                    }


                }

                if ($userData) {

                    $notf =  'Hello ' . join(' ', [$userData['firstname'], $userData['lastname']]) . ', this is to notify you that a payment has been made for ' . $payItem . ' on ' . $datetime . ' and is under review.';

                    createNotification($conn, $user_id, 'Invoice Payment Under Review.', $notf);

                }

                // Send Emails

                $subjectAdmin = 'Invoice Payment Notification #' . mt_rand(10000000, 99999999);

                $adminMsg = adminInvoicePayNotification($currSymbol[$currency] . number_format($amount, 2) . $currency, $itemDesc . '/' .  $payItem, $resourceType, $datetime, $invID);

                $deliverAdmin = @deliverByPHPMailer($subjectAdmin, $adminMsg, makePlain($adminMsg), ADMIN_MAIL, ADMIN_NAME);

                if (!$deliverAdmin) {

                    @deliverByPHPMail(ADMIN_MAIL, $subjectAdmin, $adminMsg); // Fallback

                }

                $_SESSION['FEEDBACK'] = true;

                $_SESSION['PAY-GO'] = true;
                    
                $sessions = [

                    'PAY',
                    'PAY-AMOUNT',
                    'PAY-DESC',
                    'SUBJECT-CURR',
                    'SUBJECT-AMOUNT',
                    'ASSET-EQUIV',
                    'RESOURCE-ID',
                    'PAYMENT-EXPIRES',
                    'CUSTOMER'

                ];

                foreach ($sessions as $session) {

                    if (isset($_SESSION[$session])) {

                        unset($_SESSION[$session]);

                    }

                }
                
            }

            echo json_encode(['insertProof' => $drop, 'id' => $invoiceID]); // Encode JSON Response
           
        }

    }

?>