<?php

    // Credentials

    session_name('USERSESSID');

    session_start(); // Initiate Session(s)

    require('controls/config/config.php'); // Configuration Setup

    require('controls/engines/fxns.php'); // Function Definition(s)

    httpErrorCheck(); // Listen For HTTP Error Codes (Custom Error Pages)

    if (M_MODE !== 'ON') {

        $_SESSION['HTTP-ERROR'] = 401;

        echo '<script>
        
            window.location.reload();

        </script>';

    }

    require('vendor/autoload.php'); // Composer Package(s) File

    require('controls/engines/mail-delivery-engine.php'); // Function Definition(s)

    require('controls/engines/mail-drafts.php'); // Mail Drafts

    // Notify Admin

    $subject = 'Maintanance Mode Active!';

    $mail = mModeActive(); // Mail Draft

    $deliver = @deliverByPHPMailer($subject, $mail, makePlain($mail), ADMIN_MAIL, ADMIN_NAME);

    if ($deliver) {

        @deliverByPHPMail(ADMIN_MAIL, $subject, $mail); // Fallback Delivery

    }

?>

<!DOCTYPE html>

<html lang="en" dir="ltr">

<head>

    <meta charset="UTF-8">

    <meta http-equiv="X-UA-compatible" content="ie=edge">

    <meta name="viewport" content="width=device-width, initial-scale=1.0, max-scale=1.0, user-scalable=no">

    <link rel="stylesheet" type="text/css" href="assets/stylesheets/core.css">

    <script>
        (function() {
            const page = document.documentElement; //|| document.body; // Ensure it's the right element to modify

            // Check system preference and localStorage immediately
            const systemPreferenceDark = window.matchMedia('(prefers-color-scheme: dark)').matches;
            
            // Apply theme if dark mode is preferred by the user or if stored in localStorage
            if (localStorage.pageClass === 'darkmode' || (systemPreferenceDark && localStorage.pageClass === undefined)) {
            page.classList.add('darkmode');
            }
        })();
    </script>

    <script src="assets/scripts/popup-notify.js"></script>

    <link rel="icon" href="<?= $siteIcon ?>">

    <title>Under Maintenance | <?= $siteTitle ?></title>

    <style>

        .error_con {

            min-height: 100vh;

            display: flex;

            flex-wrap: wrap;

            justify-content: center;

            min-width: 100vw;

            padding: 2em;

            overflow: hidden;

        }

        .error_box {

            text-align: center;

            display: flex;

            flex-direction: column;

            justify-content: center;

            align-items: center;

            min-width: 50%;


        }

        .error_box > * {

            margin: 0.5em;

        }

        .error_box h1 {

            font-size: 5rem;

            background: linear-gradient(158deg, rgb(248, 69, 0) 0%, rgb(67, 78, 220) 90%) text;

            -webkit-text-fill-color: transparent;

        }

        .error_box p {

            font-family: var(--monoFont);

            max-width: 30em;

            line-height: 1.8;

        }

        .error_box button {

            flex: 0 1 auto;

            width: 12.5em;

        }

        .vzB_header {

            display: flex;

            justify-content: space-between;

            align-items: center;

            width: 100%;

            max-width: 2000px;

            margin: 0 auto;

        }

        .error_con.augmented {

            min-width: 100%;

            min-height: calc(100vh - 5.2em);

        }

        #accessBtn {

            display: flex;
            
            padding: 0.8em 0.5em;

            margin: 0;

        }

        #accessBtn * {

            margin: 0; 

        }

    </style>

</head>

<body>

    <header class="landing_header">

        <div class="dash_hbanner">

            <div class="vzB_header">

                <div class="logo">

                    <a>

                        <img class="light" src="<?= SITE_LOGO ?>" alt="">

                        <img class="dark" src="<?= SITE_LOGO_DARK ?>" alt="">
                        
                    </a>

                </div>

                <div style="margin: 0 auto;">

                    <div class="gtranslate_wrapper"></div>

                </div>    

            </div>

        </div>

        
    </header>

    <div class="error_con augmented">

        <div class="error_box">

            <h1>Oops!</h1>

            <h3>Under Maintenance</h3>

            <p style="font-family: var(--BaseFont);">Sorry, <i><?= trim(SITE_NAME) ?></i> is currently under maintenance.<br> We aplogize for the inconvenience, please try again another time.</p>

                <button id="accessBtn" type="button" class="pg_btn variantPlain">

                    <div style="width: 1.2em">

                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="none" viewBox="0 0 24 24" class="icon-md-heavy"><path fill="currentColor" d="M3.07 10.876C3.623 6.436 7.41 3 12 3a9.15 9.15 0 0 1 6.012 2.254V4a1 1 0 1 1 2 0v4a1 1 0 0 1-1 1H15a1 1 0 1 1 0-2h1.957A7.15 7.15 0 0 0 12 5a7 7 0 0 0-6.946 6.124 1 1 0 1 1-1.984-.248m16.992 1.132a1 1 0 0 1 .868 1.116C20.377 17.564 16.59 21 12 21a9.15 9.15 0 0 1-6-2.244V20a1 1 0 1 1-2 0v-4a1 1 0 0 1 1-1h4a1 1 0 1 1 0 2H7.043A7.15 7.15 0 0 0 12 19a7 7 0 0 0 6.946-6.124 1 1 0 0 1 1.116-.868"></path></svg>

                    </div>

                    <span>Refresh</span>

                </button>

            </form>

        </div>

    </div>


    <script>

        // Access Checker Handler

        document.addEventListener("DOMContentLoaded", () => {

            let button = document.querySelector('#accessBtn');

            if (button) {

                button.addEventListener("click", () => {

                    if (button.disabled) return; // Prevent Multiple Submissions

                    button.disabled = true; // Disable Button

                    let content = button.innerHTML; // Get Button's Text

                    button.innerHTML = `<svg stroke="currentColor" fill="none" stroke-width="2" viewBox="0 0 24 24" stroke-linecap="round" stroke-linejoin="round" class="spin_icon" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg"><line x1="12" y1="2" x2="12" y2="6"></line><line x1="12" y1="18" x2="12" y2="22"></line><line x1="4.93" y1="4.93" x2="7.76" y2="7.76"></line><line x1="16.24" y1="16.24" x2="19.07" y2="19.07"></line><line x1="2" y1="12" x2="6" y2="12"></line><line x1="18" y1="12" x2="22" y2="12"></line><line x1="4.93" y1="19.07" x2="7.76" y2="16.24"></line><line x1="16.24" y1="7.76" x2="19.07" y2="4.93"></line></svg> <span>Processing...</span>`; // Button Feedback

                    button.classList.add('inaccessible'); // Loading Animation & Disable Interaction 

                    fetch('controls/logic/access-check.php', {

                        method: 'POST',

                        headers: {

                            'Content-Type': 'application/x-www-form-urlencoded'

                        }

                    }) // Request Handler, Credentials
                    .then(response => response.json()) // Parse JSON Response
                    .then(data => {

                        // Handle Response

                        if (data.noAccess) {

                            setTimeout(() => { 

                                popup({ // Delay User Feedback

                                    header: 'Maintenance Mode',

                                    title: 'Website under maintenance!',

                                    text: 'We\'re extremely sorry for the inconvenience, please try again sometime',

                                    type: 'info',

                                });

                                // Restore Button

                                button.innerHTML = content; // Restore Original Button Text

                                button.classList.remove('inaccessible'); // Stop Animation & Allow User Interaction

                                button.disabled = false; // Enable Button

                            }, 1500);

                        } else {

                            setTimeout(() => {

                                window.location.href = 'index';

                            }, 1200);

                        }

                    }).catch(error => {

                        console.error('Error:', error); // Log Error To Console

                    });

                });

            }

        });

    </script>

    <!-- Google Translate -->
        
    <script>window.gtranslateSettings = {"default_language":"en","native_language_names":true,"detect_browser_language":true,"wrapper_selector":".gtranslate_wrapper","flag_size":16}</script>
    <script src="https://cdn.gtranslate.net/widgets/latest/popup.js" defer></script>

</body>

</html>