<?php

    // Credentials

    session_name('USERSESSID');

    session_start(); // Establish Sessions

    require('../controls/config/config.php'); // Configuration File

    require('../controls/engines/fxns.php'); // Functions File

    maintenanceCheck(); // Check Maintenance Mode

    if (isset($_SESSION['RESTRICTED'])) { // Limit Access

        echo'<script>
                    
            window.location.href = "' . SITE_BASE_URL . '/security/restricted.php";
        
        </script>';

        exit();

    }

    httpErrorCheck('../'); // Listen For HTTP Error Codes (Custom Error Pages)

    $access = dashboardAccess(); // Check Access Status

    $user_id = $access['main-user']; // Main User

    $currentUser = $access['current-user']; // Who Logged In

    $userType = $access['user-type']; // User Type 

    validateUser($conn, $user_id); // Validate User

    $userData = userData($user_id, $conn); // Get User Data

    $userAccounts = userAccounts($user_id, $conn); // Get User Accounts

    $currentUserStatus = $userData['account-status']; // Account Status

    $token = $_COOKIE['ACCESS-iD'] ?? null; // Login Session Cookie

    if ($userType === 'THIRD PARTY') { // Fetch Third Party Data

        $thirdParty = thirdPartyData($currentUser, $conn); // Get Third Party Data

        if (!$thirdParty) { // Invalid Third Party

            // Log Out

            $_SESSION = [];

            session_destroy(); // Terminate Session(s)

            echo '<script>
            
                window.location.href = "../auth/";
            
            </script>';

            exit; // End Run

        }

        $currentUserStatus = $thirdParty['account-status'];

        $barred = $thirdParty['no-access']; // Get Barred Accounts

        if (!is_null($barred)) {

            $barredList = array_map('trim', explode(',', $barred)); // Convert to an array

            $userAccounts = array_filter($userAccounts, fn($a) => !in_array($a['currency'], $barredList)); // Update User Accounts

            $userAccounts = array_values($userAccounts); // Reset To Zero-based Indexing

        }

    } else {

        activateLog($conn, $currentUser, $token); // Re-activate Log Status (In Case of Multiple Device Logins)

    }

    setTimezone($conn, $token, $currentUser, $userType); // Set Timezone

    $serverTime = round(microtime(true) * 1000);

    $serverOffsetMinutes = -date('Z') / 60; // date('Z') returns offset in seconds from UTC

    $target = filename();

    payRestriction($target); // Restrict Navigation Due Payment

    if (isset($_SESSION['TRANSF-ID'])) {

        unset($_SESSION['TRANSF-ID']);

    }

    // if (isset($_SESSION['TRANSF-ID']) && ($target == 'home' || $target == 'support-tickets')) {

    //     unset($_SESSION['TRANSF-ID']);

    // } else {

    //     header('Location: transaction-success');

    // }

    $unreadNotf = unreadNotficationsCount($currentUser, $conn); // Get Unread Notifications

    $jointAccounts = jointAccounts($user_id, $conn); // Check For Joint Account

?>

<!DOCTYPE html>

<html lang="en">

<head>

    <meta charset="UTF-8">

    <meta http-equiv="X-UA-compatible" content="ie=edge">

    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">

    <link rel="icon" href="<?= SITE_FAVICON ?>">

    <link rel="stylesheet" type="text/css" href="../assets/stylesheets/core.css">

    <link rel="stylesheet" href="../resources/intl-tel-input/intlTelInput.css">

    <script src="../assets/scripts/popup-notify.js"></script>

    <noscript>
        <meta http-equiv="refresh" content="0; url=../noscript">
    </noscript>

    <script>
        (function() {
            const page = document.documentElement; //|| document.body; // Ensure it's the right element to modify

            // Check system preference and localStorage immediately
            const systemPreferenceDark = window.matchMedia('(prefers-color-scheme: dark)').matches;

            // Apply theme if dark mode is preferred by the user or if stored in localStorage
            if (localStorage.pageClass === 'darkmode' || (systemPreferenceDark && localStorage.pageClass === undefined)) {
                page.classList.add('darkmode');
            }
        })();
    </script>

    <script type="text/javascript" src="../assets/scripts/script.js" defer></script>

    <!-- Nice Select -->

    <script src="../resources/nice-select-2/nice-select2.js"></script>

    <link rel="stylesheet" type="text/css" href="../resources/nice-select-2/nice-select2.css">

    <!-- Hint -->

    <link rel="stylesheet" type="text/css" href="../resources/hint/hint.css">

    <title><?= pageTitles($target) ?> | <?= SITE_NAME ?></title>

</head>

<body id="dashboard">

    <?php

        // Preloader
    
        require('preloader.php');
    
    ?>

    <div class="dash_grid">

        <header id="dashHeader">

            <div class="dash_hbanner <?= (($target == '') || ($target == 'home')) ? '' : 'jaQ'; ?>">

                <div class="logo <?= (($target == '') || ($target == 'home')) ? '' : 'jaQ'; ?>">

                    <a href="home">

                        <img class="light" src="<?= SITE_LOGO ?>" alt="">

                        <img class="dark" src="<?= SITE_LOGO_DARK ?>" alt="">

                    </a>

                </div>

                <div class="salutation <?= (($target == '') || ($target == 'home')) ? '' : 'jaQ'; ?>">

                    <?= headerMsg($target, ucwords(join(' ', [$userData['firstname'], $userData['lastname']]))) ?>

                </div>

                <div style="margin: 0 auto;">

                    <div class="gtranslate_wrapper"></div>

                </div>

                <div class="ctrl_shrt">

                    <a id="toggle-notifications" class="settings radial_link shake notification-toggle pos-rel">

                        <?php

                            if ($unreadNotf > 0) {

                                echo '<div class="label pos-abs notf-counter" translate="no" style="right: -0.5em; top: -0.5em;">' . shortenNumber($unreadNotf) . '</div>';

                            }  
                            
                        ?>

                        <svg role="img" aria-hidden="false" xmlns="http://www.w3.org/2000/svg" width="100%" height="100%" fill="none" viewBox="0 0 20 20" aria-labelledby="NotificationIcon-9">
                            <path fill="currentColor" fill-rule="evenodd" d="M6.96 4.61C7.778 3.7 8.874 3.202 10 3.202c1.128 0 2.223.498 3.042 1.408.82.913 1.29 2.163 1.29 3.478v5.54H5.67v-5.54c0-1.315.47-2.565 1.29-3.478zm8.573 3.478v5.54h1.409v1.2H3.06v-1.2h1.409v-5.54c0-1.594.569-3.135 1.598-4.28C7.1 2.661 8.512 2.002 10.001 2.002c1.489 0 2.902.659 3.933 1.806 1.03 1.145 1.599 2.686 1.599 4.28zm-7.717 8.71v1.2h4.37v-1.2h-4.37z" clip-rule="evenodd"></path>
                        </svg>

                    </a>

                    <a class="user_profile radial_link<?= !is_null($userData['profile-image']) ? ' image' : null ?>">

                        <?php
                                
                            if (is_null($userData['profile-image']) || !file_exists('../' . str_replace('../', '', $userData['profile-image']))) {

                                echo '<span translate="no">' . strtoupper(join('', [$userData['firstname'][0], $userData['lastname'][0]])) . '</span>';

                            } else {

                                echo '<img src="'. $siteURL . '/' . str_replace('../', '', $userData['profile-image']). '" alt>';

                            }
                        
                        ?>

                    </a>

                    <div id="profile_popup" class="n_displ">

                        <div class="pPopup_box">

                            <div class="radial_link<?= !is_null($userData['profile-image']) ? ' image' : null ?>">

                                <?php
                                
                                    if (is_null($userData['profile-image']) || !file_exists('../' . str_replace('../', '', $userData['profile-image']))) {

                                        echo '<span translate="no">' . strtoupper(join('', [$userData['firstname'][0], $userData['lastname'][0]])) . '</span>';

                                    } else {

                                        echo '<img src="'. $siteURL . '/' . str_replace('../', '', $userData['profile-image']). '" alt>';

                                    }
                                
                                ?>

                            </div>

                            <div>

                                <p translate="no"><?= join(' ', [$userData['firstname'], $userData['middlename'] != null ? $userData['middlename'][0] . '.' : '', $userData['lastname']]) ?></p>

                                <p><?= ($userType == 'THIRD PARTY') ? 'JOINT USER (' . join(' ', [$thirdParty['firstname'], $thirdParty['middlename'] != null ? $thirdParty['middlename'][0] . '.' : '', $thirdParty['lastname']]) . ')': 'PERSONAL ACCOUNT' ?></p>

                            </div>

                        </div>

                        <?php
                        
                            if ($userType == 'THIRD PARTY') { ?>

                                <div>

                                    <a iQ-target="#iQ_resetPwrd" class="axialF">

                                        <svg aria-hidden="true" height="16" width="16" viewBox="0 0 16 16" xmlns="http://www.w3.org/2000/svg"><path d="M3 7V5a5 5 0 1 1 10 0v2h.5a1 1 0 0 1 1 1v6a2 2 0 0 1-2 2h-9a2 2 0 0 1-2-2V8a1 1 0 0 1 1-1zm5 2.5a1 1 0 0 0-1 1v2a1 1 0 0 0 2 0v-2a1 1 0 0 0-1-1zM11 7V5a3 3 0 1 0-6 0v2z" fill-rule="evenodd" fill="currentColor"></path></svg>

                                        <span>Reset Password</span>

                                    </a>

                                </div>

                            <?php } else { ?>

                                <div>

                                    <a href="profile" class="axialF">

                                        <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M8.10573 7.24666C8.03906 7.24 7.95906 7.24 7.88573 7.24666C6.29906 7.19333 5.03906 5.89333 5.03906 4.29333C5.03906 2.65999 6.35906 1.33333 7.99906 1.33333C9.6324 1.33333 10.9591 2.65999 10.9591 4.29333C10.9524 5.89333 9.6924 7.19333 8.10573 7.24666Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                            <path d="M4.7725 9.70667C3.15917 10.7867 3.15917 12.5467 4.7725 13.62C6.60583 14.8467 9.6125 14.8467 11.4458 13.62C13.0592 12.54 13.0592 10.78 11.4458 9.70667C9.61917 8.48667 6.6125 8.48667 4.7725 9.70667Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                        </svg>

                                        <span>Your Profile</span>

                                    </a>

                                </div>

                                <div>

                                    <a href="settings" class="spiN">

                                        <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M8 10C9.10457 10 10 9.10457 10 8C10 6.89543 9.10457 6 8 6C6.89543 6 6 6.89543 6 8C6 9.10457 6.89543 10 8 10Z" stroke="currentColor" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path>
                                            <path d="M1.33301 8.5863V7.41297C1.33301 6.71963 1.89967 6.1463 2.59967 6.1463C3.80634 6.1463 4.29967 5.29297 3.69301 4.2463C3.34634 3.6463 3.55301 2.8663 4.15967 2.51963L5.31301 1.85963C5.83967 1.5463 6.51967 1.73297 6.83301 2.25963L6.90634 2.3863C7.50634 3.43297 8.49301 3.43297 9.09967 2.3863L9.17301 2.25963C9.48634 1.73297 10.1663 1.5463 10.693 1.85963L11.8463 2.51963C12.453 2.8663 12.6597 3.6463 12.313 4.2463C11.7063 5.29297 12.1997 6.1463 13.4063 6.1463C14.0997 6.1463 14.673 6.71297 14.673 7.41297V8.5863C14.673 9.27963 14.1063 9.85297 13.4063 9.85297C12.1997 9.85297 11.7063 10.7063 12.313 11.753C12.6597 12.3596 12.453 13.133 11.8463 13.4796L10.693 14.1396C10.1663 14.453 9.48634 14.2663 9.17301 13.7396L9.09967 13.613C8.49967 12.5663 7.51301 12.5663 6.90634 13.613L6.83301 13.7396C6.51967 14.2663 5.83967 14.453 5.31301 14.1396L4.15967 13.4796C3.55301 13.133 3.34634 12.353 3.69301 11.753C4.29967 10.7063 3.80634 9.85297 2.59967 9.85297C1.89967 9.85297 1.33301 9.27963 1.33301 8.5863Z" stroke="currentColor" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path>
                                        </svg>

                                        <span>Account Settings</span>

                                    </a>

                                </div>

                                <div>

                                    <a iQ-target="#iQ-help" class="axialF">

                                        <svg width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg" class="Icon_icon__9oiVm">
                                            <rect x="0.938018" y="5.6525" width="2.1401" height="4.93885" rx="0.918598" stroke="currentColor" stroke-width="1.26446"></rect>
                                            <rect x="11.151" y="5.6525" width="2.1401" height="4.93885" rx="0.918598" stroke="currentColor" stroke-width="1.26446"></rect>
                                            <path d="M12.2222 10.9135V10.9135C12.2222 11.8156 11.4908 12.547 10.5886 12.547H10.066H8.60199" stroke="currentColor" stroke-width="1.26446"></path>
                                            <path d="M2.00775 5.33048V5.33048C2.00775 2.93228 3.95188 0.988159 6.35007 0.988159H7.87911C10.2773 0.988159 12.2214 2.93228 12.2214 5.33048V5.33048" stroke="currentColor" stroke-width="1.26446"></path>
                                            <rect x="5.81753" y="11.8456" width="2.63943" height="1.40296" rx="0.701482" stroke="currentColor" stroke-width="1.26446"></rect>
                                        </svg>

                                        <span>Contact Support</span>

                                    </a>

                                </div>

                            <?php }

                        ?>

                        <div>

                            <a class="shake pPopup_link iQ-logout">

                                <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M5.93359 5.04C6.14026 2.64 7.37359 1.66 10.0736 1.66H10.1603C13.1403 1.66 14.3336 2.85333 14.3336 5.83333V10.18C14.3336 13.16 13.1403 14.3533 10.1603 14.3533H10.0736C7.39359 14.3533 6.16026 13.3867 5.94026 11.0267" stroke="#EE312B" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                    <path d="M10.0007 8H2.41406" stroke="#EE312B" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                    <path d="M3.89935 5.76667L1.66602 8L3.89935 10.2333" stroke="#EE312B" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                </svg>

                                <span>Logout</span>

                            </a>

                        </div>

                    </div>

                </div>

                <div class="mobile_ctrl">

                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 448 512">
                        <path
                            d="M0 80c0-8.8 7.2-16 16-16H432c8.8 0 16 7.2 16 16s-7.2 16-16 16H16C7.2 96 0 88.8 0 80zM0 240c0-8.8 7.2-16 16-16H432c8.8 0 16 7.2 16 16s-7.2 16-16 16H16c-8.8 0-16-7.2-16-16zM448 400c0 8.8-7.2 16-16 16H16c-8.8 0-16-7.2-16-16s7.2-16 16-16H432c8.8 0 16 7.2 16 16z">
                        </path>
                    </svg>

                    <svg class="icon" xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18">
                        <path d="M1 1L17 17M1 17L17 1">
                        </path>
                    </svg>

                </div>

            </div>

        </header>

        <!-- Sidebar -->

        <aside id="dashSidebar">

            <div class="dash_sidebar nav">

                <nav>

                    <div class="overflow_con dashNav">

                        <ul class="dash_nav">

                            <li class="dash_nItem">

                                <a href="home" class="dash_nlink<?= (($target == '') || ($target == 'home')) ? ' active' : ''; ?>">

                                    <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                        xmlns="http://www.w3.org/2000/svg" class="icon">
                                        <path
                                            d="M6.01331 1.89336L2.41998 4.69336C1.81998 5.16003 1.33331 6.15336 1.33331 6.90669V11.8467C1.33331 13.3934 2.59331 14.66 4.13998 14.66H11.86C13.4066 14.66 14.6666 13.3934 14.6666 11.8534V7.00003C14.6666 6.19336 14.1266 5.16003 13.4666 4.70003L9.34665 1.81336C8.41331 1.16003 6.91331 1.19336 6.01331 1.89336Z"
                                            stroke="#A3ADC2" stroke-width="1.5" stroke-linecap="round"
                                            stroke-linejoin="round"></path>
                                        <path d="M8 11.9933V9.99329" stroke="#A3ADC2" stroke-width="1.5"
                                            stroke-linecap="round" stroke-linejoin="round"></path>
                                    </svg>

                                    <span>Home</span>

                                </a>

                            </li>

                            <li class="dash_nItem">

                                <a href="accounts" class="dash_nlink<?= ($target == 'accounts') ? ' active' : ''; ?>">

                                    <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                        xmlns="http://www.w3.org/2000/svg" class="icon">
                                        <path
                                            d="M12.027 9.03267C11.747 9.30601 11.587 9.69934 11.627 10.1193C11.687 10.8393 12.347 11.366 13.067 11.366H14.3337V12.1593C14.3337 13.5393 13.207 14.666 11.827 14.666H4.17366C2.79366 14.666 1.66699 13.5393 1.66699 12.1593V7.67269C1.66699 6.29269 2.79366 5.16602 4.17366 5.16602H11.827C13.207 5.16602 14.3337 6.29269 14.3337 7.67269V8.63269H12.987C12.6137 8.63269 12.2737 8.77934 12.027 9.03267Z"
                                            stroke="#A3ADC2" stroke-width="1.5" stroke-linecap="round"
                                            stroke-linejoin="round"></path>
                                        <path
                                            d="M1.66699 8.27288V5.22625C1.66699 4.43291 2.15366 3.72622 2.89366 3.44622L8.18699 1.44622C9.01366 1.13289 9.90033 1.74624 9.90033 2.6329V5.16623"
                                            stroke="#A3ADC2" stroke-width="1.5" stroke-linecap="round"
                                            stroke-linejoin="round"></path>
                                        <path
                                            d="M15.0395 9.31278V10.6862C15.0395 11.0528 14.7462 11.3528 14.3729 11.3661H13.0662C12.3462 11.3661 11.6862 10.8395 11.6262 10.1195C11.5862 9.69947 11.7462 9.30613 12.0262 9.0328C12.2729 8.77946 12.6129 8.63281 12.9862 8.63281H14.3729C14.7462 8.64615 15.0395 8.94612 15.0395 9.31278Z"
                                            stroke="#A3ADC2" stroke-width="1.5" stroke-linecap="round"
                                            stroke-linejoin="round"></path>
                                        <path d="M4.66699 8H9.33366" stroke="#A3ADC2" stroke-width="1.5"
                                            stroke-linecap="round" stroke-linejoin="round"></path>
                                    </svg>

                                    <span>Accounts</span>

                                </a>

                            </li>

                            <li class="dash_nItem">

                                <a href="payments" class="dash_nlink<?= (($target == 'payments') ? ' active' : '') . (($userType == 'THIRD PARTY') ? ' inaccessible' : ''); ?>">

                                    <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                        xmlns="http://www.w3.org/2000/svg" class="icon">
                                        <path
                                            d="M8.67367 1.94687L12.607 3.69354C13.7403 4.19354 13.7403 5.02021 12.607 5.52021L8.67367 7.26687C8.22701 7.46687 7.49367 7.46687 7.04701 7.26687L3.11367 5.52021C1.98034 5.02021 1.98034 4.19354 3.11367 3.69354L7.04701 1.94687C7.49367 1.74688 8.22701 1.74688 8.67367 1.94687Z"
                                            stroke="#A3ADC2" stroke-width="1.5" stroke-linecap="round"
                                            stroke-linejoin="round"></path>
                                        <path
                                            d="M2 7.33398C2 7.89398 2.42 8.54065 2.93333 8.76732L7.46 10.7807C7.80667 10.934 8.2 10.934 8.54 10.7807L13.0667 8.76732C13.58 8.54065 14 7.89398 14 7.33398"
                                            stroke="#A3ADC2" stroke-width="1.5" stroke-linecap="round"
                                            stroke-linejoin="round"></path>
                                        <path
                                            d="M2 10.666C2 11.286 2.36667 11.846 2.93333 12.0993L7.46 14.1127C7.80667 14.266 8.2 14.266 8.54 14.1127L13.0667 12.0993C13.6333 11.846 14 11.286 14 10.666"
                                            stroke="#A3ADC2" stroke-width="1.5" stroke-linecap="round"
                                            stroke-linejoin="round"></path>
                                    </svg>

                                    <span>Payments</span>

                                </a>

                            </li>

                            <li class="dash_nItem">

                                <a iQ-target="#addFunds" class="dash_nlink">

                                    <svg class="icon" width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M2 8H14" stroke="#A3ADC2" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                        <path d="M8 14V2" stroke="#A3ADC2" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                    </svg>

                                    <span>Deposit</span>

                                </a>

                            </li>

                            <li class="dash_nItem">

                                <a<?= ($currentUserStatus != 'TRANSFER DISABLED' && $currentUserStatus != 'INACTIVE') ? ' iQ-target="#sendFunds"' : null ?> class="dash_nlink<?= ($currentUserStatus == 'TRANSFER DISABLED' || $currentUserStatus == 'INACTIVE') ? ' inaccessible' : null ?>">

                                    <svg class="icon" width="17" height="16" viewBox="0 0 17 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M13.5002 3L4.16684 12.3333" stroke="#A3ADC2" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path>
                                        <path d="M6.6535 3L13.5002 3V9.84667" stroke="#A3ADC2" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path>
                                    </svg>

                                    <span>Withdraw <sup class="label"><?= (($currentUserStatus == 'INACTIVE') ? 'Inactive' : null) . (($currentUserStatus == 'TRANSFER DISABLED') ? 'Disabled' : null) . (($currentUserStatus != 'TRANSFER DISABLED' && $currentUserStatus != 'INACTIVE') ? 'Transfer' : null) ?></sup></span>

                                </a>

                            </li>

                            <?php
                            
                                if ($userAccounts && count($userAccounts) > 1 && $userType != 'THIRD PARTY') { ?>

                                    <li class="dash_nItem">

                                        <a iQ-target="#convFunds" class="dash_nlink">

                                            <svg width="17" height="16" viewBox="0 0 17 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path d="M12.02 6.96635L14.5 4.48633L12.02 2.00635" stroke="#A3ADC2" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                                <path d="M2.5 4.48633L14.5 4.48633" stroke="#A3ADC2" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                                <path d="M4.97998 9.0332L2.5 11.5132L4.97998 13.9932" stroke="#A3ADC2" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                                <path d="M14.5 11.5127L2.5 11.5127" stroke="#A3ADC2" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                            </svg>

                                            <span>Exchange <sup class="label blue" style="font-size: 0.5rem;">exchangerate-api</sup></span>

                                        </a>

                                    </li>

                                <?php }

                            ?>

                            <li class="dash_nItem">

                                <a href="loans" class="dash_nlink<?= ($target == 'loans') ? ' active' : '' . (($userType == 'THIRD PARTY') ? ' inaccessible' : ''); ?>">

                                    <svg class="icon" xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
                                        <path d="M4.05999 8.85335H6.11999V13.6533C6.11999 14.7733 6.72665 15 7.46665 14.16L12.5133 8.42668C13.1333 7.72668 12.8733 7.14668 11.9333 7.14668H9.87332V2.34668C9.87332 1.22668 9.26665 1.00001 8.52665 1.84001L3.47999 7.57335C2.86665 8.28001 3.12665 8.85335 4.05999 8.85335Z" stroke="#A3ADC2" stroke-width="1.2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path>
                                    </svg>

                                    <span>Loans <sup style="font-size: 0.6rem; padding: 0.3em 0.5em; color: var(--pg-red); background-color: rgba(238, 49, 43, 0.2); border-radius: 8em;">New</sup></span>

                                </a>

                            </li>

                            <li class="dash_nItem">

                                <a href="investments" class="dash_nlink<?= ($target == 'investments') ? ' active' : '' . (($userType == 'THIRD PARTY') ? ' inaccessible' : ''); ?>">

                                    <svg class="icon" width="16" height="16" viewBox="0 0 33 32" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M11.924 23.071C10.5098 27.3137 4.85291 27.3137 4.85291 27.3137C4.85291 27.3137 4.8529 21.6568 9.09555 20.2426" stroke="#A3ADC2" stroke-width="2.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path>
                                        <path d="M24.6519 13.1716L16.1666 21.6569L10.5098 16L18.995 7.51472C22.2081 4.3017 25.4211 4.33305 26.7913 4.53749C27.0023 4.56894 27.1976 4.66733 27.3485 4.81817C27.4993 4.969 27.5977 5.1643 27.6291 5.37527C27.8336 6.74554 27.8649 9.95856 24.6519 13.1716Z" stroke="#A3ADC2" stroke-width="2.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path>
                                        <path d="M23.2377 14.5858V22.6569C23.2377 22.7882 23.2118 22.9182 23.1616 23.0396C23.1113 23.1609 23.0377 23.2711 22.9448 23.364L18.9021 27.4067C18.7741 27.5347 18.6138 27.6255 18.4382 27.6696C18.2626 27.7136 18.0784 27.7091 17.9052 27.6567C17.732 27.6042 17.5762 27.5058 17.4545 27.3717C17.3329 27.2377 17.2499 27.0732 17.2144 26.8957L16.1666 21.6569" stroke="#A3ADC2" stroke-width="2.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path>
                                        <path d="M17.5808 8.92896H9.50976C9.37844 8.92895 9.2484 8.95482 9.12708 9.00508C9.00575 9.05533 8.89551 9.12899 8.80265 9.22185L4.75993 13.2646C4.63195 13.3926 4.5411 13.5529 4.49707 13.7284C4.45305 13.904 4.4575 14.0882 4.50995 14.2615C4.5624 14.4347 4.66088 14.5904 4.7949 14.7121C4.92892 14.8338 5.09344 14.9168 5.27093 14.9523L10.5098 16" stroke="#A3ADC2" stroke-width="2.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path>
                                    </svg>

                                    <span>Investments <sup style="font-size: 0.6rem; padding: 0.3em 0.5em; color: var(--pg-red); background-color: rgba(238, 49, 43, 0.2); border-radius: 8em;">New</sup></span>

                                </a>

                            </li>

                            <li class="dash_nItem">

                                <a href="transactions" class="dash_nlink<?= ($target == 'transactions') ? ' active' : ''; ?>">

                                    <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                        xmlns="http://www.w3.org/2000/svg" class="icon">
                                        <path
                                            d="M5.99967 14.6673H9.99967C13.333 14.6673 14.6663 13.334 14.6663 10.0007V6.00065C14.6663 2.66732 13.333 1.33398 9.99967 1.33398H5.99967C2.66634 1.33398 1.33301 2.66732 1.33301 6.00065V10.0007C1.33301 13.334 2.66634 14.6673 5.99967 14.6673Z"
                                            stroke="#A3ADC2" stroke-width="1.5" stroke-linecap="round"
                                            stroke-linejoin="round"></path>
                                        <path
                                            d="M4.88672 9.65984L6.47339 7.59984C6.70005 7.30651 7.12005 7.25318 7.41339 7.47984L8.63339 8.43984C8.92672 8.66651 9.34672 8.61318 9.57339 8.32651L11.1134 6.33984"
                                            stroke="#A3ADC2" stroke-width="1.5" stroke-linecap="round"
                                            stroke-linejoin="round"></path>
                                    </svg>

                                    <span>Transactions</span>

                                </a>

                            </li>

                            <?php
                            
                                if ($jointAccounts && $userType !== 'THIRD PARTY') { ?>

                                    <li class="dash_nItem">

                                        <a href="joint-users" class="dash_nlink<?= ($target == 'joint-users') ? ' active' : ''; ?>">

                                            <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg" class="icon"><path d="M6.10668 7.24683C6.04001 7.24016 5.96001 7.24016 5.88668 7.24683C4.30001 7.1935 3.04001 5.8935 3.04001 4.2935C3.04001 2.66016 4.36001 1.3335 6.00001 1.3335C7.63334 1.3335 8.96001 2.66016 8.96001 4.2935C8.95334 5.8935 7.69334 7.1935 6.10668 7.24683Z" stroke="#A3ADC2" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path><path d="M10.94 2.6665C12.2333 2.6665 13.2733 3.71317 13.2733 4.99984C13.2733 6.25984 12.2733 7.2865 11.0267 7.33317C10.9733 7.3265 10.9133 7.3265 10.8533 7.33317" stroke="#A3ADC2" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path><path d="M2.77332 9.7065C1.15999 10.7865 1.15999 12.5465 2.77332 13.6198C4.60666 14.8465 7.61332 14.8465 9.44666 13.6198C11.06 12.5398 11.06 10.7798 9.44666 9.7065C7.61999 8.4865 4.61332 8.4865 2.77332 9.7065Z" stroke="#A3ADC2" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path><path d="M12.2267 13.3335C12.7067 13.2335 13.16 13.0402 13.5333 12.7535C14.5733 11.9735 14.5733 10.6868 13.5333 9.90683C13.1667 9.62683 12.72 9.44016 12.2467 9.3335" stroke="#A3ADC2" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path></svg>

                                            <span>Joint Holders <sup class="label lime">Third-party</sup></span>

                                        </a>

                                    </li>

                                <?php }
                            
                            ?>

                            <li class="dash_nItem">

                                <a href="cards" class="dash_nlink<?= ($target == 'cards') ? ' active' : '' . (($userType == 'THIRD PARTY') ? ' inaccessible' : ''); ?>">

                                    <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                        xmlns="http://www.w3.org/2000/svg" class="icon">
                                        <path d="M1.33301 5.66992H14.6663" stroke="#A3ADC2" stroke-width="1.5"
                                            stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path>
                                        <path d="M4 11.0039H5.33333" stroke="#A3ADC2" stroke-width="1.5"
                                            stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path>
                                        <path d="M7 11.0039H9.66667" stroke="#A3ADC2" stroke-width="1.5"
                                            stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path>
                                        <path
                                            d="M4.29301 2.33594H11.6997C14.073 2.33594 14.6663 2.9226 14.6663 5.2626V10.7359C14.6663 13.0759 14.073 13.6626 11.7063 13.6626H4.29301C1.92634 13.6693 1.33301 13.0826 1.33301 10.7426V5.2626C1.33301 2.9226 1.92634 2.33594 4.29301 2.33594Z"
                                            stroke="#A3ADC2" stroke-width="1.5" stroke-linecap="round"
                                            stroke-linejoin="round"></path>
                                    </svg>

                                    <span>Virtual Cards</span>

                                </a>

                            </li>

                            <li class="dash_nItem">

                                <a href="reports-statements" class="dash_nlink<?= ($target == 'reports-statements') ? ' active' : '' . (($userType == 'THIRD PARTY') ? ' inaccessible' : ''); ?>">

                                    <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                        xmlns="http://www.w3.org/2000/svg" class="icon">
                                        <path
                                            d="M14.667 4.00065V5.61398C14.667 6.66732 14.0003 7.33398 12.947 7.33398H10.667V2.67398C10.667 1.93398 11.2737 1.33398 12.0137 1.33398C12.7403 1.34065 13.407 1.63398 13.887 2.11398C14.367 2.60065 14.667 3.26732 14.667 4.00065Z"
                                            stroke="#A3ADC2" stroke-width="1.5" stroke-miterlimit="10"
                                            stroke-linecap="round" stroke-linejoin="round"></path>
                                        <path
                                            d="M1.33301 4.66732V14.0007C1.33301 14.554 1.95966 14.8673 2.39966 14.534L3.53967 13.6807C3.80634 13.4807 4.17968 13.5073 4.41968 13.7473L5.52633 14.8607C5.78633 15.1207 6.21302 15.1207 6.47302 14.8607L7.59302 13.7407C7.82635 13.5073 8.19968 13.4807 8.45968 13.6807L9.59969 14.534C10.0397 14.8607 10.6663 14.5473 10.6663 14.0007V2.66732C10.6663 1.93398 11.2663 1.33398 11.9997 1.33398H4.66634H3.99967C1.99967 1.33398 1.33301 2.52732 1.33301 4.00065V4.66732Z"
                                            stroke="#A3ADC2" stroke-width="1.5" stroke-miterlimit="10"
                                            stroke-linecap="round" stroke-linejoin="round"></path>
                                        <path d="M4 6H8" stroke="#A3ADC2" stroke-width="1.5" stroke-linecap="round"
                                            stroke-linejoin="round"></path>
                                        <path d="M4.5 8.66602H7.5" stroke="#A3ADC2" stroke-width="1.5"
                                            stroke-linecap="round" stroke-linejoin="round"></path>
                                    </svg>

                                    <span>Report & Statements</span>

                                </a>

                            </li>

                            <li class="dash_nItem">

                                <a href="support-tickets" class="dash_nlink<?= ($target == 'support-tickets') ? ' active' : ''; ?>">

                                    <svg class="icon" version="1.1" viewBox="0 0 1024 1024">
                                        <path d="M802.9 169.9c73.3 0 132.7 59.4 132.7 132.6l0 387.5c0 73.3-59.4 132.7-132.7 132.7l-178.8-0.1-53.8 67.5c-24.2 30.3-67.2 36.7-99 15.9l-5.8-4.2c-4.3-3.5-8.3-7.4-11.8-11.7l-53.9-67.5-178.7 0.1c-70.6 0-128.4-55.2-132.4-124.9l-0.3-7.8 0-387.5c0-73.3 59.4-132.7 132.7-132.6z m0 79.1l-581.8 0c-29.6 0-53.5 24-53.5 53.5l0 387.5c0 29.6 24 53.5 53.5 53.6l216.8 0 74.1 92.6 74.1-92.6 216.8 0c29.6 0 53.5-24 53.5-53.6l0-387.5c0-29.6-24-53.5-53.5-53.5z m-290.9 193.2c32.6 0 59.1 26.4 59.1 59.1 0 32.6-26.4 59.1-59.1 59-32.6 0-59.1-26.4-59.1-59 0-32.6 26.4-59.1 59.1-59.1z m-196.9 0c32.6 0 59.1 26.4 59.1 59.1 0 32.6-26.4 59.1-59.1 59-32.6 0-59.1-26.4-59.1-59 0-32.6 26.4-59.1 59.1-59.1z m393.8 0c32.6 0 59.1 26.4 59.1 59.1 0 32.6-26.4 59.1-59.1 59-32.6 0-59.1-26.4-59.1-59 0-32.6 26.4-59.1 59.1-59.1z" fill="#A3ADC2" stroke="none" stroke-width="46.54545454545455"></path>
                                    </svg>

                                    <span>Support Tickets</span>

                                </a>

                            </li>

                        </ul>

                    </div>

                    <a id="theme" class="iQ_theme theme_btn">

                        <svg role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">

                            <path fill="currentColor"
                                d="M12 6a6 6 0 106 6 6 6 0 00-6-6zm0 11V7a5 5 0 010 10zM12 23.5a.5.5 0 01-.5-.5v-3a.5.5 0 011 0v3a.5.5 0 01-.5.5zM12 4.5a.5.5 0 01-.5-.5V1a.5.5 0 011 0v3a.5.5 0 01-.5.5zM23 12.5h-3a.5.5 0 010-1h3a.5.5 0 010 1zM4 12.5H1a.5.5 0 010-1h3a.5.5 0 010 1zM19.78 20.28a.51.51 0 01-.36-.15L17.3 18a.5.5 0 01.7-.7l2.12 2.12a.5.5 0 010 .71.49.49 0 01-.34.15zM6.34 6.84A.52.52 0 016 6.7L3.87 4.58a.5.5 0 11.71-.71L6.7 6a.51.51 0 010 .71.54.54 0 01-.36.13zM4.22 20.28a.49.49 0 01-.35-.15.5.5 0 010-.71L6 17.3a.5.5 0 11.7.7l-2.12 2.13a.51.51 0 01-.36.15zM17.66 6.84a.54.54 0 01-.36-.14.51.51 0 010-.71l2.12-2.12a.5.5 0 01.71.71L18 6.7a.52.52 0 01-.34.14z">
                            </path>

                        </svg>

                        <span class="theme_indicator lmde active">Lightmode</span>

                        <span class="theme_indicator dmde">Darkmode</span>

                    </a>

                </nav>

            </div>

            <!-- Mobile Menu -->

            <div id="mobile-appMenu" class="noScrollBar">

                <div class="maximizer">

                    <div class="maximizer_device" id="maximizer">

                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 32" version="1.1">
                            <path d="M8 15h7v-7h-7v7zM17 8v7h7v-7h-7zM17 24h7v-7h-7v7zM8 24h7v-7h-7v7z"></path>
                        </svg>

                    </div>

                </div>

                <div class="appMenu">

                    <div class="appMenu_item<?= ($target === 'home' || $target === '') ? ' active' : '' ?>">

                        <a class="appMenu_link" href="home">

                            <div class="icon noStroke">

                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M12.614 4.24434C12.2529 3.96348 11.7472 3.96348 11.3861 4.24434L4.38608 9.68878C4.14085 9.87952 4.00002 10.1678 4.00002 10.4743L4 19.0031C4 19.5533 4.44566 20 5 20H8.00003V15C8.00003 13.3431 9.34317 12 11 12H13C14.6569 12 16 13.3431 16 15V20H19C19.552 20 20 19.5521 20 18.9995V10.4791C20 10.17 19.8572 9.87793 19.614 9.68878L12.614 4.24434ZM14 20V15C14 14.4477 13.5523 14 13 14H11C10.4477 14 10 14.4477 10 15V20H14ZM5 22C3.3452 22 1.99999 20.662 2 19.0031L2.00002 10.4743C2.00002 9.54647 2.42909 8.67717 3.1582 8.11008L10.1582 2.66563C11.2415 1.82304 12.7585 1.82304 13.8418 2.66564L20.8418 8.11008C21.573 8.67876 22 9.55379 22 10.4791V18.9995C22 20.6561 20.6572 22 19 22H5Z" fill="currentColor"></path>
                                </svg>

                            </div>

                            <span class="appMenu_title">Home</span>

                        </a>

                    </div>

                    <div class="appMenu_item">

                        <a class="appMenu_link" iQ-target="#addFunds">

                            <div class="icon">

                                <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M2 8H14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                    <path d="M8 14V2" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                </svg>

                            </div>

                            <span class="appMenu_title">Deposit</span>

                        </a>

                    </div>

                    <div class="appMenu_item<?= ($target === 'accounts') ? ' active' : '' ?>">

                        <a class="appMenu_link" href="accounts">

                            <div class="icon">

                                <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg" class="icon">
                                    <path d="M12.027 9.03267C11.747 9.30601 11.587 9.69934 11.627 10.1193C11.687 10.8393 12.347 11.366 13.067 11.366H14.3337V12.1593C14.3337 13.5393 13.207 14.666 11.827 14.666H4.17366C2.79366 14.666 1.66699 13.5393 1.66699 12.1593V7.67269C1.66699 6.29269 2.79366 5.16602 4.17366 5.16602H11.827C13.207 5.16602 14.3337 6.29269 14.3337 7.67269V8.63269H12.987C12.6137 8.63269 12.2737 8.77934 12.027 9.03267Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                    <path d="M1.66699 8.27288V5.22625C1.66699 4.43291 2.15366 3.72622 2.89366 3.44622L8.18699 1.44622C9.01366 1.13289 9.90033 1.74624 9.90033 2.6329V5.16623" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                    <path d="M15.0395 9.31278V10.6862C15.0395 11.0528 14.7462 11.3528 14.3729 11.3661H13.0662C12.3462 11.3661 11.6862 10.8395 11.6262 10.1195C11.5862 9.69947 11.7462 9.30613 12.0262 9.0328C12.2729 8.77946 12.6129 8.63281 12.9862 8.63281H14.3729C14.7462 8.64615 15.0395 8.94612 15.0395 9.31278Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                    <path d="M4.66699 8H9.33366" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                </svg>

                            </div>

                            <span class="appMenu_title">Accounts</span>

                        </a>

                    </div>

                    <div class="appMenu_item">

                        <a class="appMenu_link notification-toggle">

                            <div class="icon noStroke">

                                <svg role="img" aria-hidden="false" xmlns="http://www.w3.org/2000/svg" width="100%" height="100%" fill="none" viewBox="0 0 20 20" aria-labelledby="NotificationIcon-9">
                                    <path fill="currentColor" fill-rule="evenodd" d="M6.96 4.61C7.778 3.7 8.874 3.202 10 3.202c1.128 0 2.223.498 3.042 1.408.82.913 1.29 2.163 1.29 3.478v5.54H5.67v-5.54c0-1.315.47-2.565 1.29-3.478zm8.573 3.478v5.54h1.409v1.2H3.06v-1.2h1.409v-5.54c0-1.594.569-3.135 1.598-4.28C7.1 2.661 8.512 2.002 10.001 2.002c1.489 0 2.902.659 3.933 1.806 1.03 1.145 1.599 2.686 1.599 4.28zm-7.717 8.71v1.2h4.37v-1.2h-4.37z" clip-rule="evenodd"></path>
                                </svg>

                                <?php

                                    if ($unreadNotf > 0) {

                                        echo '<sup class="label notf-counter" translate="no">' . shortenNumber($unreadNotf) . '</sup>';

                                    }  
                                    
                                ?>

                            </div>

                            <span class="appMenu_title">Notifications</span>

                        </a>

                    </div>

                    <?php

                        if ($userAccounts && count($userAccounts) > 1 && $userType != 'THIRD PARTY') { ?>

                            <div class="appMenu_item">

                                <a class="appMenu_link" iQ-target="#convFunds">

                                    <div class="icon">

                                        <svg width="17" height="16" viewBox="0 0 17 16" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M12.02 6.96635L14.5 4.48633L12.02 2.00635" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"></path><path d="M2.5 4.48633L14.5 4.48633" stroke="#2D3443" stroke-linecap="round" stroke-linejoin="round"></path><path d="M4.97998 9.0332L2.5 11.5132L4.97998 13.9932" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"></path><path d="M14.5 11.5127L2.5 11.5127" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"></path></svg>

                                    </div>

                                    <span class="appMenu_title">Swap</span>

                                </a>

                            </div>

                        <?php } 
                        
                    ?>    

                    <div class="appMenu_item">

                        <a class="appMenu_link iQ_theme">

                            <div class="icon noStroke">

                                <svg role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">

                                    <path fill="currentColor"
                                        d="M12 6a6 6 0 106 6 6 6 0 00-6-6zm0 11V7a5 5 0 010 10zM12 23.5a.5.5 0 01-.5-.5v-3a.5.5 0 011 0v3a.5.5 0 01-.5.5zM12 4.5a.5.5 0 01-.5-.5V1a.5.5 0 011 0v3a.5.5 0 01-.5.5zM23 12.5h-3a.5.5 0 010-1h3a.5.5 0 010 1zM4 12.5H1a.5.5 0 010-1h3a.5.5 0 010 1zM19.78 20.28a.51.51 0 01-.36-.15L17.3 18a.5.5 0 01.7-.7l2.12 2.12a.5.5 0 010 .71.49.49 0 01-.34.15zM6.34 6.84A.52.52 0 016 6.7L3.87 4.58a.5.5 0 11.71-.71L6.7 6a.51.51 0 010 .71.54.54 0 01-.36.13zM4.22 20.28a.49.49 0 01-.35-.15.5.5 0 010-.71L6 17.3a.5.5 0 11.7.7l-2.12 2.13a.51.51 0 01-.36.15zM17.66 6.84a.54.54 0 01-.36-.14.51.51 0 010-.71l2.12-2.12a.5.5 0 01.71.71L18 6.7a.52.52 0 01-.34.14z">
                                    </path>

                                </svg>

                            </div>

                            <span class="appMenu_title">Theme</span>

                        </a>

                    </div>

                    <div class="appMenu_item<?= ($target === 'investments') ? ' active' : '' ?>">

                        <a class="appMenu_link<?= (($userType == 'THIRD PARTY') ? ' inaccessible' : '') ?>"<?= ($userType == 'THIRD PARTY') ? null : ' href="investments"' ?>>

                            <div class="icon">

                                <svg width="16" height="16" viewBox="0 0 33 32" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M11.924 23.071C10.5098 27.3137 4.85291 27.3137 4.85291 27.3137C4.85291 27.3137 4.8529 21.6568 9.09555 20.2426" stroke="currentColor" stroke-width="2.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path>
                                    <path d="M24.6519 13.1716L16.1666 21.6569L10.5098 16L18.995 7.51472C22.2081 4.3017 25.4211 4.33305 26.7913 4.53749C27.0023 4.56894 27.1976 4.66733 27.3485 4.81817C27.4993 4.969 27.5977 5.1643 27.6291 5.37527C27.8336 6.74554 27.8649 9.95856 24.6519 13.1716Z" stroke="currentColor" stroke-width="2.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path>
                                    <path d="M23.2377 14.5858V22.6569C23.2377 22.7882 23.2118 22.9182 23.1616 23.0396C23.1113 23.1609 23.0377 23.2711 22.9448 23.364L18.9021 27.4067C18.7741 27.5347 18.6138 27.6255 18.4382 27.6696C18.2626 27.7136 18.0784 27.7091 17.9052 27.6567C17.732 27.6042 17.5762 27.5058 17.4545 27.3717C17.3329 27.2377 17.2499 27.0732 17.2144 26.8957L16.1666 21.6569" stroke="currentColor" stroke-width="2.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path>
                                    <path d="M17.5808 8.92896H9.50976C9.37844 8.92895 9.2484 8.95482 9.12708 9.00508C9.00575 9.05533 8.89551 9.12899 8.80265 9.22185L4.75993 13.2646C4.63195 13.3926 4.5411 13.5529 4.49707 13.7284C4.45305 13.904 4.4575 14.0882 4.50995 14.2615C4.5624 14.4347 4.66088 14.5904 4.7949 14.7121C4.92892 14.8338 5.09344 14.9168 5.27093 14.9523L10.5098 16" stroke="currentColor" stroke-width="2.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path>
                                </svg>

                            </div>

                            <span class="appMenu_title">Invest</span>

                        </a>

                    </div>

                    <div class="appMenu_item<?= ($target === 'loans') ? ' active' : '' ?>">

                        <a class="appMenu_link<?= (($userType == 'THIRD PARTY') ? ' inaccessible' : '') ?>"<?= $userType == 'THIRD PARTY' ? null : ' href="loans"' ?>>

                            <div class="icon">

                                <svg class="icon" xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
                                    <path d="M4.05999 8.85335H6.11999V13.6533C6.11999 14.7733 6.72665 15 7.46665 14.16L12.5133 8.42668C13.1333 7.72668 12.8733 7.14668 11.9333 7.14668H9.87332V2.34668C9.87332 1.22668 9.26665 1.00001 8.52665 1.84001L3.47999 7.57335C2.86665 8.28001 3.12665 8.85335 4.05999 8.85335Z" stroke="currentColor" stroke-width="1.2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path>
                                </svg>

                            </div>

                            <span class="appMenu_title">Loans</span>

                        </a>

                    </div>

                    <div class="appMenu_item">

                        <a class="appMenu_link"<?= ($currentUserStatus != 'TRANSFER DISABLED' && $currentUserStatus != 'INACTIVE') ? ' iQ-target="#sendFunds"' : 'onclick="return(toast({text: \'Transfers ' . ltrim($currentUserStatus, 'TRANSFER ') . '\', type: \'warning\', duration: 2000}))"' ?>>

                            <div class="icon">

                                <svg class="icon" width="17" height="16" viewBox="0 0 17 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M13.5002 3L4.16684 12.3333" stroke="currentColor" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path>
                                    <path d="M6.6535 3L13.5002 3V9.84667" stroke="currentColor" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path>
                                </svg>

                                <!-- <sup class="label red">Transfer</sup> -->

                            </div>

                            <span class="appMenu_title">Withdraw</span>

                        </a>

                    </div>

                    <?php

                        if ($jointAccounts && $userType !== 'THIRD PARTY') { ?>

                            <div class="appMenu_item<?= ($target === 'joint-users') ? ' active' : '' ?>">

                                <a class="appMenu_link" href="joint-users">

                                    <div class="icon">

                                        <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg" class="icon"><path d="M6.10668 7.24683C6.04001 7.24016 5.96001 7.24016 5.88668 7.24683C4.30001 7.1935 3.04001 5.8935 3.04001 4.2935C3.04001 2.66016 4.36001 1.3335 6.00001 1.3335C7.63334 1.3335 8.96001 2.66016 8.96001 4.2935C8.95334 5.8935 7.69334 7.1935 6.10668 7.24683Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path><path d="M10.94 2.6665C12.2333 2.6665 13.2733 3.71317 13.2733 4.99984C13.2733 6.25984 12.2733 7.2865 11.0267 7.33317C10.9733 7.3265 10.9133 7.3265 10.8533 7.33317" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path><path d="M2.77332 9.7065C1.15999 10.7865 1.15999 12.5465 2.77332 13.6198C4.60666 14.8465 7.61332 14.8465 9.44666 13.6198C11.06 12.5398 11.06 10.7798 9.44666 9.7065C7.61999 8.4865 4.61332 8.4865 2.77332 9.7065Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path><path d="M12.2267 13.3335C12.7067 13.2335 13.16 13.0402 13.5333 12.7535C14.5733 11.9735 14.5733 10.6868 13.5333 9.90683C13.1667 9.62683 12.72 9.44016 12.2467 9.3335" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path></svg>

                                    </div>

                                    <span class="appMenu_title">Joint Holders</span>

                                </a>

                            </div>

                        <?php }

                    ?>

                    <div class="appMenu_item<?= ($target === 'payments') ? ' active' : '' ?>">

                        <a class="appMenu_link<?= (($userType == 'THIRD PARTY') ? ' inaccessible' : '') ?>"<?= ($userType == 'THIRD PARTY') ? null : ' href="payments"' ?>>

                            <div class="icon">

                                <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg" class="icon">
                                    <path d="M8.67367 1.94687L12.607 3.69354C13.7403 4.19354 13.7403 5.02021 12.607 5.52021L8.67367 7.26687C8.22701 7.46687 7.49367 7.46687 7.04701 7.26687L3.11367 5.52021C1.98034 5.02021 1.98034 4.19354 3.11367 3.69354L7.04701 1.94687C7.49367 1.74688 8.22701 1.74688 8.67367 1.94687Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                    <path d="M2 7.33398C2 7.89398 2.42 8.54065 2.93333 8.76732L7.46 10.7807C7.80667 10.934 8.2 10.934 8.54 10.7807L13.0667 8.76732C13.58 8.54065 14 7.89398 14 7.33398" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                    <path d="M2 10.666C2 11.286 2.36667 11.846 2.93333 12.0993L7.46 14.1127C7.80667 14.266 8.2 14.266 8.54 14.1127L13.0667 12.0993C13.6333 11.846 14 11.286 14 10.666" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                </svg>

                            </div>

                            <span class="appMenu_title">Payments</span>

                        </a>

                    </div>

                    <div class="appMenu_item<?= ($target === 'transactions') ? ' active' : '' ?>">

                        <a class="appMenu_link" href="transactions">

                            <div class="icon">

                                <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg" class="icon">
                                    <path d="M5.99967 14.6673H9.99967C13.333 14.6673 14.6663 13.334 14.6663 10.0007V6.00065C14.6663 2.66732 13.333 1.33398 9.99967 1.33398H5.99967C2.66634 1.33398 1.33301 2.66732 1.33301 6.00065V10.0007C1.33301 13.334 2.66634 14.6673 5.99967 14.6673Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                    <path d="M4.88672 9.65984L6.47339 7.59984C6.70005 7.30651 7.12005 7.25318 7.41339 7.47984L8.63339 8.43984C8.92672 8.66651 9.34672 8.61318 9.57339 8.32651L11.1134 6.33984" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                </svg>

                            </div>

                            <span class="appMenu_title">Transactions</span>

                        </a>

                    </div>

                    <div class="appMenu_item<?= ($target === 'cards') ? ' active' : '' ?>">

                        <a class="appMenu_link<?= (($userType == 'THIRD PARTY') ? ' inaccessible' : '') ?>"<?= $userType == 'THIRD PARTY' ? null : ' href="cards"' ?>>

                            <div class="icon">

                                <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M1.33301 5.66992H14.6663" stroke="currentColor" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path>
                                    <path d="M4 11.0039H5.33333" stroke="currentColor" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path>
                                    <path d="M7 11.0039H9.66667" stroke="currentColor" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path>
                                    <path d="M4.29301 2.33594H11.6997C14.073 2.33594 14.6663 2.9226 14.6663 5.2626V10.7359C14.6663 13.0759 14.073 13.6626 11.7063 13.6626H4.29301C1.92634 13.6693 1.33301 13.0826 1.33301 10.7426V5.2626C1.33301 2.9226 1.92634 2.33594 4.29301 2.33594Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                </svg>

                            </div>

                            <span class="appMenu_title">Cards</span>

                        </a>

                    </div>

                    <div class="appMenu_item<?= ($target === 'support-tickets') ? ' active' : '' ?>">

                        <a class="appMenu_link" href="support-tickets">

                            <div class="icon noStroke">

                                <svg version="1.1" viewBox="0 0 1024 1024">
                                    <path d="M802.9 169.9c73.3 0 132.7 59.4 132.7 132.6l0 387.5c0 73.3-59.4 132.7-132.7 132.7l-178.8-0.1-53.8 67.5c-24.2 30.3-67.2 36.7-99 15.9l-5.8-4.2c-4.3-3.5-8.3-7.4-11.8-11.7l-53.9-67.5-178.7 0.1c-70.6 0-128.4-55.2-132.4-124.9l-0.3-7.8 0-387.5c0-73.3 59.4-132.7 132.7-132.6z m0 79.1l-581.8 0c-29.6 0-53.5 24-53.5 53.5l0 387.5c0 29.6 24 53.5 53.5 53.6l216.8 0 74.1 92.6 74.1-92.6 216.8 0c29.6 0 53.5-24 53.5-53.6l0-387.5c0-29.6-24-53.5-53.5-53.5z m-290.9 193.2c32.6 0 59.1 26.4 59.1 59.1 0 32.6-26.4 59.1-59.1 59-32.6 0-59.1-26.4-59.1-59 0-32.6 26.4-59.1 59.1-59.1z m-196.9 0c32.6 0 59.1 26.4 59.1 59.1 0 32.6-26.4 59.1-59.1 59-32.6 0-59.1-26.4-59.1-59 0-32.6 26.4-59.1 59.1-59.1z m393.8 0c32.6 0 59.1 26.4 59.1 59.1 0 32.6-26.4 59.1-59.1 59-32.6 0-59.1-26.4-59.1-59 0-32.6 26.4-59.1 59.1-59.1z" fill="currentColor" stroke="none" stroke-width="46.54545454545455"></path>
                                </svg>

                            </div>

                            <span class="appMenu_title">Support</span>

                        </a>

                    </div>

                    <div class="appMenu_item<?= ($target === 'reports-statements') ? ' active' : '' ?>">

                        <a class="appMenu_link<?= (($userType == 'THIRD PARTY') ? ' inaccessible' : '') ?>"<?= $userType == 'THIRD PARTY' ? null : ' href="reports-statements"' ?>>

                            <div class="icon">

                                <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M14.667 4.00065V5.61398C14.667 6.66732 14.0003 7.33398 12.947 7.33398H10.667V2.67398C10.667 1.93398 11.2737 1.33398 12.0137 1.33398C12.7403 1.34065 13.407 1.63398 13.887 2.11398C14.367 2.60065 14.667 3.26732 14.667 4.00065Z" stroke="currentColor" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path>
                                    <path d="M1.33301 4.66732V14.0007C1.33301 14.554 1.95966 14.8673 2.39966 14.534L3.53967 13.6807C3.80634 13.4807 4.17968 13.5073 4.41968 13.7473L5.52633 14.8607C5.78633 15.1207 6.21302 15.1207 6.47302 14.8607L7.59302 13.7407C7.82635 13.5073 8.19968 13.4807 8.45968 13.6807L9.59969 14.534C10.0397 14.8607 10.6663 14.5473 10.6663 14.0007V2.66732C10.6663 1.93398 11.2663 1.33398 11.9997 1.33398H4.66634H3.99967C1.99967 1.33398 1.33301 2.52732 1.33301 4.00065V4.66732Z" stroke="currentColor" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path>
                                    <path d="M4 6H8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                    <path d="M4.5 8.66602H7.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                </svg>

                            </div>

                            <span class="appMenu_title">Reports & Statements</span>

                        </a>

                    </div>

                    <?php

                        if ($userAccounts && count($userAccounts) > 1 && $userType != 'THIRD PARTY') { ?>

                            <div class="appMenu_item">

                                <a class="appMenu_link" iQ-target="#convFunds">

                                    <div class="icon">

                                        <svg width="17" height="16" viewBox="0 0 17 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M12.02 6.96635L14.5 4.48633L12.02 2.00635" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"></path>
                                            <path d="M2.5 4.48633L14.5 4.48633" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"></path>
                                            <path d="M4.97998 9.0332L2.5 11.5132L4.97998 13.9932" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"></path>
                                            <path d="M14.5 11.5127L2.5 11.5127" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"></path>
                                        </svg>

                                    </div>

                                    <span class="appMenu_title">Swap</span>

                                </a>

                            </div>

                        <?php }
                     
                    ?>
                        
                    <div class="appMenu_item<?= ($target === 'profile') ? ' active' : '' ?>">

                        <a class="appMenu_link<?= (($userType == 'THIRD PARTY') ? ' inaccessible' : '') ?>"<?= $userType == 'THIRD PARTY' ? null : ' href="profile"' ?>>

                            <div class="icon">

                                <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M8.10573 7.24666C8.03906 7.24 7.95906 7.24 7.88573 7.24666C6.29906 7.19333 5.03906 5.89333 5.03906 4.29333C5.03906 2.65999 6.35906 1.33333 7.99906 1.33333C9.6324 1.33333 10.9591 2.65999 10.9591 4.29333C10.9524 5.89333 9.6924 7.19333 8.10573 7.24666Z" stroke="#8592AD" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                    <path d="M4.7725 9.70667C3.15917 10.7867 3.15917 12.5467 4.7725 13.62C6.60583 14.8467 9.6125 14.8467 11.4458 13.62C13.0592 12.54 13.0592 10.78 11.4458 9.70667C9.61917 8.48667 6.6125 8.48667 4.7725 9.70667Z" stroke="#8592AD" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                </svg>

                            </div>

                            <span class="appMenu_title">Profile</span>

                        </a>

                    </div>

                    <div class="appMenu_item<?= ($target === 'settings') ? ' active' : '' ?>">

                        <a class="appMenu_link<?= (($userType == 'THIRD PARTY') ? ' inaccessible' : '') ?>"<?= $userType == 'THIRD PARTY' ? null : ' href="settings"' ?>>

                            <div class="icon">

                                <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M8 10C9.10457 10 10 9.10457 10 8C10 6.89543 9.10457 6 8 6C6.89543 6 6 6.89543 6 8C6 9.10457 6.89543 10 8 10Z" stroke="#2D3443" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path>
                                    <path d="M1.33301 8.5863V7.41297C1.33301 6.71963 1.89967 6.1463 2.59967 6.1463C3.80634 6.1463 4.29967 5.29297 3.69301 4.2463C3.34634 3.6463 3.55301 2.8663 4.15967 2.51963L5.31301 1.85963C5.83967 1.5463 6.51967 1.73297 6.83301 2.25963L6.90634 2.3863C7.50634 3.43297 8.49301 3.43297 9.09967 2.3863L9.17301 2.25963C9.48634 1.73297 10.1663 1.5463 10.693 1.85963L11.8463 2.51963C12.453 2.8663 12.6597 3.6463 12.313 4.2463C11.7063 5.29297 12.1997 6.1463 13.4063 6.1463C14.0997 6.1463 14.673 6.71297 14.673 7.41297V8.5863C14.673 9.27963 14.1063 9.85297 13.4063 9.85297C12.1997 9.85297 11.7063 10.7063 12.313 11.753C12.6597 12.3596 12.453 13.133 11.8463 13.4796L10.693 14.1396C10.1663 14.453 9.48634 14.2663 9.17301 13.7396L9.09967 13.613C8.49967 12.5663 7.51301 12.5663 6.90634 13.613L6.83301 13.7396C6.51967 14.2663 5.83967 14.453 5.31301 14.1396L4.15967 13.4796C3.55301 13.133 3.34634 12.353 3.69301 11.753C4.29967 10.7063 3.80634 9.85297 2.59967 9.85297C1.89967 9.85297 1.33301 9.27963 1.33301 8.5863Z" stroke="#2D3443" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path>
                                </svg>

                            </div>

                            <span class="appMenu_title">Settings</span>

                        </a>

                    </div>

                    <div class="appMenu_item">

                        <a class="appMenu_link<?= (($userType == 'THIRD PARTY') ? ' inaccessible' : '') ?>"<?= $userType == 'THIRD PARTY' ? null : ' href="settings?tab=security"' ?>>

                            <div class="icon">

                                <svg xmlns="http://www.w3.org/2000/svg" height="100%" viewBox="0 0 24 24" width="100%" fill="currentColor" aria-hidden="true">
                                    <path d="M17.81 4.47c-.08 0-.16-.02-.23-.06C15.66 3.42 14 3 12.01 3c-1.98 0-3.86.47-5.57 1.41-.24.13-.54.04-.68-.2-.13-.24-.04-.55.2-.68C7.82 2.52 9.86 2 12.01 2c2.13 0 3.99.47 6.03 1.52.25.13.34.43.21.67-.09.18-.26.28-.44.28zM3.5 9.72c-.1 0-.2-.03-.29-.09-.23-.16-.28-.47-.12-.7.99-1.4 2.25-2.5 3.75-3.27C9.98 4.04 14 4.03 17.15 5.65c1.5.77 2.76 1.86 3.75 3.25.16.22.11.54-.12.7-.23.16-.54.11-.7-.12-.9-1.26-2.04-2.25-3.39-2.94-2.87-1.47-6.54-1.47-9.4.01-1.36.7-2.5 1.7-3.4 2.96-.08.14-.23.21-.39.21zm6.25 12.07c-.13 0-.26-.05-.35-.15-.87-.87-1.34-1.43-2.01-2.64-.69-1.23-1.05-2.73-1.05-4.34 0-2.97 2.54-5.39 5.66-5.39s5.66 2.42 5.66 5.39c0 .28-.22.5-.5.5s-.5-.22-.5-.5c0-2.42-2.09-4.39-4.66-4.39s-4.66 1.97-4.66 4.39c0 1.44.32 2.77.93 3.85.64 1.15 1.08 1.64 1.85 2.42.19.2.19.51 0 .71-.11.1-.24.15-.37.15zm7.17-1.85c-1.19 0-2.24-.3-3.1-.89-1.49-1.01-2.38-2.65-2.38-4.39 0-.28.22-.5.5-.5s.5.22.5.5c0 1.41.72 2.74 1.94 3.56.71.48 1.54.71 2.54.71.24 0 .64-.03 1.04-.1.27-.05.53.13.58.41.05.27-.13.53-.41.58-.57.11-1.07.12-1.21.12zM14.91 22c-.04 0-.09-.01-.13-.02-1.59-.44-2.63-1.03-3.72-2.1-1.4-1.39-2.17-3.24-2.17-5.22 0-1.62 1.38-2.94 3.08-2.94s3.08 1.32 3.08 2.94c0 1.07.93 1.94 2.08 1.94s2.08-.87 2.08-1.94c0-3.77-3.25-6.83-7.25-6.83-2.84 0-5.44 1.58-6.61 4.03-.39.81-.59 1.76-.59 2.8 0 .78.07 2.01.67 3.61.1.26-.03.55-.29.64-.26.1-.55-.04-.64-.29-.49-1.31-.73-2.61-.73-3.96 0-1.2.23-2.29.68-3.24 1.33-2.79 4.28-4.6 7.51-4.6 4.55 0 8.25 3.51 8.25 7.83 0 1.62-1.38 2.94-3.08 2.94s-3.08-1.32-3.08-2.94c0-1.07-.93-1.94-2.08-1.94s-2.08.87-2.08 1.94c0 1.71.66 3.31 1.87 4.51.95.94 1.86 1.46 3.27 1.85.27.07.42.35.35.61-.05.23-.26.38-.47.38z"></path>
                                </svg>

                            </div>

                            <span class="appMenu_title">Security</span>

                        </a>

                    </div>

                    <div class="appMenu_item">

                        <a iQ-target="#iQ-help" class="appMenu_link">

                            <div class="icon">

                                <svg width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg" class="Icon_icon__9oiVm">
                                    <rect x="0.938018" y="5.6525" width="2.1401" height="4.93885" rx="0.918598" stroke="currentColor" stroke-width="1.26446"></rect>
                                    <rect x="11.151" y="5.6525" width="2.1401" height="4.93885" rx="0.918598" stroke="currentColor" stroke-width="1.26446"></rect>
                                    <path d="M12.2222 10.9135V10.9135C12.2222 11.8156 11.4908 12.547 10.5886 12.547H10.066H8.60199" stroke="currentColor" stroke-width="1.26446"></path>
                                    <path d="M2.00775 5.33048V5.33048C2.00775 2.93228 3.95188 0.988159 6.35007 0.988159H7.87911C10.2773 0.988159 12.2214 2.93228 12.2214 5.33048V5.33048" stroke="currentColor" stroke-width="1.26446"></path>
                                    <rect x="5.81753" y="11.8456" width="2.63943" height="1.40296" rx="0.701482" stroke="currentColor" stroke-width="1.26446"></rect>
                                </svg>

                                <sup class="label red">24/7</sup>

                            </div>

                            <span class="appMenu_title">Help</span>

                        </a>

                    </div>

                </div>

                <div class="form_item" style="padding: 1em 0;">

                    <a class="form_btn red iQ-logout">Logout</a>

                </div>

            </div>

            <!-- Notifications -->

            <div id="notification-window" class="n_displ">

                <div class="notification-container">

                    <div class="notification-header">

                        <div>

                            <p class="text-title">Notifications</p>

                            <p class="text-min">All notifications will show here. Most recent first.</p>

                        </div>

                        <div class="close-btn notification-toggle">

                            <svg role="img" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" width="100%" height="100%" viewBox="0 0 20 20" aria-labelledby="CloseIcon-287">
                                <path fill="currentColor" fill-rule="evenodd" d="M15.16 13.514L11.645 10l3.515-3.514a1.165 1.165 0 00-1.646-1.646L10 8.355 6.486 4.84A1.165 1.165 0 004.84 6.486L8.355 10 4.84 13.514a1.165 1.165 0 001.646 1.646L10 11.645l3.514 3.515a1.165 1.165 0 001.646-1.646z"></path>
                            </svg>

                        </div>

                    </div>

                    <div class="notification-body iQ_panels">

                        <div class="notification-tabs">

                            <div class="notification-tab active iQ_panelSwitch">Unread</div>

                            <div id="getRead" class="notification-tab iQ_panelSwitch">Read</div>

                        </div>

                        <div class="iQ_panel">

                            <?php
                            
                                // Display Unread Notification(s)

                                $found = false; // Flag

                                $stmt = mysqli_prepare($conn, "SELECT * FROM `notifications` WHERE `user_id` = ? AND `status` = ? ORDER BY `id` DESC"); // Prepare Statement

                                // Parameter(s)

                                $param = 'UNREAD';

                                mysqli_stmt_bind_param($stmt, "ss", $currentUser, $param); // Bind Parameter(s)

                                mysqli_stmt_execute($stmt); // Execute Statement

                                $result = mysqli_stmt_get_result($stmt); // Get Result

                                if (mysqli_num_rows($result) > 0) {

                                    $found = true; // Update Flag

                                    $data = mysqli_fetch_all($result, MYSQLI_ASSOC); // Fetch Result's Data
                                    
                                }

                                mysqli_free_result($result); // Free Result

                                mysqli_stmt_close($stmt); // Close Statement

                                // Check Flag

                                if ($found) { ?>

                                    <div class="notification-list">

                                        <?php foreach ($data as $row): // Iterate Through Data

                                            $date = $row['date_created'];

                                            $id = $row['notf_id'];

                                            $title = $row['title'];

                                            $msg = $row['message_text']; 
                                            
                                            $msg = (strlen($msg) > 30) ? substr($msg, 0, 30) . '...' : $msg; ?>

                                            <div class="notification-box" iQ-target="#read-notf">

                                                <div class="header">

                                                    <p class="text-title"><?= $title ?></p>

                                                    <div class="flx">

                                                        <p class="time"><?= readableDateDiff($date, 'GMT') ?></p>

                                                        <div class="notf-data">

                                                            <input type="hidden" name="notf-id" value="<?= $id ?>">

                                                            <button value="READ" class="notf-btn read-btn">

                                                                <svg role="img" aria-hidden="true" width="100%" height="100%" viewBox="0 0 20 20" fill="none" aria-labelledby="AcceptIcon-293"><path fill="currentColor" fill-rule="evenodd" clip-rule="evenodd" d="M16.669 6.315c.435.427.442 1.126.016 1.561L9.49 15.22a1.104 1.104 0 01-1.576 0l-3.598-3.663a1.104 1.104 0 111.575-1.546l2.81 2.86 6.407-6.539a1.104 1.104 0 011.56-.016z"></path></svg>

                                                                <span>Mark as read</span>

                                                            </button>

                                                        </div>

                                                    </div>    

                                                </div>

                                                <div class="body">

                                                    <p><?= $msg ?></p>

                                                </div>    

                                            </div>

                                        <?php endforeach; ?>    

                                    </div>

                                <?php }
                            
                            ?>

                        </div>

                        <div id="displayRead" class="iQ_panel n_displ"></div>

                    </div>

                </div>

            </div>

        </aside>

        <main id="dashMain">

            <div class="dash_con">