        <!-- Footer -->
        <footer class="bg-black-950 text-white pt-16 pb-8" id="contact">
            <div class="container mx-auto px-4">
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-12 mb-12">
                    <!-- Column 1 -->
                    <div>
                        <div class="w-[150px] h-[75px] flex items-center justify-center">
                            <img src="<?= SITE_LOGO_DARK ?>"
                                alt="<?= SITE_NAME ?>" class="w-full h-full object-contain">
                        </div>
                        <p class="text-gray-400 mb-6">Modern banking solutions for individuals and businesses. Secure,
                            fast, and designed for the digital age.</p>
                        <div class="flex space-x-4"> <a href="#" class="text-gray-400 hover:text-white transition"> <i
                                    class="fab fa-facebook-f"></i> </a> <a href="#"
                                class="text-gray-400 hover:text-white transition"> <i class="fab fa-twitter"></i> </a>
                            <a href="#" class="text-gray-400 hover:text-white transition"> <i class="fab fa-instagram"></i>
                            </a> <a href="#" class="text-gray-400 hover:text-white transition"> <i
                                    class="fab fa-linkedin-in"></i>
                            </a>
                        </div>
                    </div>
                    <!-- Column 2 -->
                    <div>
                        <h3 class="text-lg font-semibold mb-6">Products</h3>
                        <ul class="space-y-3">
                            <li><i class="fas fa-check-circle text-green-400 mr-2"></i><a class="text-gray-400 hover:text-white transition">Checking Accounts</a></li>
                            <li><i class="fas fa-check-circle text-green-400 mr-2"></i><a class="text-gray-400 hover:text-white transition">Savings Accounts</a></li>
                            <li><i class="fas fa-check-circle text-green-400 mr-2"></i><a class="text-gray-400 hover:text-white transition">Credit Cards</a></li>
                            <li><i class="fas fa-check-circle text-green-400 mr-2"></i><a class="text-gray-400 hover:text-white transition">Personal Loans</a></li>
                            <li><i class="fas fa-check-circle text-green-400 mr-2"></i><a class="text-gray-400 hover:text-white transition">Mortgages</a></li>
                        </ul>
                    </div>
                    <!-- Column 3 -->
                    <div>
                        <h3 class="text-lg font-semibold mb-6">Company</h3>
                        <ul class="space-y-3">
                            <li><a href="about" class="text-gray-400 hover:text-white transition">About Us</a></li>
                            <li><a class="c-info-toggle text-gray-400 hover:text-white transition">Contact</a></li>
                        </ul>
                    </div>
                    <!-- Column 4 -->
                    <div>
                        <h3 class="text-lg font-semibold mb-6">Resources</h3>
                        <ul class="space-y-3">
                            <li><a href="help-center" class="text-gray-400 hover:text-white transition">Help Center</a></li>
                            <li><a href="privacy-policy" class="text-gray-400 hover:text-white transition">Privacy Policy</a></li>
                            <li><a href="terms-conditions" class="text-gray-400 hover:text-white transition">Terms of Service</a></li>
                            <li><a href="fdic-info" class="text-gray-400 hover:text-white transition">FDIC Information</a></li>
                        </ul>
                    </div>
                </div>
                <div class="border-t border-gray-800 pt-8">
                    <div class="flex flex-col md:flex-row justify-between items-center">
                        <p class="text-gray-400 mb-4 md:mb-0">&copy; <?= date('Y') . ' ' . SITE_NAME ?>. All rights reserved.</p>
                        <div class="flex space-x-6"> <a href="privacy-policy"
                                class="text-gray-400 hover:text-white transition">Privacy</a> <a href="terms-conditions"
                                class="text-gray-400 hover:text-white transition">Terms</a> <a href="legal"
                                class="text-gray-400 hover:text-white transition">Legal</a> </div>
                    </div>
                </div>
            </div>
        </footer>

        <!-- Contact Modal -->
        <div id="contactModal" class="modal fixed inset-0 z-50 flex items-center justify-center opacity-0 invisible transition duration-300 bg-black bg-opacity-70">
            <div class="modal-content bg-gray-800 rounded-xl shadow-xl w-full max-w-md mx-4 transform translate-y-10">
                <div class="p-6">
                    <div class="flex justify-between items-center mb-4">
                        <h3 class="text-2xl font-bold text-white">Enquire</h3>
                        <button class="c-info-toggle text-gray-400 hover:text-white"><i class="fas fa-times"></i></button>
                    </div>
                    <form id="contact-form" method="post" autocomplete="off" class="space-y-4">
                        <div>
                            <label for="name" class="block text-sm font-medium text-gray-300 mb-1">Full Name</label>
                            <input type="text" name="name" required class="w-full px-4 py-2 border border-gray-600 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 bg-gray-800">
                        </div>
                        <div>
                            <label for="email-address" class="block text-sm font-medium text-gray-300 mb-1">Email Address</label>
                            <input type="email" name="email-address" required class="w-full px-4 py-2 border border-gray-600 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 bg-gray-800">
                        </div>
                        <div>
                            <label for="subject" class="block text-sm font-medium text-gray-300 mb-1">Subject</label>
                            <select name="subject" class="w-full px-4 py-2 border border-gray-600 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 bg-gray-800">
                                <option value="0">Select a subject</option>
                                <option value="Account">Account Inquiry</option>
                                <option value="Support">Technical Support</option>
                                <option value="Feedback">Feedback</option>
                                <option value="Other">Other</option>
                            </select>
                        </div>
                        <div>
                            <label for="message" class="block text-sm font-medium text-gray-300 mb-1">Message</label>
                            <textarea name="message" required rows="4" class="w-full px-4 py-2 border border-gray-600 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 bg-gray-800"></textarea>
                        </div>
                        <div class="pt-2">
                            <button type="submit" name="chat" id="chat" class="w-full bg-blue-600 hover:bg-blue-700 text-white py-3 rounded-lg font-semibold transition">Send Message</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <!-- Back to Top Button -->
        <button id="backToTop" onclick="scrollToTop()"
            class="fixed bottom-12 right-16 bg-blue-600 text-white p-3 rounded-full shadow-lg hover:bg-blue-700 transition">
            <i class="fas fa-arrow-up"></i>
        </button>

        <!-- Theme Toggle Button -->
        <button id="themeToggle"
            class="fixed bottom-12 right-6 bg-blue-600 text-white p-3 rounded-full shadow-lg hover:bg-blue-700 transition">
            <i class="fas fa-moon"></i>
        </button>

        <script src="assets/scripts/toast-notify.js"></script>

        <script>
        
            const root = document.documentElement; // HTML Element

            // let theme = root.getAttribute('data-theme'); // Current Theme

            // Theme Handling

            function applyTheme() { // Automatically Apply / Recall Theme
                const systemPreferenceDark = window.matchMedia('(prefers-color-scheme: dark)').matches;
                
                // Check localStorage and system preference
                if (localStorage.pageClass === 'darkmode' || (systemPreferenceDark && localStorage.pageClass === undefined)) {
                    root.setAttribute('data-theme', 'dark');
                }
            }

            applyTheme(); // Initial Call

            function indicator() { // Theme Switch Icon Switch

                const indicator = document.querySelector('#themeToggle');

                const theme = root.getAttribute('data-theme'); // Current Theme

                if (indicator) {

                    icon = (theme == 'dark') ? '<i class="fas fa-sun"></i>' : '<i class="fas fa-moon"></i>';

                    indicator.innerHTML = icon; // Update Icon

                }
            }

            function themeSwap() { // Toggle Theme

                const theme = root.getAttribute('data-theme'); // Current Theme

                let toggle = document.querySelector('#themeToggle');

                if (theme === 'dark') {

                    root.setAttribute('data-theme', 'light');

                    localStorage.setItem('pageClass', '');

                } else {

                    root.setAttribute('data-theme', 'dark');

                    localStorage.setItem('pageClass', 'darkmode');

                }

                indicator();

            }

            // Attach Theme Functions

            document.addEventListener("DOMContentLoaded", () => {

                indicator();

                let toggle = document.querySelector('#themeToggle');

                if (toggle) {

                    toggle.addEventListener("click", themeSwap);

                }   

            });

            // Mobile Navigation

            document.addEventListener("DOMContentLoaded", () => {

                let toggles = document.querySelectorAll('.menuBtn');

                let nav = document.querySelector('#mobileNav');

                if (nav) {

                    document.addEventListener("keydown", (e) => {

                        if (e.key === 'Escape' && !nav.classList.contains('hidden')) {

                            nav.classList.add('hidden');

                        }

                    });

                    if (toggles.length > 0) {

                        toggles.forEach(toggle => {

                            toggle.addEventListener("click", () => {

                                if (nav.classList.contains('hidden')) {

                                    nav.classList.remove('hidden');

                                } else {

                                    nav.classList.add('hidden');

                                }

                            });

                        });

                    }

                    let links = nav.querySelectorAll('a');

                    if (links.length > 0) {

                        links.forEach(link => {

                            link.addEventListener("click", () => {

                                if (!nav.classList.contains('hidden')) {

                                    nav.classList.add('hidden');

                                }

                            });

                        });

                    }

                }

            });

            // Back to Top button functionality
            const backToTop = document.getElementById('backToTop');
            window.onscroll = function () {
                if (document.body.scrollTop > 200 || document.documentElement.scrollTop > 200) {
                    backToTop.style.display = "block";
                } else {
                    backToTop.style.display = "none";
                }
            };

            function scrollToTop() {
                window.scrollTo({
                    top: 0,
                    behavior: 'smooth'
                });
            }

            // Contact Modal

            document.addEventListener("DOMContentLoaded", () => {

                let modal = document.querySelector('#contactModal');

                let triggers = document.querySelectorAll('.c-info-toggle');

                if (modal && triggers.length > 0) {

                    triggers.forEach(trigger => {

                        trigger.addEventListener("click", () => {

                            document.body.style.overflow = (modal.classList.contains('active')) ? 'auto' : 'hidden';

                            modal.classList.toggle('active');

                        });

                    });

                }

            });

            // FAQ Opener

            document.addEventListener("DOMContentLoaded", () => {

                let items = document.querySelectorAll('.faq-item');

                if (items.length > 0) {

                    items.forEach((item, index) => {

                        item.addEventListener("click", () => {

                            items.forEach((otherItem, otherIndex) => {
                                let otherContent = otherItem.querySelector('.faq-content');
                                let otherIndicator = otherItem.querySelector('.ind-icon');

                                if (otherIndex !== index) {
                                    // Close other items
                                    otherContent.classList.add('hidden');
                                    otherIndicator.innerHTML = '+';
                                }
                            });

                            let content = item.querySelector('.faq-content');

                            let indicator = item.querySelector('.ind-icon');

                            let icon = (content.classList.contains('hidden')) ? '-' : '+';

                            indicator.innerHTML = icon;

                            content.classList.toggle('hidden');

                        });

                    });

                }

            });

            function initBtnLoader(button) { // Start Button Loader

                let content = `<div class="inline-flex items-center text-sm">
                    <span class="inline-block w-4 h-4 border-2 border-current border-t-transparent rounded-full animate-spin"></span>
                </div>`;

                button.disabled = true;

                button.innerHTML = content;
                
                if (button.disabled) return;

            }

            function stopBtnLoader(button, content) { // End Button Loader

                button.disabled = false;

                button.innerHTML = content;

            }

            // Contact Form Handler

            document.addEventListener("DOMContentLoaded", () => {

                let form = document.querySelector('#contact-form');

                let button = document.querySelector('#chat');

                const popup = document.querySelector('#contactModal');

                if (form && button) {

                    form.addEventListener("submit", async (event) => {

                        event.preventDefault(); // Prevent Submission

                        let content = button.innerHTML; // Hold Original Button Content

                        initBtnLoader(button); // Start Loading Sequence

                        const subject = form.querySelector('select[name="subject"]');

                        if (subject && subject.value == 0) {

                            setTimeout(() => {

                                toast({

                                    text: 'Specify message subject!',

                                    type: 'warning',

                                    duration: 4000

                                });

                                subject.focus();

                                stopBtnLoader(button, content)

                            }, 1200);

                        } else {

                            try {

                                // Initiate Process Form

                                let formData = new FormData(form); // Gain Form Data

                                let processor = await fetch('controls/logic/contact-processor.php', {

                                    method: 'POST',

                                    body: formData

                                }); // Handler, Credentials

                                let response = await processor.json(); // Parse JSON Response

                                // Handle Response

                                if (response.sent) {

                                    setTimeout(() => {

                                        toast({

                                            text: 'Enquiry sent!',

                                            type: 'success',

                                            duration: 7000

                                        });

                                        stopBtnLoader(button, content); // End Loading Sequence

                                        form.reset(); // Reset Form

                                        if (popup) {

                                            popup.classList.remove('active');

                                        }

                                    }, 1200);

                                } else {

                                    setTimeout(() => {

                                        toast({

                                            text: 'Couldn\'t send enquiry!',

                                            type: 'warning',

                                            duration: 7000

                                        });

                                        stopBtnLoader(button, content); // End Loading Sequence

                                    }, 1200);

                                }

                            } catch (error) {

                                console.error('Error:', error);

                                setTimeout(() => {

                                    toast({

                                        text: 'Unable to process request!',

                                        type: 'error',

                                        duration: 7000

                                    });

                                    stopBtnLoader(button, content); // End Loading Sequence

                                }, 1200);

                            }

                        }    

                    });

                }

            });

            function buildCounter(el) {
                const targetText = el.getAttribute("data-counter");
                const match = targetText.match(/^([0-9.]+)(.*)$/); // split numbers + suffix
                if (!match) return;

                const numberPart = match[1];
                const suffix = match[2] || "";

                el.innerHTML = ""; // reset
                el.classList.add("inline-flex", "overflow-hidden"); // remove spacing

                [...numberPart].forEach(char => {
                if (char === ".") {
                    el.insertAdjacentHTML("beforeend", `<span class="w-2 text-center">.</span>`);
                    return;
                }

                const digit = document.createElement("div");
                digit.className = "relative h-9 w-5 overflow-hidden"; // digit box
                const inner = document.createElement("div");
                inner.className = "absolute top-0 left-0 transition-transform duration-1000 ease-out";

                for (let i = 0; i < 10; i++) {
                    const span = document.createElement("span");
                    span.className = "block text-center h-9 leading-9";
                    span.textContent = i;
                    inner.appendChild(span);
                }

                digit.appendChild(inner);
                el.appendChild(digit);
                });

                if (suffix) {
                const s = document.createElement("span");
                s.className = "ml-0 opacity-0 transition-opacity duration-500 ease-in suffix";
                s.textContent = suffix;
                el.appendChild(s);
                }
            }

            function animateCounter(el) {
                const numberPart = el.getAttribute("data-counter").match(/^([0-9.]+)/)[1];
                const digits = el.querySelectorAll(".relative.h-9.w-5.overflow-hidden"); 
                let digitIndex = 0;

                [...numberPart].forEach(char => {
                if (char === ".") return;
                const targetDigit = parseInt(char, 10);
                const inner = digits[digitIndex].querySelector("div");
                inner.style.transform = `translateY(-${targetDigit * 2.25}rem)`; // matches h-9
                digitIndex++;
                });

                // delayed suffix
                const suffix = el.querySelector(".suffix");
                if (suffix) {
                setTimeout(() => suffix.classList.add("opacity-100"), 1100);
                }
                
                // after full animation, clean up → plain text only
                setTimeout(() => {
                    el.textContent = el.getAttribute("data-counter");
                }, 1600); // 1s scroll + 0.5s suffix fade

            }

            const observer = new IntersectionObserver(entries => {
                entries.forEach(entry => {
                const el = entry.target;
                if (entry.isIntersecting) {
                    buildCounter(el);
                    setTimeout(() => animateCounter(el), 100);
                } else {
                    el.innerHTML = el.getAttribute("data-counter"); // reset to raw text
                }
                });
            }, { threshold: 0.3 });

            document.querySelectorAll("[data-counter]").forEach(el => {
                el.style.whiteSpace = "nowrap"; // prevent wrapping
                observer.observe(el);
            });

        </script>

        <?php

            // Extra JS Code
        
            if (isset($extraScripts)) {

                echo $extraScripts;

            }
        
        ?>

        <!-- GTranslate -->

        <script>window.gtranslateSettings = {"default_language":"en","native_language_names":true,"detect_browser_language":true,"wrapper_selector":".gtranslate_wrapper","flag_size":16}</script>
        <script src="https://cdn.gtranslate.net/widgets/latest/popup.js" defer></script>

    </body>

</html>