<?php

    require('partials/landing-header.php');

?>

<main class="max-w-4xl mx-auto px-6 py-12">
    <h1 class="text-4xl font-bold mb-8 text-center text-blue-650"><span translate="no"><?= SITE_NAME ?></span> Privacy Policy</h1>
    <p class="text-sm mb-8">Effective Date: [Insert Date]</p>

    <p class="mb-6">
        At <span class="font-semibold" translate="no"><?= SITE_NAME ?></span>, your privacy is our top priority. This Privacy Policy explains how we collect, use, disclose, and protect your personal information when you use our services, website, and mobile applications.
    </p>

    <section class="mb-8">
        <h2 class="text-2xl font-semibold mb-4 text-blue-650">1. Information We Collect</h2>
        <p class="mb-4">
            We collect information to provide better banking services to you. This may include:
        </p>
        <ul class="list-disc list-inside space-y-2">
            <li><strong>Personal Identification Information:</strong> Name, address, date of birth,  government-issued ID details, contact information.</li>
            <li><strong>Financial Information:</strong> Account numbers, transaction history, credit and debit card details, loan information.</li>
            <li><strong>Technical Data:</strong> IP address, device information, browser type, and usage data from our website and apps.</li>
            <li><strong>Communication Data:</strong> Records of interactions with our customer service, including emails, calls, and chat messages.</li>
        </ul>
    </section>

    <section class="mb-8">
        <h2 class="text-2xl font-semibold mb-4 text-blue-650">2. How We Use Your Information</h2>
        <p class="mb-4">
            We use your information to:
        </p>
        <ul class="list-disc list-inside space-y-2">
            <li>Provide and manage your accounts and banking services.</li>
            <li>Process transactions and payments securely.</li>
            <li>Comply with legal and regulatory requirements.</li>
            <li>Improve our services and customer experience.</li>
            <li>Communicate with you about your account, products, services, and promotions.</li>
            <li>Detect and prevent fraud and unauthorized activities.</li>
        </ul>
    </section>

    <section class="mb-8">
        <h2 class="text-2xl font-semibold mb-4 text-blue-650">3. Sharing Your Information</h2>
        <p class="mb-4">
            We do not sell your personal information. We may share information with:
        </p>
        <ul class="list-disc list-inside space-y-2">
            <li>Service providers who assist us in delivering our services.</li>
            <li>Regulatory bodies and law enforcement as required by law.</li>
            <li>Other financial institutions for joint marketing or service provision, with your consent.</li>
        </ul>
    </section>

    <section class="mb-8">
        <h2 class="text-2xl font-semibold mb-4 text-blue-650">4. Data Security</h2>
        <p>
            We implement industry-standard security measures to protect your information from unauthorized access, alteration, disclosure, or destruction. This includes encryption, secure servers, and regular security assessments.
        </p>
    </section>

    <section class="mb-8">
        <h2 class="text-2xl font-semibold mb-4 text-blue-650">5. Your Rights</h2>
        <p class="mb-4">
            You have the right to:
        </p>
        <ul class="list-disc list-inside space-y-2">
            <li>Access, correct, or delete your personal information.</li>
            <li>Opt-out of marketing communications.</li>
            <li>Withdraw consent where applicable.</li>
            <li>Request information on how your data is used.</li>
        </ul>
    </section>

    <section class="mb-8">
        <h2 class="text-2xl font-semibold mb-4 text-blue-650">6. Data Retention</h2>
        <p>
            We retain your information as long as necessary to provide our services and comply with legal obligations.
        </p>
    </section>

    <section class="mb-8">
        <h2 class="text-2xl font-semibold mb-4 text-blue-650">7. Changes to This Privacy Policy</h2>
        <p>
            We may update this policy from time to time. We will notify you of significant changes via email or on our website.
        </p>
    </section>

    <section>
        <h2 class="text-2xl font-semibold mb-4 text-blue-650">8. Contact Us</h2>
        <p>
            If you have questions or concerns about your privacy, please contact us at:
        </p>
        <ul class="list-none space-y-2 mt-3">
            <li><strong>Email:</strong> <a href="mailto:<?= SUPPORT_MAIL ?>" class="text-blue-600 hover:underline"><?= SUPPORT_MAIL ?></a></li>
            <li><strong>Phone:</strong> <a href="tel:<?= BANK_PHONE ?>" class="text-blue-600 hover:underline"><?= BANK_PHONE ?></a></li>
            <li><strong>Address:</strong> 123 Finance Street, Suite 100, City, State, ZIP</li>
        </ul>
    </section>
</main>

<?php

    require('partials/landing-footer.php');

?>