<?php

    require('partials/landing-header.php');

?>

<main class="max-w-4xl mx-auto px-6 py-12">
    <h1 class="text-4xl font-bold mb-8 text-center text-blue-650"><span translate="no"><?= SITE_NAME ?></span> Terms and Conditions</h1>
    <p class="text-sm mb-8">Effective Date: [Insert Date]</p>

    <p class="mb-6">
      Welcome to <span translate="no"><?= SITE_NAME ?></span>! By using our website, mobile app, and banking services, you agree to the following terms and conditions. Please read them carefully.
    </p>

    <section class="mb-8">
      <h2 class="text-2xl font-semibold mb-4 text-blue-650">1. Acceptance of Terms</h2>
      <p class="mb-4">
        By accessing or using our services, you agree to comply with and be bound by these Terms and Conditions. If you do not agree to these terms, please refrain from using our services.
      </p>
    </section>

    <section class="mb-8">
      <h2 class="text-2xl font-semibold mb-4 text-blue-650">2. Account Eligibility</h2>
      <p class="mb-4">
        You must be at least 18 years old and legally capable of entering into a binding contract to use our services. By registering an account, you confirm that you meet these eligibility requirements.
      </p>
    </section>

    <section class="mb-8">
      <h2 class="text-2xl font-semibold mb-4 text-blue-650">3. Use of Services</h2>
      <p class="mb-4">
        You agree to use our services only for lawful purposes. You may not engage in activities that violate any laws or infringe upon the rights of others. You also agree to use our services responsibly and in compliance with any applicable regulations.
      </p>
    </section>

    <section class="mb-8">
      <h2 class="text-2xl font-semibold mb-4 text-blue-650">4. Privacy Policy</h2>
      <p class="mb-4">
        Our Privacy Policy governs the collection and use of your personal data. By using our services, you consent to our Privacy Policy, which is incorporated by reference into these Terms and Conditions. Please review our Privacy Policy for more information on how we protect your data.
      </p>
    </section>

    <section class="mb-8">
      <h2 class="text-2xl font-semibold mb-4 text-blue-650">5. Fees and Charges</h2>
      <p class="mb-4">
        You agree to pay all fees and charges associated with the services provided by <span translate="no"><?= SITE_NAME ?></span>. These may include account maintenance fees, transaction fees, or other charges as described on our website or in your account agreement.
      </p>
    </section>

    <section class="mb-8">
      <h2 class="text-2xl font-semibold mb-4 text-blue-650">6. Limitation of Liability</h2>
      <p class="mb-4">
        <span translate="no"><?= SITE_NAME ?></span> will not be held liable for any indirect, incidental, special, or consequential damages arising from the use or inability to use our services, even if we have been advised of the possibility of such damages. Our total liability will not exceed the amount paid for the specific service in question.
      </p>
    </section>

    <section class="mb-8">
      <h2 class="text-2xl font-semibold mb-4 text-blue-650">7. Termination of Service</h2>
      <p class="mb-4">
        <span translate="no"><?= SITE_NAME ?></span> reserves the right to suspend or terminate your account or access to services at any time if we suspect fraudulent activities, non-compliance with these terms, or if you breach any terms of use.
      </p>
    </section>

    <section class="mb-8">
      <h2 class="text-2xl font-semibold mb-4 text-blue-650">8. Changes to Terms</h2>
      <p class="mb-4">
        <span translate="no"><?= SITE_NAME ?></span> may modify these Terms and Conditions at any time. We will notify you of any significant changes through email or on our website. Continued use of our services after such modifications will constitute your acceptance of the updated terms.
      </p>
    </section>

    <section class="mb-8">
      <h2 class="text-2xl font-semibold mb-4 text-blue-650">9. Governing Law</h2>
      <p class="mb-4">
        These Terms and Conditions are governed by and construed in accordance with the laws of [Your Jurisdiction], without regard to its conflict of law principles. Any disputes arising out of or in connection with these terms shall be resolved through arbitration or in the courts of [Your Jurisdiction].
      </p>
    </section>

    <section>
      <h2 class="text-2xl font-semibold mb-4 text-blue-650">10. Contact Us</h2>
      <p class="mb-4">
        If you have any questions about these Terms and Conditions, please contact us at:
      </p>
      <ul class="list-none space-y-2 mt-3">
          <li><strong>Email:</strong> <a href="mailto:<?= SUPPORT_MAIL ?>" class="text-blue-600 hover:underline"><?= SUPPORT_MAIL ?></a></li>
          <li><strong>Phone:</strong> <a href="tel:<?= BANK_PHONE ?>" class="text-blue-600 hover:underline"><?= BANK_PHONE ?></a></li>
          <li><strong>Address:</strong> 123 Finance Street, Suite 100, City, State, ZIP</li>
      </ul>
    </section>
  </main>

<?php

    require('partials/landing-footer.php');

?>