// Panel Nav System

document.addEventListener("DOMContentLoaded", () => {

    // Get all panel triggers

    const panelTriggers = document.querySelectorAll('.iQ_panelSwitch');

    if (panelTriggers) {
        
        // Set the first panel trigger as active by default
        if (panelTriggers.length > 0) {
            panelTriggers[0].classList.add('active');
        }

        // Loop through each panel trigger
        panelTriggers.forEach((trigger, index) => {
            // Add click event listener to each trigger
            trigger.addEventListener('click', () => {
                // Check if the clicked trigger already has the active class
                if (!trigger.classList.contains('active')) {
                    // Remove active class from all triggers
                    panelTriggers.forEach(trigger => {
                        trigger.classList.remove('active');
                    });
                    // Add active class to the clicked trigger
                    trigger.classList.add('active');

                    // Remove n_displ class from all panels
                    const panels = document.querySelectorAll('.iQ_panel');
                    panels.forEach(panel => {
                        panel.classList.add('n_displ');
                    });

                    // Remove n_displ class from corresponding panel
                    const correspondingPanel = document.querySelectorAll('.iQ_panel')[index];
                    correspondingPanel.classList.remove('n_displ');
                    correspondingPanel.classList.add('fade');
                }
            });
        });

        // Set the first panel to be displayed by default
        const panels = document.querySelectorAll('.iQ_panel');
        if (panels.length > 0) {
            panels[0].classList.remove('n_displ');
        }

    }


});


// Panel Nav System V2

document.addEventListener("DOMContentLoaded", function() {

    const panelTriggers = document.querySelectorAll('.iQ_panelSwitch[data-tab]');
    const panels = document.querySelectorAll('.iQ_panel');
    const params = new URLSearchParams(window.location.search);
    const tabId = params.get("searchType");

    function activatePanel(tabId) {
        panelTriggers.forEach(trigger => {
            const tab = trigger.getAttribute('data-tab');
            if (tab === tabId) {
                trigger.classList.add('active');
            } else {
                trigger.classList.remove('active');
            }
        });

        panels.forEach(panel => {
            if (panel.id === tabId) {
                panel.classList.remove('n_displ');
                panel.classList.add('fade');
            } else {
                panel.classList.add('n_displ');
                panel.classList.remove('fade');
            }
        });

        // Update URL
        if (tabId) {
            const newUrl = new URL(window.location);
            newUrl.searchParams.set('tab', tabId);
            window.history.pushState({ path: newUrl.href }, '', newUrl.href);
        }
    }

    if (tabId) {
        activatePanel(tabId);
    } else if (panelTriggers.length > 0) {
        panelTriggers[0].classList.add('active');
        panels[0].classList.remove('n_displ');
        panels[0].classList.add('fade');
    }

    panelTriggers.forEach(trigger => {
        trigger.addEventListener('click', () => {
            const tab = trigger.getAttribute('data-tab');
            if (!trigger.classList.contains('active')) {
                activatePanel(tab);
            }
        });
    });

});

// Copy URL

document.addEventListener("DOMContentLoaded", () => {

    let copier = document.querySelector('#copier');

    if (copier) {

        let text = window.location.href;

        copier.addEventListener("click", () => {

            let content = "Copy URL";

            copier.disabled = true;

            // Copy Text

            navigator.clipboard.writeText(text).then(() => {

                copier.innerHTML = 'Copied to Clipboard';

                setTimeout(() => {

                    copier.innerHTML = content;

                    copier.disabled = false;

                }, 1200);

            }).catch(error => {

                console.error('Error:', error);

                copier.disabled = false;

            });

        });

    }

});

// Preloader

document.addEventListener("DOMContentLoaded", () => {

    let preloader = document.querySelector('#preloader');

    let content = document.querySelector('#results');

    if (preloader && content) {

        setTimeout(() => {

            content.classList.remove('n_displ');

            preloader.remove();

        }, 1000);

    }

});

// Search Button

document.addEventListener("DOMContentLoaded", () => {

    let button = document.querySelector('#search');

    if (button) {

        button.addEventListener("click", () => {

            window.location.href = 'search';            

        });

    }

});