<?php

    session_name('USERSESSID');

    session_start();

    require('../controls/config/config.php'); // Configuration File

    require('../controls/engines/fxns.php'); // Custom Functions

    $found = false; // Flag

    if (isset($_REQUEST['uetr']) && !empty($_REQUEST['uetr'])) {

        $uetr = filter_var($_REQUEST['uetr'], FILTER_SANITIZE_SPECIAL_CHARS);

        // Look For Receipt

        $stmt = mysqli_prepare($conn, "SELECT `A`.*, `B`.`fname`, `B`.`mname`, `B`.`lname` FROM `transactions` AS `A` LEFT JOIN `users` AS `B` ON `A`.`user_id` = `B`.`user_id` WHERE `A`.`uetr` = ?");

        mysqli_stmt_bind_param($stmt, "s", $uetr); // Bind Parameter(s)

        mysqli_stmt_execute($stmt);

        $result = mysqli_stmt_get_result($stmt);

        if (mysqli_num_rows($result) === 1) {

            $found = true; // Update Flag

            $data = mysqli_fetch_all($result, MYSQLI_ASSOC);

        }

        mysqli_free_result($result);

        mysqli_stmt_close($stmt);

    }

?>


<!DOCTYPE html>

<html lang="en">

<head>

    <meta charset="UTF-8">

    <meta http-equiv="X-UA-Compatible" content="ie=edge">

    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <link rel="stylesheet" href="assets/stylesheets/style.css">

    <script>
        (function() {
            const page = document.documentElement; //|| document.body; // Ensure it's the right element to modify

            // Check system preference and localStorage immediately
            const systemPreferenceDark = window.matchMedia('(prefers-color-scheme: dark)').matches;

            // Apply theme if dark mode is preferred by the user or if stored in localStorage
            if (localStorage.pageClass === 'darkmode' || (systemPreferenceDark && localStorage.pageClass === undefined)) {
                page.classList.add('darkmode');
            }
        })();
    </script>

    <link rel="icon" href="<?= SITE_FAVICON ?>">

    <title>Payment Tracker | <?= SITE_NAME ?></title>

</head>

<body>

    <div class="app_box" id="preloader">

        <div class="appBox_con">

            <div class="header">

                <p class="main-heading">Payment Status</p>

                <p>Loading...</p>

            </div>    

        </div>

    </div>

    <div class="app_box n_displ" id="results">

        <div class="appBox_con">

            <div class="language-selector">

                <div class="gtranslate_wrapper"></div>

            </div>

            <div class="header">

                <p class="main-heading">Payment Status</p>

                <div class="details">

                    <div class="header-section">

                        <h3 class="section-title">Search Details</h3>

                        <button class="app_btn v2 sm" id="search">New Search</button>

                    </div>

                    <div class="details-cnt">

                        <div class="details-entry">

                            <div class="entry-wrapper">

                                <h5>UETR</h5>
                                <p><?= isset($uetr) ? $uetr : '-' ?></p>

                            </div>

                            <?php
                            
                                if (!isset($uetr)) { ?>

                                    <div class="entry-wrapper">

                                        <h5>Payment Reference</h5>
                                        <p><?= isset($ref) ? $ref : '-' ?></p>

                                    </div>


                               <?php }
                            
                            ?>    

                            <div class="entry_wrapper"></div>

                        </div>

                        <div class="details-entry">
                            
                            <div class="entry-wrapper">

                                <h5>Instructed Amount</h5>
                                <p><?= isset($amount) ? $amount : '0.00' ?></p>

                            </div>

                            <div class="entry-wrapper">

                                <h5>Currency</h5>
                                <p><?= isset($currency) ? $currency : '-' ?></p>

                            </div> 
                            
                            <div class="entry-wrapper">

                                <h5>Date</h5>
                                <p><?= isset($date) ? $date : '-' ?></p>

                            </div>

                        </div>

                    </div>

                </div>

            </div>

        </div>

        <?php

            if ($found) {

                echo '<h3 class="section-title">Transaction History</h3>';

            }
            
        ?>    

        <div class="history">

            <div class="appBox_con">

                <div class="history-cnt">

                    <?php

                        $salute = null;

                        $title = 'Error';

                        $status = '<p class="error">No results have been found. Please try a <u><a href="search">New Search</a></u><p>';

                        if ($found) {

                            $salute = 'Welcome, ';

                            // Display Data
                        
                            foreach ($data as $row):

                                $currency = $row['currency'];

                                $symbol = $currSymbol[$currency] ?? null;

                                $amount = $symbol . number_format($row['amount'], 2);

                                $created = date('d-m-y', strtotime($row['date']));

                                $updated = date('d-m-Y; g:i', strtotime($row['date']));

                                $sender = join(' ', [$row['fname'], $row['mname'], $row['lname']]);

                                $beneficiary = $row['recpt_name'] ?? '-';

                                $status = $row['status'];

                                $request = null;

                                $bankCode = $row['banking_codetype'];

                                $code = $row['banking_code'];

                                $destination = $row['recpt_bank'];

                                $recipientAcc = $row['recpt_acc'];

                                $dispute = null;

                                $narration = null;

                                if ($status == 'COMPLETED') {

                                    $status = '<p class="success">Payment Received<p>';

                                } else if ($status == 'PENDING') {

                                    $status = '<p class="info">Payment is been processed<p>';

                                } else {

                                    $status = '<p class="rejected">Payment ' . ucwords(strtolower($status)) . '<p>';

                                }

                                $salute .= isset($_SESSION['USER-ID']) ? $sender : $beneficiary;

                            endforeach;

                        }   

                    ?>

                    <div class="header-section">
                        <?php

                            if (!$found) {

                                echo '<h3 class="section-title">' . $title . '</h3>';

                            }
                            
                            if ($salute) {

                                echo '<h3 class="section-title">' . $salute .    '</h3>';

                            }

                        ?>    
                        
                    </div>

                    <div class="details-cnt">
                        <div class="details-entry">
                            <div class="entry-wrapper flx">
                                <h5>Status</h5>
                                <?= $status ?>
                            </div>

                            <?php

                                if ($found) { ?>
                        
                                <div class="entry-wrapper flx">
                                    <h5>Share Results</h5>
                                    <button class="app_btn sm" id="copier">Copy URL</button>
                                </div>

                                <?php }
                            ?>    
                        </div>

                        <?php
                        
                            if ($found) { ?>

                                <table>

                                    <tbody>

                                        <tr>

                                            <td>

                                                <div class="entry-wrapper">
                                                    <h5>Currency</h5>
                                                    <p><?= $currency ?></p>
                                                </div>        

                                            </td>

                                            <td>

                                                <div class="entry-wrapper">
                                                    <h5>Instructed Amount</h5>
                                                    <p><?= $amount ?></p>
                                                </div>

                                            </td>

                                        </tr>

                                        <tr>

                                            <td>

                                                <div class="entry-wrapper">
                                                    <h5>Value Date</h5><time datetime="dd-mm-yyyy"><?= $created ?></time>
                                                </div>

                                            </td>

                                            <td>

                                                <div class="entry-wrapper">
                                                    <h5>Last Update (UTC)</h5><time datetime="dd-mm-yyyy; h:mm"><?= $updated ?></time>
                                                </div>

                                            </td>

                                        </tr>

                                        <tr>

                                            <td>

                                                <div class="entry-wrapper">
                                                    <h5>Sender</h5>
                                                    <p><?= $sender ?></p>
                                                </div>

                                            </td>

                                            <td>

                                                <div class="entry-wrapper">
                                                    <h5>Beneficiary</h5>
                                                    <p><?= $beneficiary ?></p>
                                                </div>

                                            </td>

                                        </tr>

                                        <tr>

                                            <td>

                                                <div class="entry-wrapper">
                                                    <h5>Destination / Bank</h5>
                                                    <p><?= $destination ?></p>
                                                </div>

                                            </td>

                                            <td>

                                                <div class="entry-wrapper">
                                                    <h5>Beneficiary Account</h5>
                                                    <p><?= $recipientAcc ?></p>
                                                </div>

                                            </td>

                                        </tr>

                                        <tr>

                                            <td>

                                                <div class="entry-wrapper">
                                                    <h5>Protocol</h5>
                                                    <p><?= $bankCode ?></p>
                                                </div>

                                            </td>

                                            <td>

                                                <div class="entry-wrapper">
                                                    <h5>Code</h5>
                                                    <p><?= $code ?></p>
                                                </div>

                                            </td>

                                        </tr>

                                        <tr>

                                            <?php

                                                if ($narration != null) { ?>

                                                    <td>

                                                        <div class="entry-wrapper">
                                                            <h5>Narration</h5>
                                                            <p><?= $narration ?></p>
                                                        </div> 

                                                    </td>

                                                <?php }

                                                if ($dispute != null) { ?>

                                                    <td>

                                                        <div class="entry-wrapper">
                                                            <h5>Dispute</h5>
                                                            <p><?= $dispute ?></p>
                                                        </div>

                                                    </td>

                                                <?php }    

                                            ?>

                                        </tr>

                                    </tbody>    

                                </table>

                            <?php }
                        
                        ?>

                    </div>

                </div>

            </div>    

        </div>

    </div>

    <script src="assets/scripts/script.js"></script>

    <!-- GTranslate -->

    <script>window.gtranslateSettings = { "default_language": "en", "native_language_names": true, "detect_browser_language": true, "wrapper_selector": ".gtranslate_wrapper", "flag_size": 16 }</script>
    <script src="https://cdn.gtranslate.net/widgets/latest/popup.js" defer></script>

</body>

</html>