<?php

    require('../controls/config/config.php'); // Configuration File

    require('../controls/engines/fxns.php'); // Custom Functions

    // Form Processors

    if (isset($_REQUEST['uetr-search'])) {

        // Sanitize Field

        $uetr = filter_var($_REQUEST['uetr'], FILTER_SANITIZE_SPECIAL_CHARS);

        // Redirect

        echo '<script>
        
            window.location.href = "results?uetr=' . $uetr . '";
        
        </script>';

        exit;

    }

?>

<!DOCTYPE html>

<html lang="en">

    <head>

        <meta charset="UTF-8">

        <meta http-equiv="X-UA-Compatible" content="ie=edge">

        <meta name="viewport" content="width=device-width, initial-scale=1.0">

        <link rel="stylesheet" href="assets/stylesheets/style.css">

        <script>
            (function() {
                const page = document.documentElement; //|| document.body; // Ensure it's the right element to modify

                // Check system preference and localStorage immediately
                const systemPreferenceDark = window.matchMedia('(prefers-color-scheme: dark)').matches;

                // Apply theme if dark mode is preferred by the user or if stored in localStorage
                if (localStorage.pageClass === 'darkmode' || (systemPreferenceDark && localStorage.pageClass === undefined)) {
                    page.classList.add('darkmode');
                }
            })();
        </script>

        <link rel="icon" href="<?= SITE_FAVICON ?>">

        <title>Payment Tracker | <?= SITE_NAME ?></title>

    </head>

    <body>

        <div class="app_box">

            <div class="logo">

                <img src="<?= SITE_LOGO ?>" alt="" class="light">

                <img src="<?= SITE_LOGO_DARK ?>" alt="" class="dark">

            </div>    

            <div class="appBox_con">

                <div class="language-selector">

                    <div class="gtranslate_wrapper"></div>

                </div>

                <div class="header">

                    <p class="main-heading">Payment Status Search</p>

                    <p class="sub-heading">Please enter your UETR</p>

                    <p class="micro-heading">All fields are mandatory</p>

                </div>

                <div class="main">

                    <div class="iQ_panels">

                        <form>

                            <div class="field_item">

                                <label for="uetr">Unique End-to-End Transaction Reference</label>

                                <input type="text" name="uetr" value="<?= isset($_REQUEST['uetr']) ? $_REQUEST['uetr'] : null ?>" class="app_field" required>

                            </div>

                            <div class="field_item">

                                <button class="app_btn min" type="submit" name="uetr-search">Search</button>

                            </div>

                        </form>

                    </div>

                </div>

            </div>

        </div>

        <script src="assets/scripts/script.js"></script>

        <!-- GTranslate -->

        <script>window.gtranslateSettings = {"default_language":"en","native_language_names":true,"detect_browser_language":true,"wrapper_selector":".gtranslate_wrapper","flag_size":16}</script>
        <script src="https://cdn.gtranslate.net/widgets/latest/popup.js" defer></script>

    </body>

</html>